/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.tts.msp.engine;

import java.io.File;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.actf.ai.tts.ISAPIEngine;
import org.eclipse.actf.ai.tts.ITTSEngineInfo;
import org.eclipse.actf.ai.tts.msp.MspPlugin;
import org.eclipse.actf.ai.tts.msp.engine.ISpNotifySource;
import org.eclipse.actf.ai.tts.msp.engine.ISpVoice;
import org.eclipse.actf.ai.tts.msp.engine.SpObjectToken;
import org.eclipse.actf.ai.tts.msp.engine.SpeechObjectTokens;
import org.eclipse.actf.ai.voice.IVoiceEventListener;
import org.eclipse.actf.util.win32.COMUtil;
import org.eclipse.actf.util.win32.MemoryUtil;
import org.eclipse.actf.util.win32.NativeIntAccess;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.internal.ole.win32.GUID;
import org.eclipse.swt.internal.ole.win32.IDispatch;
import org.eclipse.swt.ole.win32.OleAutomation;
import org.eclipse.swt.ole.win32.Variant;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MspVoice
implements ISAPIEngine,
IPropertyChangeListener {
    public static final String ID = "org.eclipse.actf.ai.tts.msp.engine.MspVoice";
    public static final String AUDIO_OUTPUT = "org.eclipse.actf.ai.tts.MspVoice.audioOutput";
    public static final GUID IID_SpFileStream = COMUtil.IIDFromString((String)"{947812B3-2AE1-4644-BA86-9E90DED7EC91}");
    public ISpVoice dispSpVoice;
    private Variant varSapiVoice;
    private OleAutomation automation;
    private int idGetVoices;
    private int idGetAudioOutputs;
    private ISpNotifySource spNotifySource = null;
    private static IPreferenceStore preferenceStore = MspPlugin.getDefault().getPreferenceStore();
    private boolean isDisposed = false;
    private SpObjectToken curVoiceToken = null;
    private Map<String, TreeSet<EngineInfo>> langId2EngineMap = new HashMap<String, TreeSet<EngineInfo>>();
    private Set<ITTSEngineInfo> ttsEngineInfoSet = new TreeSet<ITTSEngineInfo>(new Comparator<ITTSEngineInfo>(){

        @Override
        public int compare(ITTSEngineInfo iTTSEngineInfo, ITTSEngineInfo iTTSEngineInfo2) {
            return iTTSEngineInfo.getName().compareTo(iTTSEngineInfo2.getName());
        }
    });

    public MspVoice() {
        int n = COMUtil.createDispatch((GUID)ISpVoice.IID);
        this.dispSpVoice = new ISpVoice(n);
        this.varSapiVoice = new Variant((IDispatch)this.dispSpVoice);
        this.automation = this.varSapiVoice.getAutomation();
        this.spNotifySource = ISpNotifySource.getNotifySource(this.dispSpVoice);
        MspPlugin.getDefault().addPropertyChangeListener(this);
        this.idGetVoices = this.getIDsOfNames("GetVoices");
        this.idGetAudioOutputs = this.getIDsOfNames("GetAudioOutputs");
        String string = preferenceStore.getString(ID);
        preferenceStore.setValue(ID, preferenceStore.getDefaultString(ID));
        this.setAudioOutputName();
        preferenceStore.setValue(ID, string);
        this.setVoiceName();
        Variant variant = this.getVoices(null, null);
        if (variant != null) {
            SpeechObjectTokens speechObjectTokens = SpeechObjectTokens.getTokens(variant);
            if (speechObjectTokens != null) {
                String string2 = Platform.getResourceString((Bundle)MspPlugin.getDefault().getBundle(), (String)"%voice.exclude");
                int n2 = speechObjectTokens.getCount();
                int n3 = 0;
                while (n3 < n2) {
                    SpObjectToken spObjectToken;
                    Variant variant2 = speechObjectTokens.getItem(n3);
                    if (variant2 != null && (spObjectToken = SpObjectToken.getToken(variant2)) != null) {
                        String string3 = spObjectToken.getDescription(0);
                        String string4 = spObjectToken.getAttribute("language");
                        int n4 = string4.indexOf(";");
                        if (n4 > 0) {
                            string4 = string4.substring(0, n4);
                        }
                        String string5 = spObjectToken.getAttribute("gender");
                        if (string2 == null || !string2.equals(string3)) {
                            TreeSet<EngineInfo> treeSet = this.langId2EngineMap.get(string4);
                            if (treeSet == null) {
                                treeSet = new TreeSet<EngineInfo>(new Comparator<EngineInfo>(){

                                    @Override
                                    public int compare(EngineInfo engineInfo, EngineInfo engineInfo2) {
                                        return -engineInfo.name.compareTo(engineInfo2.name);
                                    }
                                });
                                this.langId2EngineMap.put(string4, treeSet);
                            }
                            String string6 = (String)LANGID_REVERSE_MAP.get(string4);
                            EngineInfo engineInfo = new EngineInfo(string3, string6, string4, string5);
                            treeSet.add(engineInfo);
                            this.ttsEngineInfoSet.add(engineInfo);
                        }
                    }
                    ++n3;
                }
            }
            variant.dispose();
        }
        this.stop();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (ID.equals(propertyChangeEvent.getProperty())) {
            this.stop();
            this.setVoiceName();
        } else if (AUDIO_OUTPUT.equals(propertyChangeEvent.getProperty())) {
            this.stop();
            this.setAudioOutputName();
        }
    }

    public void setEventListener(IVoiceEventListener iVoiceEventListener) {
        this.spNotifySource.setEventListener(iVoiceEventListener);
    }

    public void speak(String string, int n, int n2) {
        int n3 = 1;
        if ((1 & n) != 0) {
            n3 |= 2;
        }
        if (n2 >= 0) {
            this.speak("<BOOKMARK mark=\"" + n2 + "\"/>", n3 | 0x20);
            this.speak(string, 1);
            this.speak("<BOOKMARK mark=\"-1\"/>", 33);
        } else {
            this.speak(string, n3);
        }
    }

    public void speak(String string, int n) {
        char[] cArray = (String.valueOf(string) + "\u0000").toCharArray();
        int n2 = MemoryUtil.SysAllocString((char[])cArray);
        try {
            this.dispSpVoice.Speak(n2, n);
        }
        finally {
            MemoryUtil.SysFreeString((int)n2);
        }
    }

    public void stop() {
        this.speak("", 1, -1);
    }

    public boolean setRate(int n) {
        return this.dispSpVoice.put_Rate(n) == 0;
    }

    public int getRate() {
        NativeIntAccess nativeIntAccess = new NativeIntAccess();
        try {
            if (this.dispSpVoice.get_Rate(nativeIntAccess.getAddress()) == 0) {
                int n = nativeIntAccess.getInt();
                return n;
            }
        }
        finally {
            nativeIntAccess.dispose();
        }
        return -1;
    }

    public boolean setVoice(Variant variant) {
        boolean bl;
        boolean bl2 = bl = this.dispSpVoice.put_Voice(variant.getDispatch().getAddress()) == 0;
        if (bl) {
            this.curVoiceToken = SpObjectToken.getToken(variant);
        }
        return bl;
    }

    public boolean setAudioOutput(Variant variant) {
        return this.dispSpVoice.put_AudioOutput(variant != null ? variant.getDispatch().getAddress() : 0) == 0;
    }

    private void setVoiceName() {
        String string = preferenceStore.getString(ID);
        if (string.length() > 0) {
            this.setVoiceName("name=" + string);
        }
    }

    public boolean setVoiceName(String string) {
        Object object;
        boolean bl = false;
        Variant variant = this.getVoices(string, null);
        if (variant != null) {
            SpeechObjectTokens speechObjectTokens = SpeechObjectTokens.getTokens(variant);
            if (speechObjectTokens != null && speechObjectTokens.getCount() > 0 && (object = speechObjectTokens.getItem(0)) != null) {
                bl = this.setVoice((Variant)object);
            }
            variant.dispose();
        }
        if (!bl) {
            int n = string.indexOf("name=");
            variant = this.getVoices(null, null);
            if (variant != null && n > -1) {
                object = string.substring(n + 5);
                SpeechObjectTokens speechObjectTokens = SpeechObjectTokens.getTokens(variant);
                if (speechObjectTokens != null) {
                    int n2 = speechObjectTokens.getCount();
                    int n3 = 0;
                    while (n3 < n2) {
                        SpObjectToken spObjectToken;
                        Variant variant2 = speechObjectTokens.getItem(n3);
                        if (variant2 != null && (spObjectToken = SpObjectToken.getToken(variant2)) != null && ((String)object).equals(spObjectToken.getDescription(0))) {
                            bl = this.setVoice(variant2);
                        }
                        ++n3;
                    }
                }
            }
            variant.dispose();
        }
        return bl;
    }

    private void setAudioOutputName() {
        String string = preferenceStore.getString(AUDIO_OUTPUT);
        if (string.length() > 0) {
            this.setAudioOutputName(string);
        } else {
            this.setAudioOutput(null);
        }
    }

    public boolean setAudioOutputName(String string) {
        boolean bl = false;
        Variant variant = this.getAudioOutputs(null, null);
        if (variant != null) {
            SpeechObjectTokens speechObjectTokens = SpeechObjectTokens.getTokens(variant);
            if (speechObjectTokens != null) {
                int n = 0;
                while (n < speechObjectTokens.getCount()) {
                    SpObjectToken spObjectToken;
                    Variant variant2 = speechObjectTokens.getItem(n);
                    if (variant2 != null && (spObjectToken = SpObjectToken.getToken(variant2)) != null && string.equals(spObjectToken.getDescription(0))) {
                        bl = this.setAudioOutput(variant2);
                        break;
                    }
                    ++n;
                }
            }
            variant.dispose();
        }
        return bl;
    }

    public Variant getVoices(String string, String string2) {
        return this.getTokens(this.idGetVoices, string, string2);
    }

    public Variant getAudioOutputs(String string, String string2) {
        return this.getTokens(this.idGetAudioOutputs, string, string2);
    }

    private Variant getTokens(int n, String string, String string2) {
        if (string == null) {
            return this.automation.invoke(n);
        }
        if (string2 == null) {
            return this.automation.invoke(n, new Variant[]{new Variant(string)});
        }
        return this.automation.invoke(n, new Variant[]{new Variant(string), new Variant(string2)});
    }

    private int getIDsOfNames(String string) {
        int[] nArray = this.automation.getIDsOfNames(new String[]{string});
        if (nArray != null) {
            return nArray[0];
        }
        return 0;
    }

    public void dispose() {
        if (!this.isDisposed) {
            this.isDisposed = true;
            this.varSapiVoice.dispose();
            if (MspPlugin.getDefault() != null) {
                MspPlugin.getDefault().removePropertyChangeListener(this);
            }
        }
    }

    public int getSpeed() {
        int n = this.getRate();
        return (n + 10) * 5;
    }

    public void setSpeed(int n) {
        int n2 = n / 5 - 10;
        this.setRate(n2);
    }

    public void setLanguage(String string) {
        String string2 = null;
        if (this.curVoiceToken != null) {
            string2 = this.curVoiceToken.getAttribute("gender");
        }
        string2 = string2 == null ? "" : "gender=" + string2;
        String string3 = (String)LANGID_MAP.get(string);
        if (string3 == null) {
            if ("ja".equals(string)) {
                string3 = "411";
            } else if ("en".equals(string)) {
                string3 = "409";
            }
        }
        if (string3 == null) {
            return;
        }
        String string4 = "language=" + string3 + ";";
        Variant variant = this.getVoices(String.valueOf(string4) + string2, null);
        if (variant == null && string2.length() > 0) {
            variant = this.getVoices(string4, null);
        }
        if (variant != null) {
            Variant variant2;
            SpeechObjectTokens speechObjectTokens = SpeechObjectTokens.getTokens(variant);
            if (speechObjectTokens != null && speechObjectTokens.getCount() > 0 && (variant2 = speechObjectTokens.getItem(0)) != null) {
                this.setVoice(variant2);
            }
            variant.dispose();
        }
    }

    public void setGender(String string) {
        if (string == null) {
            return;
        }
        String string2 = null;
        if (this.curVoiceToken != null && "409;9".equals(string2 = this.curVoiceToken.getAttribute("language"))) {
            string2 = "409";
        }
        Variant variant = null;
        String string3 = "";
        if (string2 != null) {
            string3 = "language=" + string2 + ";";
        }
        if ("male".equalsIgnoreCase(string)) {
            variant = this.getVoices(String.valueOf(string3) + "gender=Male", null);
        } else if ("female".equalsIgnoreCase(string)) {
            variant = this.getVoices(String.valueOf(string3) + "gender=Female", null);
        }
        if (variant != null) {
            Variant variant2;
            SpeechObjectTokens speechObjectTokens = SpeechObjectTokens.getTokens(variant);
            if (speechObjectTokens != null && speechObjectTokens.getCount() > 0 && (variant2 = speechObjectTokens.getItem(0)) != null) {
                this.setVoice(variant2);
            }
            variant.dispose();
        }
    }

    public boolean isAvailable() {
        return this.automation != null;
    }

    public boolean isDisposed() {
        return this.isDisposed;
    }

    public boolean canSpeakToFile() {
        return true;
    }

    public boolean speakToFile(String string, File file) {
        boolean bl;
        block8: {
            int n = COMUtil.createDispatch((GUID)IID_SpFileStream);
            OleAutomation oleAutomation = null;
            bl = false;
            if (file == null || file.exists() && !file.canWrite()) {
                return false;
            }
            Variant variant = new Variant(new IDispatch(n));
            try {
                oleAutomation = variant.getAutomation();
                String string2 = file.toURI().toString();
                if (string2.startsWith("file:/")) {
                    string2 = string2.substring(6).replaceAll("%20", " ");
                }
                oleAutomation.invoke(100, new Variant[]{new Variant(string2), new Variant(3), new Variant(false)});
                this.dispSpVoice.put_AudioOutputStream(n);
                char[] cArray = (String.valueOf(string) + "\u0000").toCharArray();
                int n2 = MemoryUtil.SysAllocString((char[])cArray);
                try {
                    this.dispSpVoice.Speak(n2, 0);
                }
                finally {
                    MemoryUtil.SysFreeString((int)n2);
                }
                oleAutomation.invoke(101);
                oleAutomation.dispose();
                oleAutomation = null;
                bl = true;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                if (oleAutomation == null) break block8;
                oleAutomation.dispose();
                oleAutomation = null;
            }
        }
        this.setAudioOutputName();
        return bl;
    }

    public Set<ITTSEngineInfo> getTTSEngineInfoSet() {
        return this.ttsEngineInfoSet;
    }

    private class EngineInfo
    implements ITTSEngineInfo {
        String name;
        String lang;
        String langId;
        String gender;

        public EngineInfo(String string, String string2, String string3, String string4) {
            this.name = string;
            this.lang = string2;
            this.langId = string3;
            this.gender = string4;
        }

        public String getName() {
            return this.name;
        }

        public String getLanguage() {
            return this.lang;
        }

        public String getGender() {
            return this.gender;
        }
    }
}

