/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.runtime.impl;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.acceleo.query.ast.Error;
import org.eclipse.acceleo.query.ast.ErrorEnumLiteral;
import org.eclipse.acceleo.query.ast.ErrorTypeLiteral;
import org.eclipse.acceleo.query.parser.AstCompletor;
import org.eclipse.acceleo.query.runtime.ICompletionResult;
import org.eclipse.acceleo.query.runtime.IQueryCompletionEngine;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IValidationResult;
import org.eclipse.acceleo.query.runtime.impl.CompletionResult;
import org.eclipse.acceleo.query.runtime.impl.CompletionServices;
import org.eclipse.acceleo.query.runtime.impl.QueryValidationEngine;
import org.eclipse.acceleo.query.validation.type.IType;

public class QueryCompletionEngine
implements IQueryCompletionEngine {
    private IReadOnlyQueryEnvironment queryEnvironment;

    public QueryCompletionEngine(IReadOnlyQueryEnvironment queryEnvironment) {
        this.queryEnvironment = queryEnvironment;
    }

    @Override
    public ICompletionResult getCompletion(String expression, int offset, Map<String, Set<IType>> variableTypes) {
        AstCompletor completor = new AstCompletor(new CompletionServices(this.queryEnvironment));
        if (offset < 0 || expression != null && offset > expression.length()) {
            throw new IllegalArgumentException("offset (" + offset + ") must be in the range of the given expression: \"" + expression + "\"");
        }
        String prefix = this.getPrefix(expression, offset);
        String remaining = this.getRemaining(expression, offset);
        String toParse = this.getToParse(expression, offset, prefix);
        QueryValidationEngine builder = new QueryValidationEngine(this.queryEnvironment);
        IValidationResult validationResult = builder.validate(toParse, variableTypes);
        CompletionResult result = new CompletionResult(completor.getProposals(variableTypes.keySet(), validationResult));
        result.setPrefix(prefix);
        result.setRemaining(remaining);
        int replacementLength = 0;
        int replacementOffset = 0;
        if (toParse != null) {
            replacementOffset = toParse.length();
        }
        List<Error> errors = validationResult.getAstResult().getErrors();
        for (Error error : errors) {
            if (!(error instanceof ErrorTypeLiteral) && !(error instanceof ErrorEnumLiteral)) continue;
            int errorStart = validationResult.getAstResult().getStartPosition(error);
            int errorEnd = validationResult.getAstResult().getEndPosition(error);
            if (errorStart > offset - prefix.length() || offset - prefix.length() > errorEnd) continue;
            replacementOffset = validationResult.getAstResult().getStartPosition(error);
            replacementLength = validationResult.getAstResult().getEndPosition(error) - replacementOffset;
            break;
        }
        if (prefix != null) {
            replacementLength += prefix.length();
        }
        result.setReplacementOffset(replacementOffset);
        result.setReplacementLength(replacementLength);
        return result;
    }

    private String getPrefix(String expression, int offset) {
        String result;
        if (expression == null) {
            result = null;
        } else {
            int start = offset;
            while (start - 1 >= 0) {
                char charAt = expression.charAt(start - 1);
                if (!Character.isLetter(charAt) && !Character.isDigit(charAt) && charAt != '_') break;
                --start;
            }
            result = expression.substring(start, offset);
        }
        return result;
    }

    private String getRemaining(String expression, int offset) {
        String result;
        if (expression == null) {
            result = null;
        } else {
            int length = expression.length();
            int end = offset;
            while (end < length) {
                char charAt = expression.charAt(end);
                if (!Character.isLetter(charAt) && !Character.isDigit(charAt) && charAt != '_') break;
                ++end;
            }
            result = expression.substring(offset, end);
        }
        return result;
    }

    private String getToParse(String expression, int offset, String prefix) {
        String result = expression == null ? null : expression.substring(0, offset - prefix.length());
        return result;
    }
}

