/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlrpc.serializer;

import java.util.Iterator;
import java.util.Map;
import org.apache.xmlrpc.common.TypeFactory;
import org.apache.xmlrpc.common.XmlRpcStreamConfig;
import org.apache.xmlrpc.serializer.TypeSerializer;
import org.apache.xmlrpc.serializer.TypeSerializerImpl;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class MapSerializer
extends TypeSerializerImpl {
    private final XmlRpcStreamConfig config;
    private final TypeFactory typeFactory;
    public static final String STRUCT_TAG = "struct";
    public static final String MEMBER_TAG = "member";
    public static final String NAME_TAG = "name";

    public MapSerializer(TypeFactory pTypeFactory, XmlRpcStreamConfig pConfig) {
        this.typeFactory = pTypeFactory;
        this.config = pConfig;
    }

    protected void writeEntry(ContentHandler pHandler, String pKey, Object pValue) throws SAXException {
        pHandler.startElement("", MEMBER_TAG, MEMBER_TAG, TypeSerializerImpl.ZERO_ATTRIBUTES);
        pHandler.startElement("", NAME_TAG, NAME_TAG, TypeSerializerImpl.ZERO_ATTRIBUTES);
        pHandler.characters(pKey.toCharArray(), 0, pKey.length());
        pHandler.endElement("", NAME_TAG, NAME_TAG);
        TypeSerializer ts = this.typeFactory.getSerializer(this.config, pValue);
        if (ts == null) {
            throw new SAXException("Unsupported Java type: " + pValue.getClass().getName());
        }
        ts.write(pHandler, pValue);
        pHandler.endElement("", MEMBER_TAG, MEMBER_TAG);
    }

    protected void writeData(ContentHandler pHandler, Object pData) throws SAXException {
        Map map = (Map)pData;
        Iterator iter = map.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            this.writeEntry(pHandler, entry.getKey().toString(), entry.getValue());
        }
    }

    public void write(ContentHandler pHandler, Object pObject) throws SAXException {
        pHandler.startElement("", "value", "value", TypeSerializerImpl.ZERO_ATTRIBUTES);
        pHandler.startElement("", STRUCT_TAG, STRUCT_TAG, TypeSerializerImpl.ZERO_ATTRIBUTES);
        this.writeData(pHandler, pObject);
        pHandler.endElement("", STRUCT_TAG, STRUCT_TAG);
        pHandler.endElement("", "value", "value");
    }
}

