/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.runtime.debug;

import org.antlr.runtime.TokenStream;
import org.antlr.runtime.debug.DebugEventListener;
import org.antlr.runtime.tree.TreeAdaptor;
import org.antlr.runtime.tree.TreeNodeStream;

public class DebugTreeNodeStream
implements TreeNodeStream {
    protected DebugEventListener dbg;
    protected TreeAdaptor adaptor;
    protected TreeNodeStream input;
    protected boolean initialStreamState = true;
    protected int lastMarker;

    public DebugTreeNodeStream(TreeNodeStream treeNodeStream, DebugEventListener debugEventListener) {
        this.input = treeNodeStream;
        this.adaptor = treeNodeStream.getTreeAdaptor();
        this.input.setUniqueNavigationNodes(true);
        this.setDebugListener(debugEventListener);
    }

    public void setDebugListener(DebugEventListener debugEventListener) {
        this.dbg = debugEventListener;
    }

    public TreeAdaptor getTreeAdaptor() {
        return this.adaptor;
    }

    public void consume() {
        Object object = this.input.LT(1);
        this.input.consume();
        int n = this.adaptor.getUniqueID(object);
        String string = this.adaptor.getText(object);
        int n2 = this.adaptor.getType(object);
        this.dbg.consumeNode(n, string, n2);
    }

    public Object get(int n) {
        return this.input.get(n);
    }

    public Object LT(int n) {
        Object object = this.input.LT(n);
        int n2 = this.adaptor.getUniqueID(object);
        String string = this.adaptor.getText(object);
        int n3 = this.adaptor.getType(object);
        this.dbg.LT(n, n2, string, n3);
        return object;
    }

    public int LA(int n) {
        Object object = this.input.LT(n);
        int n2 = this.adaptor.getUniqueID(object);
        String string = this.adaptor.getText(object);
        int n3 = this.adaptor.getType(object);
        this.dbg.LT(n, n2, string, n3);
        return n3;
    }

    public int mark() {
        this.lastMarker = this.input.mark();
        this.dbg.mark(this.lastMarker);
        return this.lastMarker;
    }

    public int index() {
        return this.input.index();
    }

    public void rewind(int n) {
        this.dbg.rewind(n);
        this.input.rewind(n);
    }

    public void rewind() {
        this.dbg.rewind();
        this.input.rewind(this.lastMarker);
    }

    public void release(int n) {
    }

    public void seek(int n) {
        this.input.seek(n);
    }

    public int size() {
        return this.input.size();
    }

    public Object getTreeSource() {
        return this.input;
    }

    public TokenStream getTokenStream() {
        return this.input.getTokenStream();
    }

    public void setUniqueNavigationNodes(boolean bl) {
        this.input.setUniqueNavigationNodes(bl);
    }

    public String toString(Object object, Object object2) {
        return this.input.toString(object, object2);
    }
}

