/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swt.model.layout.form;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wb.core.model.IAbstractComponentInfo;
import org.eclipse.wb.draw2d.geometry.Dimension;
import org.eclipse.wb.draw2d.geometry.Interval;
import org.eclipse.wb.draw2d.geometry.Point;
import org.eclipse.wb.draw2d.geometry.Rectangle;
import org.eclipse.wb.draw2d.geometry.Transposer;
import org.eclipse.wb.internal.core.gef.policy.snapping.ComponentAttachmentInfo;
import org.eclipse.wb.internal.core.gef.policy.snapping.IAbsoluteLayoutCommands;
import org.eclipse.wb.internal.core.gef.policy.snapping.PlacementUtils;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.swt.Activator;
import org.eclipse.wb.internal.swt.model.layout.form.AttachmentDef;
import org.eclipse.wb.internal.swt.model.layout.form.FormLayoutInfoImpl;
import org.eclipse.wb.internal.swt.model.layout.form.FormLayoutUtils;
import org.eclipse.wb.internal.swt.model.layout.form.IFormAttachmentInfo;
import org.eclipse.wb.internal.swt.model.layout.form.IFormDataInfo;
import org.eclipse.wb.internal.swt.model.layout.form.IFormLayoutInfo;
import org.eclipse.wb.internal.swt.model.widgets.IControlInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FormLayoutInfoImplAutomatic<C extends IControlInfo>
extends FormLayoutInfoImpl<C>
implements IAbsoluteLayoutCommands {
    private final IFormLayoutInfo<C> m_layout;

    public FormLayoutInfoImplAutomatic(IFormLayoutInfo<C> formLayoutInfo) {
        this.m_layout = formLayoutInfo;
    }

    public void command_moveToContainer(List<? extends IAbstractComponentInfo> sourceSet, IAbstractComponentInfo nearestBeingSnapped, int side, int distance) throws Exception {
    }

    public void command_moveAsAttachedToComponent(List<? extends IAbstractComponentInfo> sourceSet, IAbstractComponentInfo nearestBeingSnapped, int sourceSide, IAbstractComponentInfo target, int targetSide, int gap) {
        FormLayoutUtils.getAlignmentSource(FormLayoutUtils.convertGefSide(sourceSide));
        FormLayoutUtils.getAlignmentSource(FormLayoutUtils.convertGefSide(targetSide));
    }

    public void command_moveToPercent(List<? extends IAbstractComponentInfo> workingSet, IAbstractComponentInfo nearestBeingSnapped, int sourceSide, int percent, int gap) {
        FormLayoutUtils.getAlignmentSource(FormLayoutUtils.convertGefSide(sourceSide));
    }

    public void command_moveFreely(Rectangle bounds, List<? extends IAbstractComponentInfo> sourceSet, IAbstractComponentInfo singleSource, int moveDirection, boolean isHorizontal) throws Exception {
        NeighborInfo leadingNeighbor = this.findNeighbor(bounds, sourceSet, 0, isHorizontal);
        NeighborInfo trailingNeighbor = this.findNeighbor(bounds, sourceSet, 1, isHorizontal);
        int newAlignmentHint = leadingNeighbor.distance < trailingNeighbor.distance ? 0 : 1;
        AlignmentInfo currentAlignment = this.getAlignment(singleSource, isHorizontal);
        if (!currentAlignment.resizable) {
            this.attachNonResizableFreely(singleSource, bounds, leadingNeighbor, trailingNeighbor, newAlignmentHint, isHorizontal);
        } else {
            this.attachResizableFreely(singleSource, bounds, leadingNeighbor, trailingNeighbor, isHorizontal);
        }
        this.keepWidgetsPositions(sourceSet, isHorizontal);
        this.optimizeLayout();
    }

    private void optimizeLayout() {
    }

    private void keepWidgetsPositions(List<? extends IAbstractComponentInfo> sourceSet, boolean isHorizontal) throws Exception {
        List<AttachmentDef> affected = this.findAttachedToSource(sourceSet, isHorizontal);
        Iterator<AttachmentDef> iterator = affected.iterator();
        while (iterator.hasNext()) {
            iterator.next();
        }
    }

    private List<AttachmentDef> findAttachedToSource(List<? extends IAbstractComponentInfo> sourceSet, boolean isHorizontal) throws Exception {
        ArrayList affected = Lists.newArrayList();
        int leadingSide = PlacementUtils.getSide((boolean)isHorizontal, (boolean)true);
        int trailingSide = PlacementUtils.getSide((boolean)isHorizontal, (boolean)false);
        List<IAbstractComponentInfo> remainingComponents = this.getRemainingComponents(sourceSet);
        for (IAbstractComponentInfo source : remainingComponents) {
            for (IAbstractComponentInfo iAbstractComponentInfo : sourceSet) {
                this.checkAttachedToComponent(source, iAbstractComponentInfo, leadingSide, affected);
                this.checkAttachedToComponent(source, iAbstractComponentInfo, trailingSide, affected);
            }
        }
        return affected;
    }

    private void checkAttachedToComponent(IAbstractComponentInfo source, IAbstractComponentInfo possibleTarget, int checkingSide, List<AttachmentDef> resultList) throws Exception {
        IFormAttachmentInfo<C> attachment;
        if (this.isAttached(source, checkingSide) && (attachment = this.getAttachment(source, checkingSide)).getControl() == possibleTarget) {
            AttachmentDef def = new AttachmentDef();
            def.source = source;
            def.target = possibleTarget;
            def.sourceSide = checkingSide;
            def.targetSide = FormLayoutUtils.convertSwtAlignment(attachment.getAlignment());
            resultList.add(def);
        }
    }

    private void attachResizableFreely(IAbstractComponentInfo source, Rectangle bounds, NeighborInfo leadingNeighbor, NeighborInfo trailingNeighbor, boolean isHorizontal) throws Exception {
        int offset;
        IAbstractComponentInfo target;
        int leadingSide = PlacementUtils.getSide((boolean)isHorizontal, (boolean)true);
        int trailingSide = PlacementUtils.getSide((boolean)isHorizontal, (boolean)false);
        if (leadingNeighbor.neighbor == null) {
            this.attachResizableToContainer(source, bounds, leadingSide);
        } else {
            target = leadingNeighbor.neighbor;
            offset = leadingNeighbor.distance;
            this.attachSideToComponent(source, target, offset, leadingSide, trailingSide);
        }
        if (trailingNeighbor.neighbor == null) {
            this.attachResizableToContainer(source, bounds, PlacementUtils.getSide((boolean)isHorizontal, (boolean)false));
        } else {
            target = trailingNeighbor.neighbor;
            offset = -trailingNeighbor.distance;
            this.attachSideToComponent(source, target, offset, trailingSide, leadingSide);
        }
    }

    private void attachResizableToContainer(IAbstractComponentInfo source, Rectangle bounds, int checkingSide) throws Exception {
        boolean isHorizontal = PlacementUtils.isHorizontalSide((int)checkingSide);
        int targetSide = this.getTargetContainerSide(source, checkingSide);
        boolean isLeadingSide = PlacementUtils.isLeadingSide((int)checkingSide);
        int containerSize = PlacementUtils.getSideSize((Dimension)this.m_layout.getContainerSize(), (int)targetSide);
        int offset = checkingSide == targetSide ? (isLeadingSide ? (isHorizontal ? bounds.x : bounds.y) : -(containerSize - (isHorizontal ? bounds.right() : bounds.bottom()))) : (isLeadingSide ? -(containerSize - (isHorizontal ? bounds.x : bounds.y)) : (isHorizontal ? bounds.right() : bounds.bottom()));
        this.attachSideToContainer(source, offset, checkingSide, targetSide);
    }

    private int getTargetContainerSide(IAbstractComponentInfo source, int side) throws Exception {
        Assert.isLegal((boolean)this.isAttached(source, side));
        IFormAttachmentInfo<C> attachment = this.getAttachment(source, side);
        Assert.isLegal((attachment.getControl() == null ? 1 : 0) != 0);
        int numerator = attachment.getNumerator();
        boolean isTrailing = numerator == 100;
        boolean isHorizontal = PlacementUtils.isHorizontalSide((int)side);
        return PlacementUtils.getSide((boolean)isHorizontal, (!isTrailing ? 1 : 0) != 0);
    }

    private void attachNonResizableFreely(IAbstractComponentInfo source, Rectangle bounds, NeighborInfo leadingNeighbor, NeighborInfo trailingNeighbor, int alignment, boolean isHorizontal) throws Exception {
        boolean trailingAttached;
        int leadingSide = PlacementUtils.getSide((boolean)isHorizontal, (boolean)true);
        int trailingSide = PlacementUtils.getSide((boolean)isHorizontal, (boolean)false);
        boolean isLeadingAlignment = alignment == 0;
        int targetContainerSide = PlacementUtils.getSide((boolean)isHorizontal, (boolean)isLeadingAlignment);
        boolean leadingAttached = this.isAttached(source, leadingSide);
        if (leadingAttached ^ (trailingAttached = this.isAttached(source, trailingSide)) || !leadingAttached && !trailingAttached) {
            if (isLeadingAlignment) {
                if (leadingNeighbor.neighbor == null) {
                    this.attachSideToContainer(source, leadingNeighbor.distance, leadingSide, targetContainerSide);
                } else {
                    this.attachSideToComponent(source, leadingNeighbor.neighbor, leadingNeighbor.distance, leadingSide, PlacementUtils.getOppositeSide((int)leadingSide));
                }
                this.deleteAttachment(source, trailingSide);
            } else {
                if (trailingNeighbor.neighbor == null) {
                    this.attachSideToContainer(source, -trailingNeighbor.distance, trailingSide, targetContainerSide);
                } else {
                    this.attachSideToComponent(source, trailingNeighbor.neighbor, -trailingNeighbor.distance, trailingSide, PlacementUtils.getOppositeSide((int)trailingSide));
                }
                this.deleteAttachment(source, leadingSide);
            }
        } else {
            NeighborInfo targetNeighbor;
            int offset = isLeadingAlignment ? leadingNeighbor.distance : -trailingNeighbor.distance;
            int width = PlacementUtils.getSideSize((Dimension)source.getModelBounds().getSize(), (int)leadingSide);
            NeighborInfo neighborInfo = targetNeighbor = isLeadingAlignment ? leadingNeighbor : trailingNeighbor;
            if (targetNeighbor.neighbor == null) {
                int widthDelta = isLeadingAlignment ? 0 : -width;
                this.attachSideToContainer(source, offset + widthDelta, leadingSide, targetContainerSide);
                widthDelta = isLeadingAlignment ? width : 0;
                this.attachSideToContainer(source, offset + widthDelta, trailingSide, targetContainerSide);
            } else {
                int widthDelta = isLeadingAlignment ? 0 : -width;
                this.attachSideToComponent(source, targetNeighbor.neighbor, offset + widthDelta, leadingSide, isLeadingAlignment ? PlacementUtils.getOppositeSide((int)leadingSide) : leadingSide);
                widthDelta = isLeadingAlignment ? width : 0;
                this.attachSideToComponent(source, targetNeighbor.neighbor, offset + widthDelta, trailingSide, isLeadingAlignment ? trailingSide : PlacementUtils.getOppositeSide((int)trailingSide));
            }
        }
    }

    private NeighborInfo findNeighbor(Rectangle bounds, List<? extends IAbstractComponentInfo> sourceSet, int direction, boolean isHorizontal) {
        NeighborInfo neighbor = new NeighborInfo(direction);
        Transposer t = new Transposer(!isHorizontal);
        Rectangle widgetsBounds = t.t(bounds.getCopy());
        Interval widgetsWidth = new Interval(widgetsBounds.x, widgetsBounds.width);
        Interval widgetsHeight = new Interval(widgetsBounds.y, widgetsBounds.height);
        List<IAbstractComponentInfo> remainingWidgets = this.getRemainingComponents(sourceSet);
        for (IAbstractComponentInfo widget : remainingWidgets) {
            int distance;
            Interval possibleNeighborWidth;
            Rectangle possibleNeighborBounds = t.t(this.getTranslatedBounds(widget));
            Interval possibleNeighborHeight = new Interval(possibleNeighborBounds.y, possibleNeighborBounds.height);
            if (!widgetsHeight.intersects(possibleNeighborHeight) || (possibleNeighborWidth = new Interval(possibleNeighborBounds.x, possibleNeighborBounds.width)).intersects(widgetsWidth)) continue;
            if (direction == 0 && possibleNeighborWidth.isLeadingOf(widgetsWidth)) {
                distance = widgetsWidth.distance(possibleNeighborWidth.end());
                if (neighbor.distance <= distance) continue;
                neighbor.distance = distance;
                neighbor.neighbor = widget;
                continue;
            }
            if (direction != 1 || !possibleNeighborWidth.isTrailingOf(widgetsWidth) || neighbor.distance <= (distance = widgetsWidth.distance(possibleNeighborWidth.begin()))) continue;
            neighbor.distance = distance;
            neighbor.neighbor = widget;
        }
        if (neighbor.neighbor == null) {
            Dimension containerSize = t.t(this.m_layout.getContainerSize());
            neighbor.distance = direction == 0 ? widgetsWidth.begin() : containerSize.width - widgetsWidth.end();
        }
        return neighbor;
    }

    public AlignmentInfo getAlignment(IAbstractComponentInfo widget, boolean isHorizontal) throws Exception {
        int leadingSide = PlacementUtils.getSide((boolean)isHorizontal, (boolean)true);
        int trailingSide = PlacementUtils.getSide((boolean)isHorizontal, (boolean)false);
        boolean attachedLeading = this.isAttached(widget, leadingSide);
        boolean attachedTrailing = this.isAttached(widget, trailingSide);
        if (!attachedLeading && !attachedTrailing) {
            return new AlignmentInfo(0);
        }
        if (attachedLeading && attachedTrailing) {
            int tEffectiveAlignment;
            int lEffectiveAlignment = this.getEffectiveAlignmentForSide(widget, leadingSide);
            if (lEffectiveAlignment != (tEffectiveAlignment = this.getEffectiveAlignmentForSide(widget, trailingSide))) {
                return new AlignmentInfo(0, true);
            }
            IFormAttachmentInfo<C> lAttachment = this.getAttachment(widget, leadingSide);
            IFormAttachmentInfo<C> tAttachment = this.getAttachment(widget, trailingSide);
            if (lAttachment.getNumerator() != tAttachment.getNumerator()) {
                return new AlignmentInfo(0, true);
            }
            return new AlignmentInfo(lEffectiveAlignment);
        }
        return new AlignmentInfo(this.getEffectiveAlignmentForSide(widget, attachedLeading ? leadingSide : trailingSide));
    }

    private int getEffectiveAlignmentForSide(IAbstractComponentInfo widget, int side) throws Exception {
        Object testedWidget = widget;
        int testedSide = side;
        while (this.isAttached((IAbstractComponentInfo)testedWidget, testedSide)) {
            IFormAttachmentInfo<C> attachment = this.getAttachment((IAbstractComponentInfo)testedWidget, testedSide);
            C anchorComponent = attachment.getControl();
            if (anchorComponent != null) {
                testedWidget = anchorComponent;
                testedSide = attachment.getSide().getEngineSide();
                continue;
            }
            return attachment.getNumerator() > 0 ? 1 : 0;
        }
        return PlacementUtils.getSidePosition((int)PlacementUtils.getOppositeSide((int)testedSide));
    }

    private List<IAbstractComponentInfo> getRemainingComponents(List<? extends IAbstractComponentInfo> sourceSet) {
        ArrayList components = Lists.newArrayList();
        List allControls = this.m_layout.getControls();
        for (IControlInfo control : allControls) {
            if (sourceSet.contains(control)) continue;
            components.add(control);
        }
        return components;
    }

    private Rectangle getUnionRectangle(List<? extends IAbstractComponentInfo> sourceSet) {
        Rectangle unionRectangle = new Rectangle();
        for (IAbstractComponentInfo iAbstractComponentInfo : sourceSet) {
            unionRectangle.union(iAbstractComponentInfo.getModelBounds());
        }
        return unionRectangle;
    }

    private Rectangle getTranslatedBounds(IAbstractComponentInfo widget) {
        return PlacementUtils.getTranslatedBounds((Point)this.m_layout.getComposite().getClientArea().getLocation(), (IAbstractComponentInfo)widget);
    }

    private void attachSideToContainer(IAbstractComponentInfo source, int offset, int sourceSide, int containerSide) throws Exception {
        int numerator = PlacementUtils.isLeadingSide((int)containerSide) ? 0 : 100;
        IFormAttachmentInfo<C> attachment = this.getAttachment(source, sourceSide);
        attachment.setControl(null);
        attachment.setNumerator(numerator);
        attachment.setDenominator(100);
        attachment.setOffset(offset);
        attachment.write();
    }

    private void attachSideToComponent(IAbstractComponentInfo source, IAbstractComponentInfo target, int offset, int sourceSide, int targetSide) throws Exception {
        IFormAttachmentInfo<IControlInfo> attachment = this.getAttachment(source, sourceSide);
        attachment.setControl((IControlInfo)target);
        attachment.setAlignment(FormLayoutUtils.convertGefSide(targetSide));
        attachment.setNumerator(0);
        attachment.setDenominator(100);
        attachment.setOffset(offset);
        attachment.write();
    }

    private void deleteAttachment(IAbstractComponentInfo source, int sourceSide) throws Exception {
        if (this.isAttached(source, sourceSide)) {
            IFormAttachmentInfo<C> attachment = this.getAttachment(source, sourceSide);
            attachment.delete();
        }
    }

    private final IFormAttachmentInfo<C> getAttachment(IAbstractComponentInfo widget, int side) throws Exception {
        IFormDataInfo layoutData = (IFormDataInfo)this.m_layout.getLayoutData2((IControlInfo)widget);
        return layoutData.getAttachment(side);
    }

    public void detach(IAbstractComponentInfo widget, int side) throws Exception {
        IFormAttachmentInfo<C> attachment = this.getAttachment(widget, side);
        if (attachment.isVirtual()) {
            return;
        }
        attachment.delete();
    }

    public void attachAbsolute(IAbstractComponentInfo widget, int side, int distance) throws Exception {
        IFormAttachmentInfo<C> attachment = this.getAttachment(widget, side);
        attachment.setControl(null);
        if (PlacementUtils.isTrailingSide((int)side)) {
            attachment.setOffset(-distance);
            attachment.setNumerator(100);
        } else {
            attachment.setOffset(distance);
            attachment.setNumerator(0);
        }
        attachment.write();
    }

    public void adjustAttachmentOffset(IAbstractComponentInfo widget, int side, int delta) throws Exception {
        IFormAttachmentInfo<C> attachment = this.getAttachment(widget, side);
        int oldOffset = attachment.getOffset();
        int newOffset = oldOffset + delta;
        attachment.setOffset(newOffset);
        attachment.write();
    }

    public void attachContainer(IAbstractComponentInfo widget, int side, int distance) throws Exception {
        this.attachAbsolute(widget, side, distance);
    }

    public void attachWidgetSequientially(IAbstractComponentInfo widget, IAbstractComponentInfo attachToWidget, int side, int distance) throws Exception {
        IFormAttachmentInfo<IControlInfo> attachment = this.getAttachment(widget, side);
        attachment.setControl((IControlInfo)attachToWidget);
        attachment.setOffset(PlacementUtils.isTrailingSide((int)side) ? -distance : distance);
        int oppositeSide = PlacementUtils.getOppositeSide((int)side);
        int oppositeSideGef = FormLayoutUtils.convertGefSide(oppositeSide);
        attachment.setAlignment(oppositeSideGef);
        attachment.write();
    }

    public void attachWidgetParallelly(IAbstractComponentInfo widget, IAbstractComponentInfo attachToWidget, int side, int distance) throws Exception {
        IFormAttachmentInfo<IControlInfo> attachment = this.getAttachment(widget, side);
        attachment.setControl((IControlInfo)attachToWidget);
        attachment.setOffset(PlacementUtils.isTrailingSide((int)side) ? -distance : distance);
        attachment.setAlignment(FormLayoutUtils.convertGefSide(side));
        attachment.write();
    }

    public void attachWidgetBaseline(IAbstractComponentInfo widget, IAbstractComponentInfo attachToWidget) throws Exception {
        IFormAttachmentInfo<IControlInfo> attachment = this.getAttachment(widget, PlacementUtils.getSide((boolean)false, (boolean)true));
        attachment.setControl((IControlInfo)attachToWidget);
        int offset = 0;
        int baseline = widget.getBaseline();
        int targetBaseline = attachToWidget.getBaseline();
        if (baseline == -1 || targetBaseline == -1) {
            Rectangle sourceBounds = widget.getModelBounds();
            Rectangle targetBounds = attachToWidget.getModelBounds();
            offset = targetBounds.bottom() / 2 - sourceBounds.height / 2;
        } else {
            offset = targetBaseline - baseline;
        }
        attachment.setOffset(offset);
        attachment.setAlignment(128);
        attachment.write();
    }

    public void setExplicitSize(IAbstractComponentInfo widget, int attachedSide, int draggingSide, int resizeDelta) throws Exception {
        Rectangle modelBounds = widget.getModelBounds();
        Dimension oldSize = modelBounds != null ? modelBounds.getSize() : widget.getPreferredSize();
        int oldLinearSize = PlacementUtils.getSideSize((Dimension)oldSize, (int)draggingSide);
        this.setExplicitSize(widget, attachedSide, draggingSide, resizeDelta, oldLinearSize);
        IFormDataInfo layoutData = (IFormDataInfo)this.m_layout.getLayoutData2((IControlInfo)widget);
        if (PlacementUtils.isHorizontalSide((int)attachedSide)) {
            layoutData.setWidth(-1);
        } else {
            layoutData.setHeight(-1);
        }
    }

    private void setExplicitSize(IAbstractComponentInfo widget, int attachedSide, int draggingSide, int resizeDelta, int oldSize) throws Exception {
        IFormAttachmentInfo<C> attached = this.getAttachment(widget, attachedSide);
        IFormAttachmentInfo<C> dragging = this.getAttachment(widget, draggingSide);
        if (attachedSide == draggingSide) {
            IFormAttachmentInfo<C> lock = this.getAttachment(widget, PlacementUtils.getOppositeSide((int)attachedSide));
            FormLayoutInfoImplAutomatic.setNewSize(attached, attachedSide, lock, oldSize);
        } else {
            int newWidth = oldSize + resizeDelta;
            FormLayoutInfoImplAutomatic.setNewSize(attached, attachedSide, dragging, newWidth);
        }
    }

    private static <C extends IControlInfo> void setNewSize(IFormAttachmentInfo<C> attached, int attachedSide, IFormAttachmentInfo<C> dragging, int newSize) throws Exception {
        C attachedControl = attached.getControl();
        dragging.setControl(attachedControl);
        if (attachedControl != null) {
            dragging.setAlignment(attached.getAlignment());
        } else {
            dragging.setDenominator(attached.getDenominator());
            dragging.setNumerator(attached.getNumerator());
        }
        int offset = PlacementUtils.isLeadingSide((int)attachedSide) ? attached.getOffset() + newSize : attached.getOffset() - newSize;
        dragging.setOffset(offset);
        dragging.write();
    }

    public ComponentAttachmentInfo getComponentAttachmentInfo(IAbstractComponentInfo widget, int side) throws Exception {
        IFormAttachmentInfo<C> attachment;
        C control;
        if (this.m_layout.isManagedObject(widget) && this.isAttached(widget, side) && (control = (attachment = this.getAttachment(widget, side)).getControl()) != null) {
            int alignment = attachment.getAlignment();
            alignment = alignment == -1 ? PlacementUtils.getOppositeSide((int)side) : FormLayoutUtils.convertSwtAlignment(alignment);
            return new ComponentAttachmentInfo(widget, control, alignment);
        }
        return null;
    }

    public static Image getImage(String imageName) {
        return Activator.getImage("info/layout/FormLayout/" + imageName);
    }

    public IAbstractComponentInfo getAttachedToWidget(IAbstractComponentInfo widget, int side) throws Exception {
        if (!this.isAttached(widget, side)) {
            return null;
        }
        IFormAttachmentInfo<C> attachment = this.getAttachment(widget, side);
        return attachment.getControl();
    }

    public boolean isAttached(IAbstractComponentInfo widget, int side) throws Exception {
        return this.m_layout.isManagedObject(widget) && !this.getAttachment(widget, side).isVirtual();
    }

    public void performAction(int actionId) {
    }

    public void command_CREATE2(C component, C nextComponent) throws Exception {
        this.m_layout.commandCreate(component, nextComponent);
    }

    public void command_MOVE2(C component, C nextComponent) throws Exception {
        this.m_layout.commandMove(component, nextComponent);
        this.adjustMovedComponentSides(component);
        this.adjustAnchoredToMovedComponent(component);
    }

    private void adjustMovedComponentSides(C component) throws Exception {
        this.adjustMovedComponentSide(component, 8);
        this.adjustMovedComponentSide(component, 1);
        this.adjustMovedComponentSide(component, 32);
        this.adjustMovedComponentSide(component, 4);
    }

    private void adjustMovedComponentSide(C component, int side) throws Exception {
        IFormAttachmentInfo<C> attachment = this.getAttachment((IAbstractComponentInfo)component, side);
        if (!attachment.isVirtual()) {
            attachment.write();
        }
    }

    private void adjustAnchoredToMovedComponent(C component) throws Exception {
        for (IControlInfo sibling : this.m_layout.getControls()) {
            this.adjustAnchoredToMovedComponentSides(sibling, component);
        }
    }

    private void adjustAnchoredToMovedComponentSides(C component, C target) throws Exception {
        this.adjustAnchoredToMovedComponentSide(component, target, 8);
        this.adjustAnchoredToMovedComponentSide(component, target, 1);
        this.adjustAnchoredToMovedComponentSide(component, target, 32);
        this.adjustAnchoredToMovedComponentSide(component, target, 4);
    }

    private void adjustAnchoredToMovedComponentSide(C component, C anchor, int side) throws Exception {
        IFormAttachmentInfo<C> attachment = this.getAttachment((IAbstractComponentInfo)component, side);
        if (attachment.getControl() == anchor) {
            attachment.write();
        }
    }

    public static final class AlignmentInfo {
        public final int alignment;
        public final boolean resizable;

        public AlignmentInfo(int alignment) {
            this(alignment, false);
        }

        public AlignmentInfo(int alignment, boolean resizable) {
            this.alignment = alignment;
            this.resizable = resizable;
        }
    }

    private static final class NeighborInfo {
        final int direction;
        int distance = Integer.MAX_VALUE;
        IAbstractComponentInfo neighbor;

        NeighborInfo(int direction) {
            this.direction = direction;
        }
    }
}

