/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.utils.exception;

import org.apache.commons.lang.StringUtils;
import org.eclipse.wb.internal.core.utils.exception.DesignerExceptionUtils;

public class DesignerException
extends Error {
    private static final long serialVersionUID = 0L;
    private final int m_code;
    private final String[] m_parameters;
    private final Throwable m_cause;
    private int m_sourcePosition = -1;

    public DesignerException(int code, String ... parameters) {
        this(code, (Throwable)null, parameters);
    }

    public DesignerException(int code, Throwable cause, String ... parameters) {
        super(cause);
        this.m_code = code;
        this.m_parameters = parameters;
        this.m_cause = cause;
    }

    public int getCode() {
        return this.m_code;
    }

    public String[] getParameters() {
        return this.m_parameters;
    }

    public String getMessage() {
        String message = String.valueOf(this.m_code) + " (" + DesignerExceptionUtils.getExceptionTitle(this.m_code) + ").";
        if (this.m_parameters.length != 0) {
            message = String.valueOf(message) + " " + StringUtils.join((Object[])this.m_parameters, (String)" ");
        }
        return message;
    }

    public Throwable getCause() {
        return this.m_cause;
    }

    public void setSourcePosition(int sourcePosition) {
        this.m_sourcePosition = sourcePosition;
    }

    public int getSourcePosition() {
        return this.m_sourcePosition;
    }
}

