/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.tooling.ui.wizards.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.viatra.query.tooling.core.targetplatform.ITargetPlatformMetamodelLoader;
import org.eclipse.viatra.query.tooling.ui.wizards.internal.ObjectParameter;
import org.eclipse.viatra.query.tooling.ui.wizards.internal.ObjectParameterConfigurationLabelProvider;

public class ObjectParameterConfigurationDialog
extends Dialog {
    private static final String SELECT_A_MODEL_ELEMENT = "Select a model element (* = any string, ? = any char):";
    private static final String PARAMETER_TYPE_SELECTION = "Parameter type selection";
    private static final String PARAMETER_TYPE = "&Parameter type:";
    private static final String PARAMETER_NAME = "&Parameter name:";
    private static final String TITLE = "&Pattern parameter configuration";
    private Text parameterName;
    private Text parameterType;
    private List<String> currentPackages;
    private ObjectParameter result;
    private ResourceSet set;
    private ITargetPlatformMetamodelLoader metamodelLoader;

    protected ObjectParameterConfigurationDialog(Shell shell, ResourceSet set, List<String> currentPackages, ITargetPlatformMetamodelLoader metamodelLoader, ObjectParameter result) {
        super(shell);
        this.set = set;
        this.metamodelLoader = metamodelLoader;
        shell.setText(TITLE);
        this.currentPackages = currentPackages;
        this.result = result;
    }

    protected Control createDialogArea(Composite parent) {
        int nColumns = 4;
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.numColumns = nColumns;
        composite.setLayout((Layout)layout);
        Label label = new Label(composite, 0);
        label.setText(PARAMETER_NAME);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.parameterName = new Text(composite, 2052);
        this.parameterName.setText(this.result.getParameterName());
        this.parameterName.setEditable(true);
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        this.parameterName.setLayoutData((Object)gridData);
        this.parameterName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ObjectParameterConfigurationDialog.this.result.setParameterName(ObjectParameterConfigurationDialog.this.parameterName.getText());
            }
        });
        label = new Label(composite, 0);
        label.setText(PARAMETER_TYPE);
        gridData = new GridData(768);
        gridData.horizontalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.parameterType = new Text(composite, 2052);
        this.parameterType.setText(this.result.getObject() == null ? "" : this.result.getObject().getName());
        this.parameterType.setEditable(false);
        gridData = new GridData(768);
        gridData.horizontalSpan = 1;
        this.parameterType.setLayoutData((Object)gridData);
        Button button = new Button(composite, 8);
        button.setText("Browse...");
        gridData = new GridData(768);
        gridData.horizontalSpan = 1;
        button.setLayoutData((Object)gridData);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ObjectParameterConfigurationDialog.this.setParameterType(ObjectParameterConfigurationDialog.this.openDialogBox());
            }
        });
        return super.createDialogArea(parent);
    }

    private EClassifier openDialogBox() {
        ElementListSelectionDialog listDialog = new ElementListSelectionDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (ILabelProvider)new ObjectParameterConfigurationLabelProvider());
        listDialog.setTitle(PARAMETER_TYPE_SELECTION);
        listDialog.setMessage(SELECT_A_MODEL_ELEMENT);
        listDialog.setElements(this.getElements());
        listDialog.open();
        Object[] result = listDialog.getResult();
        if (result != null && result.length > 0) {
            return (EClassifier)result[0];
        }
        return null;
    }

    private Object[] getElements() {
        ArrayList<EObject> result = new ArrayList<EObject>();
        for (String _nsURI : this.currentPackages) {
            EPackage _package = this.metamodelLoader.loadPackage(this.set, _nsURI);
            TreeIterator iterator = _package.eAllContents();
            while (iterator.hasNext()) {
                EObject nextObject = (EObject)iterator.next();
                if (!(nextObject instanceof EClassifier)) continue;
                result.add(nextObject);
            }
        }
        return result.toArray();
    }

    private void setParameterType(EClassifier object) {
        this.result.setObject(object);
        if (object != null) {
            this.parameterType.setText(object.getName());
        }
    }
}

