/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.tooling.ui.queryexplorer.util;

import org.eclipse.core.resources.IFile;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.viatra.query.runtime.api.IQuerySpecification;
import org.eclipse.viatra.query.tooling.ui.queryexplorer.QueryExplorer;
import org.eclipse.viatra.query.tooling.ui.queryexplorer.handlers.AttachVqlEditorRegistrationHandler;
import org.eclipse.viatra.query.tooling.ui.queryexplorer.handlers.PatternUnregistrationHandler;
import org.eclipse.viatra.query.tooling.ui.queryexplorer.util.BasePartListener;
import org.eclipse.viatra.query.tooling.ui.queryexplorer.util.QueryExplorerPatternRegistry;

public class AttachFileEditorPartListener
extends BasePartListener {
    private AttachVqlEditorRegistrationHandler attachHandler;

    public AttachFileEditorPartListener(AttachVqlEditorRegistrationHandler h) {
        this.attachHandler = h;
    }

    @Override
    public void partClosed(IWorkbenchPart part) {
        if (part instanceof IEditorPart) {
            IFile file;
            IEditorPart closedEditor = (IEditorPart)part;
            IEditorInput editorInput = closedEditor.getEditorInput();
            IWorkbenchWindow activeWorkbenchWindow = part.getSite().getWorkbenchWindow();
            if (editorInput instanceof FileEditorInput && (file = ((FileEditorInput)editorInput).getFile()) != null && file.getFileExtension().matches("vql") && this.attachHandler.thereIsAnAttachedEditorForFile(file) && QueryExplorerPatternRegistry.getInstance().getFiles().contains(file)) {
                boolean answer = false;
                if (answer) {
                    PatternUnregistrationHandler puh = new PatternUnregistrationHandler();
                    for (IQuerySpecification<?> qs : QueryExplorerPatternRegistry.getInstance().getRegisteredPatternsForFile(file)) {
                        puh.unregisterPattern(QueryExplorer.getInstance(activeWorkbenchWindow), qs.getFullyQualifiedName());
                    }
                }
                this.attachHandler.removeAttachmentRegistrationForFile(file);
            }
        }
    }
}

