/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.matchers.backend;

import java.util.Map;
import org.eclipse.viatra.query.runtime.matchers.backend.QueryEvaluationHint;

public class QueryHintOption<HintValue> {
    private String optionQualifiedName;
    private HintValue defaultValue;

    public QueryHintOption(String optionQualifiedName, HintValue defaultValue) {
        this.optionQualifiedName = optionQualifiedName;
        this.defaultValue = defaultValue;
    }

    public QueryHintOption(Class<?> optionNamespace, String optionLocalName, HintValue defaultValue) {
        this(String.format("%s#%s", optionNamespace.getName(), optionLocalName), defaultValue);
    }

    public String getQualifiedName() {
        return this.optionQualifiedName;
    }

    public HintValue getDefaultValue() {
        return this.defaultValue;
    }

    public HintValue getValueOrDefault(QueryEvaluationHint hints) {
        Object value = hints.getValueOrNull(this);
        if (value == null) {
            return this.getDefaultValue();
        }
        return value;
    }

    public HintValue getValueOrNull(QueryEvaluationHint hints) {
        return hints.getValueOrNull(this);
    }

    public boolean isOverriddenIn(QueryEvaluationHint hints) {
        return hints.isOptionOverridden(this);
    }

    public HintValue insertOverridingValue(Map<QueryHintOption, Object> hints, HintValue overridingValue) {
        return (HintValue)hints.put(this, overridingValue);
    }

    public String toString() {
        return this.optionQualifiedName;
    }
}

