/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.project.model;

import java.util.HashMap;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.graphics.Image;
import org.eclipse.tracecompass.tmf.ui.project.model.ITmfProjectModelElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfExperimentFolder;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfProjectModelElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceFolder;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTracesFolder;

public class TmfProjectElement
extends TmfProjectModelElement {
    private @Nullable TmfTraceFolder fTraceFolder = null;
    private @Nullable TmfExperimentFolder fExperimentFolder = null;

    public TmfProjectElement(String name, IProject project, ITmfProjectModelElement parent) {
        super(name, (IResource)project, parent);
    }

    public IProject getResource() {
        return (IProject)super.getResource();
    }

    @Override
    public void addChild(ITmfProjectModelElement child) {
        super.addChild(child);
        if (child instanceof TmfTraceFolder) {
            this.fTraceFolder = (TmfTraceFolder)child;
            return;
        }
        if (child instanceof TmfExperimentFolder) {
            this.fExperimentFolder = (TmfExperimentFolder)child;
            return;
        }
    }

    public @Nullable TmfTraceFolder getTracesFolder() {
        return this.fTraceFolder;
    }

    public @Nullable TmfExperimentFolder getExperimentsFolder() {
        return this.fExperimentFolder;
    }

    @Override
    protected void refreshChildren() {
        ITmfProjectModelElement element;
        String name;
        IProject project = this.getResource();
        HashMap<String, ITmfProjectModelElement> childrenMap = new HashMap<String, ITmfProjectModelElement>();
        for (ITmfProjectModelElement element2 : this.getChildren()) {
            childrenMap.put(element2.getResource().getName(), element2);
        }
        IFolder folder = project.getFolder("Traces");
        if (folder != null && folder.exists()) {
            name = folder.getName();
            element = (ITmfProjectModelElement)childrenMap.get(name);
            if (element instanceof TmfTracesFolder) {
                childrenMap.remove(name);
            } else {
                element = new TmfTracesFolder("Traces", folder, this);
                this.addChild(element);
            }
            ((TmfTracesFolder)element).refreshChildren();
        }
        if ((folder = project.getFolder("Experiments")) != null && folder.exists()) {
            name = folder.getName();
            element = (ITmfProjectModelElement)childrenMap.get(name);
            if (element instanceof TmfExperimentFolder) {
                childrenMap.remove(name);
            } else {
                element = new TmfExperimentFolder("Experiments", folder, this);
                this.addChild(element);
            }
            ((TmfExperimentFolder)element).refreshChildren();
        }
        for (ITmfProjectModelElement danglingChild : childrenMap.values()) {
            this.removeChild(danglingChild);
        }
    }

    @Override
    public TmfProjectElement getProject() {
        return this;
    }

    @Override
    public Image getIcon() {
        return null;
    }
}

