/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.ui.symbols;

import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.TreeMap;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class MappingFile {
    private final @NonNull String DEFAULT_END_SUFFIX = "END__";
    private final String fFullPath;
    private final boolean fIsBinaryFile;
    private final @NonNull NavigableMap<Long, String> fSymbolMapping;

    public MappingFile(String path, boolean isBinaryFile, Map<Long, String> results) {
        this.fFullPath = path;
        this.fIsBinaryFile = isBinaryFile;
        this.fSymbolMapping = new TreeMap<Long, String>(results);
    }

    public String getFullPath() {
        return this.fFullPath;
    }

    public boolean isBinaryFile() {
        return this.fIsBinaryFile;
    }

    public NavigableMap<Long, String> getSymbolMapping() {
        return this.fSymbolMapping;
    }

    public String getEndSuffix() {
        return "END__";
    }

    public int hashCode() {
        return Objects.hash(this.fFullPath, this.fIsBinaryFile, this.fSymbolMapping);
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MappingFile other = (MappingFile)obj;
        return this.fFullPath.equals(other.fFullPath) && this.fIsBinaryFile == other.fIsBinaryFile && this.fSymbolMapping.equals(other.fSymbolMapping);
    }
}

