/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.panel.common;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.team.svn.core.operation.local.DiffViewerSettings;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.composite.DiffViewerExternalProgramComposite;
import org.eclipse.team.svn.ui.panel.AbstractDialogPanel;
import org.eclipse.team.svn.ui.verifier.AbstractFormattedVerifier;
import org.eclipse.team.svn.ui.verifier.AbstractValidationManagerProxy;
import org.eclipse.team.svn.ui.verifier.CompositeVerifier;
import org.eclipse.team.svn.ui.verifier.NonEmptyFieldVerifier;

public class EditFileAssociationsPanel
extends AbstractDialogPanel {
    protected DiffViewerSettings diffSettings;
    protected DiffViewerSettings.ResourceSpecificParameters param;
    protected Text extensionText;
    protected DiffViewerExternalProgramComposite diffExternalComposite;
    protected DiffViewerExternalProgramComposite mergeExternalComposite;

    public EditFileAssociationsPanel(DiffViewerSettings.ResourceSpecificParameters param, DiffViewerSettings diffSettings) {
        this.param = param;
        this.diffSettings = diffSettings;
        this.dialogTitle = this.param == null ? SVNUIMessages.EditFileAssociationsPanel_AddDialogTitle : SVNUIMessages.EditFileAssociationsPanel_EditDialogTitle;
        this.dialogDescription = SVNUIMessages.EditFileAssociationsPanel_DialogDescription;
        this.defaultMessage = SVNUIMessages.EditFileAssociationsPanel_DialogDefaultMessage;
    }

    public DiffViewerSettings.ResourceSpecificParameters getResourceSpecificParameters() {
        return this.param;
    }

    protected void createControlsImpl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        GridData data = new GridData(1808);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)data);
        Label extensionLabel = new Label(composite, 0);
        data = new GridData();
        extensionLabel.setLayoutData((Object)data);
        extensionLabel.setText(SVNUIMessages.EditFileAssociationsPanel_ExtensionMimeType_Label);
        this.extensionText = new Text(composite, 2052);
        data = new GridData();
        data.widthHint = 100;
        this.extensionText.setLayoutData((Object)data);
        this.diffExternalComposite = new DiffViewerExternalProgramComposite(SVNUIMessages.DiffViewerExternalProgramComposite_DiffProgramArguments_Label, composite, this);
        data = new GridData(768);
        data.horizontalSpan = 2;
        this.diffExternalComposite.setLayoutData(data);
        this.mergeExternalComposite = new DiffViewerExternalProgramComposite(SVNUIMessages.DiffViewerExternalProgramComposite_MergeProgramArguments_Label, composite, new AbstractValidationManagerProxy(this){

            protected boolean isVerificationEnabled(Control input) {
                return false;
            }
        });
        data = new GridData(768);
        data.horizontalSpan = 2;
        this.mergeExternalComposite.setLayoutData(data);
        CompositeVerifier cmpVerifier = new CompositeVerifier();
        cmpVerifier.add(new NonEmptyFieldVerifier(SVNUIMessages.EditFileAssociationsPanel_ExtensionMimeType_FieldName));
        cmpVerifier.add(new AbstractFormattedVerifier(SVNUIMessages.EditFileAssociationsPanel_ExtensionMimeType_FieldName){

            protected String getErrorMessageImpl(Control input) {
                String kindString = ((Text)input).getText();
                DiffViewerSettings.ResourceSpecificParameterKind kind = DiffViewerSettings.ResourceSpecificParameterKind.getKind((String)kindString);
                DiffViewerSettings.ResourceSpecificParameters resourceParams = EditFileAssociationsPanel.this.diffSettings.getResourceSpecificParameters(kind);
                if (resourceParams != null && (EditFileAssociationsPanel.this.param != null && !EditFileAssociationsPanel.this.param.kind.equals((Object)kind) || EditFileAssociationsPanel.this.param == null)) {
                    return SVNUIMessages.EditFileAssociationsPanel_DuplicateExtension_Verifier_Error;
                }
                return null;
            }

            protected String getWarningMessageImpl(Control input) {
                return null;
            }
        });
        this.attachTo((Control)this.extensionText, cmpVerifier);
        if (this.param != null) {
            if (this.param.kind.kindValue != null) {
                this.extensionText.setText(this.param.kind.formatKindValue());
            }
            this.diffExternalComposite.setProgramPath(this.param.params.diffProgramPath);
            this.diffExternalComposite.setProgramParameters(this.param.params.diffParamatersString);
            this.mergeExternalComposite.setProgramPath(this.param.params.mergeProgramPath);
            this.mergeExternalComposite.setProgramParameters(this.param.params.mergeParamatersString);
        }
    }

    protected void saveChangesImpl() {
        String extensionStr = this.extensionText.getText();
        DiffViewerSettings.ResourceSpecificParameterKind kind = DiffViewerSettings.ResourceSpecificParameterKind.getKind((String)extensionStr);
        DiffViewerSettings.ExternalProgramParameters externalProgramParams = new DiffViewerSettings.ExternalProgramParameters(this.diffExternalComposite.getProgramPath(), this.mergeExternalComposite.getProgramPath(), this.diffExternalComposite.getProgramParameters(), this.mergeExternalComposite.getProgramParameters());
        if (this.param == null) {
            this.param = new DiffViewerSettings.ResourceSpecificParameters(kind, externalProgramParams);
            this.param.isEnabled = true;
        } else {
            this.param.kind = kind;
            this.param.params = externalProgramParams;
        }
    }

    protected void cancelChangesImpl() {
        this.param = null;
    }
}

