/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.lock;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.dialog.DefaultDialog;
import org.eclipse.team.svn.ui.lock.LockResource;
import org.eclipse.team.svn.ui.lock.LockResourcesTableComparator;
import org.eclipse.team.svn.ui.lock.LockResourcesTableLabelProvider;
import org.eclipse.team.svn.ui.utility.ArrayStructuredContentProvider;

public class LockResourceSelectionComposite
extends Composite {
    public static final int COLUMN_NAME = 1;
    public static final int COLUMN_PATH = 2;
    public static final int COLUMN_STATE = 3;
    public static final int COLUMN_OWNER = 4;
    public static final int COLUMN_DATE = 5;
    protected LockResource[] resources;
    protected boolean showCheckBoxesAndButtons;
    protected boolean hasBorder;
    protected CheckboxTableViewer tableViewer;
    protected Label lblSelectedResourcesNumber;
    protected ISelectionChangedListener selectionListener;
    protected List<ILockResourceSelectionChangeListener> selectionChangedListeners;
    protected LockResource[] selectedResources;
    protected LockResource[] notSelectedResources;

    public LockResourceSelectionComposite(Composite parent, int style, boolean hasBorder, boolean showCheckBoxesAndButtons) {
        super(parent, style);
        this.showCheckBoxesAndButtons = showCheckBoxesAndButtons;
        this.hasBorder = hasBorder;
        this.resources = new LockResource[0];
        this.selectedResources = new LockResource[0];
        this.notSelectedResources = new LockResource[0];
        this.selectionChangedListeners = new ArrayList<ILockResourceSelectionChangeListener>();
        this.createControls();
    }

    protected void createControls() {
        TableColumn col;
        GridLayout gridLayout = null;
        GridData data = null;
        gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.setLayout((Layout)gridLayout);
        int style = 66306;
        if (this.hasBorder) {
            style |= 0x800;
        }
        Table table = new Table((Composite)this, this.showCheckBoxesAndButtons ? style | 0x20 : style);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableLayout layout = new TableLayout();
        table.setLayout((Layout)layout);
        this.tableViewer = new CheckboxTableViewer(table);
        data = new GridData(1808);
        this.tableViewer.getTable().setLayoutData((Object)data);
        LockResourcesTableComparator tableComparator = new LockResourcesTableComparator((Viewer)this.tableViewer);
        if (this.showCheckBoxesAndButtons) {
            col = new TableColumn(table, 0);
            col.setResizable(false);
            layout.addColumnData((ColumnLayoutData)new ColumnPixelData(20, false));
        } else {
            col = new TableColumn(table, 0);
            col.setText("");
            col.setResizable(false);
            col.setAlignment(0x1000000);
            layout.addColumnData((ColumnLayoutData)new ColumnPixelData(20, false));
        }
        col = new TableColumn(table, 0);
        col.setText(SVNUIMessages.LocksComposite_Name);
        col.addSelectionListener((SelectionListener)tableComparator);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(20, true));
        col = new TableColumn(table, 0);
        col.setText(SVNUIMessages.LocksComposite_Path);
        col.addSelectionListener((SelectionListener)tableComparator);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(30, true));
        col = new TableColumn(table, 0);
        col.setText(SVNUIMessages.LocksComposite_State);
        col.addSelectionListener((SelectionListener)tableComparator);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(20, true));
        col = new TableColumn(table, 0);
        col.setText(SVNUIMessages.LocksComposite_Owner);
        col.addSelectionListener((SelectionListener)tableComparator);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(20, true));
        col = new TableColumn(table, 0);
        col.setText(SVNUIMessages.LocksComposite_CreationDate);
        col.addSelectionListener((SelectionListener)tableComparator);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(10, true));
        tableComparator.setReversed(false);
        tableComparator.setColumnNumber(2);
        this.tableViewer.setComparator((ViewerComparator)tableComparator);
        this.tableViewer.getTable().setSortColumn(this.tableViewer.getTable().getColumn(2));
        this.tableViewer.getTable().setSortDirection(128);
        this.tableViewer.setContentProvider((IContentProvider)new ArrayStructuredContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new LockResourcesTableLabelProvider(this.showCheckBoxesAndButtons));
        this.selectionListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (LockResourceSelectionComposite.this.showCheckBoxesAndButtons) {
                    LockResourceSelectionComposite.this.updateSelectedResources();
                    int selectedNumber = LockResourceSelectionComposite.this.selectedResources.length;
                    LockResourceSelectionComposite.this.lblSelectedResourcesNumber.setText(LockResourceSelectionComposite.this.resourceNumberToString(selectedNumber));
                }
                LockResourceSelectionComposite.this.fireResourcesSelectionChanged(new LockResourceSelectionChangedEvent(LockResourceSelectionComposite.this.selectedResources, event != null ? event.getSelection() : null));
            }
        };
        this.tableViewer.addSelectionChangedListener(this.selectionListener);
        if (!this.showCheckBoxesAndButtons) {
            return;
        }
        Composite tComposite = new Composite((Composite)this, 131072);
        GridLayout gLayout = new GridLayout();
        gLayout.numColumns = 3;
        gLayout.marginWidth = 0;
        tComposite.setLayout((Layout)gLayout);
        data = new GridData(768);
        tComposite.setLayoutData((Object)data);
        Button selectButton = new Button(tComposite, 8);
        selectButton.setText(SVNUIMessages.Button_SelectAll);
        data = new GridData();
        data.widthHint = DefaultDialog.computeButtonWidth(selectButton);
        selectButton.setLayoutData((Object)data);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LockResourceSelectionComposite.this.tableViewer.setAllChecked(true);
                Object[] elements = LockResourceSelectionComposite.this.tableViewer.getCheckedElements();
                LockResourceSelectionComposite.this.selectionListener.selectionChanged(null);
                LockResourceSelectionComposite.this.fireResourcesSelectionChanged(new LockResourceSelectionChangedEvent(Arrays.asList(elements).toArray(new LockResource[elements.length]), null));
            }
        };
        selectButton.addSelectionListener((SelectionListener)listener);
        Button deselectButton = new Button(tComposite, 8);
        deselectButton.setText(SVNUIMessages.Button_ClearSelection);
        data = new GridData();
        data.widthHint = DefaultDialog.computeButtonWidth(deselectButton);
        deselectButton.setLayoutData((Object)data);
        listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LockResourceSelectionComposite.this.tableViewer.setAllChecked(false);
                LockResourceSelectionComposite.this.selectionListener.selectionChanged(null);
                LockResourceSelectionComposite.this.fireResourcesSelectionChanged(new LockResourceSelectionChangedEvent(new LockResource[0], null));
            }
        };
        deselectButton.addSelectionListener((SelectionListener)listener);
        Composite lComposite = new Composite(tComposite, 0);
        GridLayout lLayout = new GridLayout();
        lLayout.horizontalSpacing = 0;
        lLayout.marginWidth = 0;
        lComposite.setLayout((Layout)lLayout);
        data = new GridData(768);
        lComposite.setLayoutData((Object)data);
        this.lblSelectedResourcesNumber = new Label(lComposite, 131072);
        this.lblSelectedResourcesNumber.setText(this.resourceNumberToString(this.selectedResources.length));
        data = new GridData(768);
        this.lblSelectedResourcesNumber.setLayoutData((Object)data);
    }

    protected String resourceNumberToString(int value) {
        return SVNUIMessages.format((String)SVNUIMessages.ResourceSelectionComposite_Info, (Object[])new String[]{String.valueOf(value), String.valueOf(this.resources.length)});
    }

    public void setInput(LockResource[] resources) {
        this.resources = resources;
        this.selectedResources = resources;
        this.tableViewer.setInput((Object)resources);
        if (this.resources != null) {
            int i = 0;
            while (i < this.resources.length) {
                this.tableViewer.setChecked((Object)this.resources[i], true);
                ++i;
            }
            if (this.showCheckBoxesAndButtons) {
                this.lblSelectedResourcesNumber.setText(this.resourceNumberToString(this.selectedResources.length));
            }
        }
        if (this.showCheckBoxesAndButtons) {
            this.updateSelectedResources();
            this.selectionListener.selectionChanged(null);
        }
        this.tableViewer.refresh();
    }

    protected void updateSelectedResources() {
        TableItem[] items = this.tableViewer.getTable().getItems();
        ArrayList<LockResource> checked = new ArrayList<LockResource>(items.length);
        ArrayList unchecked = new ArrayList();
        int i = 0;
        while (i < items.length) {
            (items[i].getChecked() ? checked : unchecked).add((LockResource)items[i].getData());
            ++i;
        }
        this.selectedResources = checked.toArray(new LockResource[checked.size()]);
        this.notSelectedResources = unchecked.toArray(new LockResource[unchecked.size()]);
    }

    public TableViewer getTableViewer() {
        return this.tableViewer;
    }

    public LockResource[] getSelectedResources() {
        return this.selectedResources;
    }

    public LockResource[] getNotSelectedResources() {
        return this.notSelectedResources;
    }

    public void addResourcesSelectionChangedListener(ILockResourceSelectionChangeListener listener) {
        this.selectionChangedListeners.add(listener);
    }

    public void removeResourcesSelectionChangedListener(ILockResourceSelectionChangeListener listener) {
        this.selectionChangedListeners.remove(listener);
    }

    public void fireResourcesSelectionChanged(LockResourceSelectionChangedEvent event) {
        ILockResourceSelectionChangeListener[] listeners = this.selectionChangedListeners.toArray(new ILockResourceSelectionChangeListener[this.selectionChangedListeners.size()]);
        int i = 0;
        while (i < listeners.length) {
            listeners[i].resourcesSelectionChanged(event);
            ++i;
        }
    }

    public void setMenuManager(MenuManager menuMgr) {
        Menu menu = menuMgr.createContextMenu((Control)this.tableViewer.getTable());
        this.tableViewer.getTable().setMenu(menu);
    }

    public static interface ILockResourceSelectionChangeListener {
        public void resourcesSelectionChanged(LockResourceSelectionChangedEvent var1);
    }

    public static class LockResourceSelectionChangedEvent {
        public final LockResource[] checkedResources;
        public final IStructuredSelection selection;

        public LockResourceSelectionChangedEvent(LockResource[] resources, ISelection selection) {
            this.checkedResources = resources;
            this.selection = (IStructuredSelection)selection;
        }
    }
}

