/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.file.refactor;

import java.io.File;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.operation.IUnprotectedOperation;
import org.eclipse.team.svn.core.operation.SVNProgressMonitor;
import org.eclipse.team.svn.core.operation.file.AbstractFileOperation;
import org.eclipse.team.svn.core.operation.file.IFileProvider;
import org.eclipse.team.svn.core.operation.file.SVNFileStorage;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.core.utility.ProgressMonitorUtility;

public class DeleteOperation
extends AbstractFileOperation {
    public DeleteOperation(File[] files) {
        super("Operation_DeleteFile", SVNMessages.class, files);
    }

    public DeleteOperation(IFileProvider provider) {
        super("Operation_DeleteFile", SVNMessages.class, provider);
    }

    protected void runImpl(IProgressMonitor monitor) throws Exception {
        File[] files = FileUtility.shrinkChildNodes(this.operableData(), false);
        int i = 0;
        while (i < files.length && !monitor.isCanceled()) {
            final File current = files[i];
            IRepositoryResource remote = SVNFileStorage.instance().asRepositoryResource(current, true);
            if (remote == null) {
                ProgressMonitorUtility.setTaskInfo(monitor, this, current.getAbsolutePath());
                FileUtility.deleteRecursive(current, monitor);
                ProgressMonitorUtility.progress(monitor, i, files.length);
            } else {
                IRepositoryLocation location = remote.getRepositoryLocation();
                final ISVNConnector proxy = location.acquireSVNProxy();
                this.protectStep(new IUnprotectedOperation(){

                    public void run(IProgressMonitor monitor) throws Exception {
                        DeleteOperation.this.writeToConsole(0, "svn delete \"" + FileUtility.normalizePath(current.getAbsolutePath()) + "\"" + ISVNConnector.Options.asCommandLine(4L) + "\n");
                        proxy.removeLocal(new String[]{current.getAbsolutePath()}, 4L, new SVNProgressMonitor(DeleteOperation.this, monitor, null));
                    }
                }, monitor, files.length);
                location.releaseSVNProxy(proxy);
            }
            ++i;
        }
    }
}

