/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.util;

import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.ListenerContext;

public final class MutableReference<T> {
    private T value;
    private ListenerContext listeners;

    public MutableReference() {
        this(null);
    }

    public MutableReference(T value) {
        this.value = value;
    }

    public synchronized T get() {
        return this.value;
    }

    public synchronized void set(T value) {
        T oldValue = this.value;
        this.value = value;
        if (this.listeners != null) {
            this.listeners.broadcast(new ReferenceChangedEvent(oldValue, value));
        }
    }

    public synchronized boolean attach(Listener listener) {
        if (this.listeners == null) {
            this.listeners = new ListenerContext();
        }
        return this.listeners.attach(listener);
    }

    public synchronized boolean detach(Listener listener) {
        if (this.listeners == null) {
            this.listeners = new ListenerContext();
        }
        return this.listeners.detach(listener);
    }

    public final class ReferenceChangedEvent
    extends Event {
        private final T before;
        private final T after;

        private ReferenceChangedEvent(T before, T after) {
            this.before = before;
            this.after = after;
        }

        public T before() {
            return this.before;
        }

        public T after() {
            return this.after;
        }
    }
}

