/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.internal;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.sapphire.ConversionException;
import org.eclipse.sapphire.ConversionService;

public final class StringToDateConversionService
extends ConversionService<String, Date> {
    private final List<DateFormat> formats = new ArrayList<DateFormat>(10);

    public StringToDateConversionService() {
        super(String.class, Date.class);
        this.formats.add(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'.'SSSZ"));
        this.formats.add(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'.'SSS"));
        this.formats.add(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss"));
        this.formats.add(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm"));
        this.formats.add(new SimpleDateFormat("yyyy-MM-dd"));
        this.formats.add(new SimpleDateFormat("HH:mm"));
        this.formats.add(new SimpleDateFormat("h:mm a"));
        DateFormat format = DateFormat.getDateInstance();
        if (!this.formats.contains(format)) {
            this.formats.add(format);
        }
        if (!this.formats.contains(format = DateFormat.getTimeInstance())) {
            this.formats.add(format);
        }
        if (!this.formats.contains(format = DateFormat.getDateTimeInstance())) {
            this.formats.add(format);
        }
    }

    @Override
    public synchronized Date convert(String string) {
        for (DateFormat format : this.formats) {
            try {
                return format.parse(string);
            }
            catch (ParseException parseException) {}
        }
        throw new ConversionException();
    }
}

