/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.models;

import java.util.Objects;
import org.eclipse.recommenders.coordinates.ProjectCoordinate;
import org.eclipse.recommenders.models.IUniqueName;

public abstract class AbstractUniqueName<T>
implements IUniqueName<T> {
    private final T name;
    private final ProjectCoordinate pc;

    public AbstractUniqueName(ProjectCoordinate pc, T name) {
        this.name = name;
        this.pc = pc;
    }

    @Override
    public T getName() {
        return this.name;
    }

    @Override
    public ProjectCoordinate getProjectCoordinate() {
        return this.pc;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.pc);
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        AbstractUniqueName that = (AbstractUniqueName)other;
        return Objects.equals(this.name, that.name) && Objects.equals(this.pc, that.pc);
    }

    public String toString() {
        return String.valueOf(this.name.toString()) + '@' + this.pc;
    }
}

