/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.phpunit.ui.view;

import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.php.phpunit.model.elements.PHPUnitTestCase;
import org.eclipse.php.phpunit.model.providers.DiffLine;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class DiffLabelProvider
extends ColumnLabelProvider {
    private final Color minusBackground = new Color((Device)Display.getDefault(), 255, 255, 165);
    private final Color plusBackground = new Color((Device)Display.getDefault(), 220, 245, 185);
    private final Color minusForeground = Display.getDefault().getSystemColor(9);
    private final Color plusForeground = Display.getDefault().getSystemColor(12);
    private final Color sameForeground = Display.getDefault().getSystemColor(10);

    public String getText(Object element) {
        if (element instanceof DiffLine) {
            return element.toString();
        }
        if (element instanceof PHPUnitTestCase) {
            return ((PHPUnitTestCase)element).getException().getMessage();
        }
        return "";
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public Image getImage(Object element) {
        return null;
    }

    public Color getForeground(Object element) {
        String text;
        if (element instanceof DiffLine && (text = element.toString()).contains("=>")) {
            if (text.startsWith("+")) {
                return this.plusForeground;
            }
            if (text.startsWith("-")) {
                return this.minusForeground;
            }
            return this.sameForeground;
        }
        return null;
    }

    public Color getBackground(Object element) {
        String text;
        if (element instanceof DiffLine && (text = element.toString()).contains("=>")) {
            if (text.startsWith("+")) {
                return this.plusBackground;
            }
            if (text.startsWith("-")) {
                return this.minusBackground;
            }
        }
        return null;
    }
}

