/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.phpunit.model.connection;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.php.internal.debug.core.zend.debugger.RemoteDebugger;
import org.eclipse.php.internal.debug.core.zend.model.PHPDebugTarget;
import org.eclipse.php.phpunit.model.elements.PHPUnitElement;
import org.eclipse.php.phpunit.model.elements.PHPUnitElementManager;
import org.eclipse.php.phpunit.model.elements.PHPUnitTestCase;
import org.eclipse.php.phpunit.model.elements.PHPUnitTestException;
import org.eclipse.php.phpunit.model.elements.PHPUnitTestGroup;
import org.eclipse.php.phpunit.model.elements.PHPUnitTestWarning;
import org.eclipse.php.phpunit.ui.view.TestViewer;

public class PHPUnitMessageParser {
    public static final String CALL_DYNAMIC = "->";
    public static final String CALL_STATIC = "::";
    private static final String ELEMENT_EVENT = "event";
    private static final String ELEMENT_EXCEPTION = "exception";
    private static final String ELEMENT_TARGET_TESTSUITE = "testsuite";
    private static final String ELEMENT_TARGET_TESTCASE = "testcase";
    private static final String ELEMENT_TEST = "test";
    private static final String ELEMENT_WARNINGS = "warnings";
    public static final String PROPERTY_CLASS = "class";
    public static final String PROPERTY_CODE = "code";
    public static final String PROPERTY_COUNT = "tests";
    public static final String PROPERTY_FILE = "file";
    public static final String PROPERTY_FILTERED = "filtered";
    public static final String PROPERTY_LINE = "line";
    public static final String PROPERTY_MESSAGE = "message";
    public static final String PROPERTY_DIFF = "diff";
    public static final String PROPERTY_NAME = "name";
    private static final String PROPERTY_TARGET = "target";
    public static final String PROPERTY_TRACE = "trace";
    public static final String STATUS_ERROR = "error";
    public static final String STATUS_FAIL = "fail";
    public static final String STATUS_INCOMPLETE = "incomplete";
    public static final String STATUS_PASS = "pass";
    public static final String STATUS_SKIP = "skip";
    public static final String TAG_END = "end";
    public static final String TAG_START = "start";
    private static PHPUnitMessageParser instance;
    private RemoteDebugger remoteDebugger;
    private PHPUnitTestGroup currentGroup;
    private PHPUnitTestCase currentTestCase;
    private boolean inProgress = false;

    public static PHPUnitMessageParser getInstance() {
        if (instance == null) {
            instance = new PHPUnitMessageParser();
        }
        return instance;
    }

    private PHPUnitMessageParser() {
    }

    public void parseMessage(Map<?, ?> message, TestViewer viewer) {
        if (!this.isInProgress()) {
            this.setInProgress(true);
        }
        if (message == null) {
            return;
        }
        String target = (String)message.get(PROPERTY_TARGET);
        String event = (String)message.get(ELEMENT_EVENT);
        Map mTest = (Map)message.get(ELEMENT_TEST);
        if (target.equals(ELEMENT_TARGET_TESTSUITE)) {
            this.parseGroupStart(viewer, event, mTest);
            if (event.equals(TAG_END)) {
                this.parseGroupEnd(viewer);
            }
        } else if (target.equals(ELEMENT_TARGET_TESTCASE)) {
            if (event.equals(TAG_START)) {
                this.parseTestStart(viewer, event, mTest);
            } else {
                this.parseTestEnd(message, viewer, event, mTest);
            }
        }
    }

    private void parseGroupStart(TestViewer viewer, String event, Map<?, ?> mTest) {
        if (!event.equals(TAG_START)) {
            return;
        }
        PHPUnitTestGroup group = new PHPUnitTestGroup(mTest, this.currentGroup, this.remoteDebugger);
        this.mapTest(group);
        if (this.currentGroup.getTotalCount() > 0) {
            this.currentGroup.addChild(group, false);
            viewer.registerViewerUpdate(this.currentGroup);
            viewer.registerTestAdded();
            group.setParent(this.currentGroup);
        }
        this.currentGroup = group;
        this.currentTestCase = null;
        if (this.currentGroup.getTotalCount() > 0 && PHPUnitElementManager.getInstance().getRoot().getTotalCount() == 0) {
            PHPUnitElementManager.getInstance().setRoot(this.currentGroup);
            viewer.registerTestAdded();
        }
    }

    private void parseTestStart(TestViewer viewer, String event, Map<?, ?> mTest) {
        PHPUnitTestCase testCase;
        this.currentTestCase = testCase = new PHPUnitTestCase(mTest, this.currentGroup, event, this.remoteDebugger);
        this.mapTest(testCase);
        this.currentGroup.addChild(testCase, false);
        viewer.registerTestAdded();
    }

    private void parseTestEnd(Map<?, ?> message, TestViewer viewer, String event, Map<?, ?> mTest) {
        Map warnings;
        PHPUnitTestCase testCase = this.currentTestCase;
        testCase.updateStatus(event);
        Map exception = (Map)message.get(ELEMENT_EXCEPTION);
        if (exception != null) {
            this.mapException(testCase, exception);
        }
        if ((warnings = (Map)message.get(ELEMENT_WARNINGS)) != null) {
            this.mapWarnings(testCase, warnings);
        }
        this.currentGroup.addChild(testCase, true);
        viewer.registerTestAdded();
        if (testCase.getStatus() > 1) {
            viewer.registerAutoScrollTarget(testCase);
            viewer.registerFailedForAutoScroll(testCase);
        }
    }

    public void clean() {
        PHPUnitElementManager manager = PHPUnitElementManager.getInstance();
        manager.initialize();
        this.currentGroup = manager.getRoot();
        this.currentTestCase = null;
    }

    public boolean isInProgress() {
        return this.inProgress;
    }

    public void mapException(PHPUnitTestCase testCase, Map<?, ?> exception) {
        testCase.setException(new PHPUnitTestException(exception, testCase, this.remoteDebugger));
        this.mapTest(testCase.getException());
    }

    private void mapTest(PHPUnitElement test) {
        PHPUnitElementManager.getInstance().add(test.getTestId(), test);
    }

    private void mapWarnings(PHPUnitTestCase testCase, Map<?, ?> warnings) {
        Map mWarning;
        int i = 0;
        while ((mWarning = (Map)warnings.get(String.valueOf(i))) != null) {
            if (testCase.getWarnings() == null) {
                testCase.setWarnings(new ArrayList<PHPUnitElement>(warnings.size()));
            }
            PHPUnitTestWarning warning = new PHPUnitTestWarning(mWarning, testCase, this.remoteDebugger);
            this.mapTest(warning);
            testCase.getWarnings().add(i, warning);
            ++i;
        }
    }

    private void parseGroupEnd(TestViewer viewer) {
        this.currentGroup = (PHPUnitTestGroup)this.currentGroup.getParent();
        this.currentTestCase = null;
        viewer.registerViewerUpdate(this.currentGroup);
    }

    public void setInProgress(boolean inProgress) {
        this.inProgress = inProgress;
    }

    public void setDebugTarget(IDebugTarget debugTarget) {
        if (debugTarget instanceof PHPDebugTarget) {
            PHPDebugTarget phpDebugTarget = (PHPDebugTarget)debugTarget;
            this.remoteDebugger = (RemoteDebugger)phpDebugTarget.getRemoteDebugger();
        } else {
            this.remoteDebugger = null;
        }
    }

    public PHPUnitTestCase getCurrentTestCase() {
        return this.currentTestCase;
    }
}

