/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.formatter.ui.preferences;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.php.core.format.IProfile;
import org.eclipse.php.core.format.IProfileManager;
import org.eclipse.php.formatter.core.profiles.CodeFormatterPreferences;
import org.eclipse.php.formatter.ui.FormatterMessages;
import org.eclipse.php.internal.formatter.core.FormattingProfile;
import org.eclipse.php.internal.formatter.core.FormattingProfileRegistry;
import org.eclipse.php.internal.ui.util.Messages;

public class ProfileManager
extends Observable
implements IProfileManager {
    private static final String ID_PREFIX = "_";
    public static final int SELECTION_CHANGED_EVENT = 1;
    public static final int PROFILE_DELETED_EVENT = 2;
    public static final int PROFILE_RENAMED_EVENT = 3;
    public static final int PROFILE_CREATED_EVENT = 4;
    public static final int SETTINGS_CHANGED_EVENT = 5;
    private static final String PROFILE_KEY = "formatterProfile";
    public static final String SHARED_PROFILE = "org.eclipse.php.formatter.ui.default.shared";
    private final Map<String, Profile> fProfiles;
    private final List<Profile> fProfilesByName;
    private Profile fSelected;
    private static final List<String> fKeys;
    private static final Map<String, Object> EMPTY_MAP;

    static {
        EMPTY_MAP = Collections.emptyMap();
        fKeys = new ArrayList(CodeFormatterPreferences.getDefaultPreferences().getMap().keySet());
        Collections.sort(fKeys);
    }

    /*
     * WARNING - void declaration
     */
    public ProfileManager(List<Profile> profiles, IScopeContext context) {
        block4: {
            String projProfileId;
            Profile matching;
            Map<String, Object> map;
            block6: {
                block5: {
                    void var4_7;
                    this.fProfiles = new HashMap<String, Profile>();
                    this.fProfilesByName = new ArrayList<Profile>();
                    this.addBuiltinProfiles(this.fProfiles, this.fProfilesByName);
                    for (CustomProfile customProfile : profiles) {
                        customProfile.setManager(this);
                        this.fProfiles.put(customProfile.getID(), customProfile);
                        this.fProfilesByName.add(customProfile);
                    }
                    Collections.sort(this.fProfilesByName);
                    IScopeContext instanceScope = InstanceScope.INSTANCE;
                    String string = instanceScope.getNode("org.eclipse.php.formatter.core").get(PROFILE_KEY, null);
                    if (string == null) {
                        String string2 = DefaultScope.INSTANCE.getNode("org.eclipse.php.formatter.core").get(PROFILE_KEY, null);
                    }
                    Profile profile = this.fProfiles.get(var4_7);
                    Assert.isNotNull((Object)profile);
                    this.fSelected = profile;
                    if (context.getName() != "project" || !ProfileManager.hasProjectSpecificSettings(context) || (map = this.readFromPreferenceStore(context, profile)) == null) break block4;
                    matching = null;
                    projProfileId = context.getNode("org.eclipse.php.formatter.core").get(PROFILE_KEY, null);
                    if (projProfileId == null) break block5;
                    Profile curr = this.fProfiles.get(projProfileId);
                    if (curr == null || !curr.isBuiltInProfile() && !curr.hasEqualSettings(map, ProfileManager.getKeys())) break block6;
                    matching = curr;
                    break block6;
                }
                for (Profile curr : this.fProfilesByName) {
                    if (!curr.hasEqualSettings(map, ProfileManager.getKeys())) continue;
                    matching = curr;
                    break;
                }
            }
            if (matching == null) {
                String name = projProfileId != null && !this.fProfiles.containsKey(projProfileId) ? Messages.format((String)FormatterMessages.ProfileManager_unmanaged_profile_with_name, (Object)projProfileId.substring(ID_PREFIX.length())) : FormatterMessages.ProfileManager_unmanaged_profile;
                SharedProfile shared = new SharedProfile(name, map);
                shared.setManager(this);
                this.fProfiles.put(shared.getID(), shared);
                this.fProfilesByName.add(shared);
                matching = shared;
            }
            this.fSelected = matching;
        }
    }

    protected void notifyObservers(int message) {
        this.setChanged();
        this.notifyObservers((Object)message);
    }

    public static boolean hasProjectSpecificSettings(IScopeContext context) {
        IEclipsePreferences prefs = context.getNode("org.eclipse.php.formatter.core");
        return prefs.get(PROFILE_KEY, null) != null;
    }

    public Map<String, Object> readFromPreferenceStore(IScopeContext context, Profile workspaceProfile) {
        HashMap<String, Object> profileOptions = new HashMap<String, Object>();
        IEclipsePreferences prefs = context.getNode("org.eclipse.php.formatter.core");
        boolean hasValues = false;
        for (String key : fKeys) {
            Object val = prefs.get(key, null);
            if (val != null) {
                hasValues = true;
            } else {
                val = workspaceProfile.getSettings().get(key);
            }
            profileOptions.put(key, val);
        }
        if (!hasValues) {
            return null;
        }
        return profileOptions;
    }

    private boolean updatePreferences(IEclipsePreferences prefs, List<String> keys, Map<String, Object> profileOptions) {
        boolean hasChanges = false;
        for (String key : keys) {
            String oldVal = prefs.get(key, null);
            String val = (String)profileOptions.get(key);
            if (val == null) {
                if (oldVal == null) continue;
                prefs.remove(key);
                hasChanges = true;
                continue;
            }
            if (val.equals(oldVal)) continue;
            prefs.put(key, val);
            hasChanges = true;
        }
        return hasChanges;
    }

    private void writeToPreferenceStore(Profile profile, IScopeContext context) {
        Map<String, Object> profileOptions = profile.getSettings();
        IEclipsePreferences prefs = context.getNode("org.eclipse.php.formatter.core");
        this.updatePreferences(prefs, fKeys, profileOptions);
        if (context.getName() == "instance") {
            prefs.put(PROFILE_KEY, profile.getID());
        } else if (context.getName() == "project" && !profile.isSharedProfile()) {
            prefs.put(PROFILE_KEY, profile.getID());
        }
    }

    private void addBuiltinProfiles(Map<String, Profile> profiles, List<Profile> profilesByName) {
        int order = 1;
        String builtinPostFix = FormatterMessages.ProfileManager_built_in_postfix;
        Collection elements = new FormattingProfileRegistry().getProfiles();
        for (FormattingProfile profile : elements) {
            CodeFormatterPreferences preferences = profile.getImplementation().initValues();
            BuiltInProfile extensionProfile = new BuiltInProfile(profile.getId(), String.valueOf(profile.getName()) + builtinPostFix, preferences.getMap(), ++order);
            profiles.put(((Profile)extensionProfile).getID(), extensionProfile);
            profilesByName.add(extensionProfile);
        }
    }

    public static Map<String, Object> getPHPSettings() {
        Map options = CodeFormatterPreferences.getDefaultPreferences().getMap();
        return options;
    }

    public static Map<String, Object> getDefaultSettings() {
        return ProfileManager.getPHPSettings();
    }

    public static List<String> getKeys() {
        return fKeys;
    }

    public List<Profile> getSortedProfiles() {
        return Collections.unmodifiableList(this.fProfilesByName);
    }

    public String[] getSortedDisplayNames() {
        String[] sortedNames = new String[this.fProfilesByName.size()];
        int i = 0;
        for (Profile curr : this.fProfilesByName) {
            sortedNames[i++] = curr.getName();
        }
        return sortedNames;
    }

    public Profile getProfile(String ID) {
        return this.fProfiles.get(ID);
    }

    public void commitChanges(IScopeContext scopeContext) {
        if (this.fSelected != null) {
            this.writeToPreferenceStore(this.fSelected, scopeContext);
        }
    }

    public void clearAllSettings(IScopeContext context) {
        IEclipsePreferences prefs = context.getNode("org.eclipse.php.formatter.core");
        this.updatePreferences(prefs, fKeys, EMPTY_MAP);
        prefs.remove(PROFILE_KEY);
    }

    public Profile getSelected() {
        return this.fSelected;
    }

    public void setSelected(IProfile profile) {
        this.setSelected(profile.getID());
    }

    public void setSelected(String profileId) {
        Profile newSelected = this.fProfiles.get(profileId);
        if (newSelected != null) {
            this.fSelected = newSelected;
            this.notifyObservers(1);
        }
    }

    public boolean containsName(String name) {
        for (Profile curr : this.fProfilesByName) {
            if (!name.equals(curr.getName())) continue;
            return true;
        }
        return false;
    }

    public void addProfile(CustomProfile profile) {
        profile.setManager(this);
        CustomProfile oldProfile = (CustomProfile)this.fProfiles.get(profile.getID());
        if (oldProfile != null) {
            this.fProfiles.remove(oldProfile.getID());
            this.fProfilesByName.remove(oldProfile);
            oldProfile.setManager(null);
        }
        this.fProfiles.put(profile.getID(), profile);
        this.fProfilesByName.add(profile);
        Collections.sort(this.fProfilesByName);
        this.fSelected = profile;
        this.notifyObservers(4);
    }

    public boolean deleteSelected() {
        if (!(this.fSelected instanceof CustomProfile)) {
            return false;
        }
        Profile removedProfile = this.fSelected;
        int index = this.fProfilesByName.indexOf(removedProfile);
        this.fProfiles.remove(removedProfile.getID());
        this.fProfilesByName.remove(removedProfile);
        ((CustomProfile)removedProfile).setManager(null);
        if (index >= this.fProfilesByName.size()) {
            --index;
        }
        this.fSelected = this.fProfilesByName.get(index);
        if (!removedProfile.isSharedProfile()) {
            this.updateProfilesWithName(removedProfile.getID(), null, false);
        }
        this.notifyObservers(2);
        return true;
    }

    public void profileRenamed(CustomProfile profile, String oldID) {
        this.fProfiles.remove(oldID);
        this.fProfiles.put(profile.getID(), profile);
        if (!profile.isSharedProfile()) {
            this.updateProfilesWithName(oldID, profile, false);
        }
        Collections.sort(this.fProfilesByName);
        this.notifyObservers(3);
    }

    public void profileReplaced(CustomProfile oldProfile, CustomProfile newProfile) {
        this.fProfiles.remove(oldProfile.getID());
        this.fProfiles.put(newProfile.getID(), newProfile);
        this.fProfilesByName.remove(oldProfile);
        this.fProfilesByName.add(newProfile);
        Collections.sort(this.fProfilesByName);
        if (!oldProfile.isSharedProfile()) {
            this.updateProfilesWithName(oldProfile.getID(), null, false);
        }
        this.setSelected(newProfile);
        this.notifyObservers(4);
        this.notifyObservers(1);
    }

    public void profileChanged(CustomProfile profile) {
        if (!profile.isSharedProfile()) {
            this.updateProfilesWithName(profile.getID(), profile, true);
        }
        this.notifyObservers(5);
    }

    private void updateProfilesWithName(String oldName, Profile newProfile, boolean applySettings) {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            ProjectScope projectScope = new ProjectScope(projects[i]);
            IEclipsePreferences node = projectScope.getNode("org.eclipse.php.formatter.core");
            String profileId = node.get(PROFILE_KEY, null);
            if (oldName.equals(profileId)) {
                if (newProfile == null) {
                    node.remove(PROFILE_KEY);
                } else if (applySettings) {
                    this.writeToPreferenceStore(newProfile, (IScopeContext)projectScope);
                } else {
                    node.put(PROFILE_KEY, newProfile.getID());
                }
            }
            ++i;
        }
        IScopeContext instanceScope = InstanceScope.INSTANCE;
        IEclipsePreferences uiPrefs = instanceScope.getNode("org.eclipse.php.formatter.core");
        if (newProfile != null && oldName.equals(uiPrefs.get(PROFILE_KEY, null))) {
            this.writeToPreferenceStore(newProfile, instanceScope);
        }
    }

    public Profile getDefaultProfile() {
        String profileId = DefaultScope.INSTANCE.getNode("org.eclipse.php.formatter.core").get(PROFILE_KEY, null);
        if (profileId == null) {
            return null;
        }
        return this.getProfile(profileId);
    }

    public static final class BuiltInProfile
    extends Profile {
        private final String fName;
        private final String fID;
        private final Map<String, Object> fSettings;
        private final int fOrder;

        protected BuiltInProfile(String ID, String name, Map<String, Object> settings, int order) {
            this.fName = name;
            this.fID = ID;
            this.fSettings = settings;
            this.fOrder = order;
        }

        @Override
        public String getName() {
            return this.fName;
        }

        @Override
        public Profile rename(String name, ProfileManager manager) {
            String trimmed = name.trim();
            CustomProfile newProfile = new CustomProfile(trimmed, this.fSettings);
            manager.addProfile(newProfile);
            return newProfile;
        }

        @Override
        public Map<String, Object> getSettings() {
            return this.fSettings;
        }

        @Override
        public void setSettings(Map<String, Object> settings) {
        }

        @Override
        public String getID() {
            return this.fID;
        }

        @Override
        public final int compareTo(Object o) {
            if (o instanceof BuiltInProfile) {
                return this.fOrder - ((BuiltInProfile)o).fOrder;
            }
            return -1;
        }

        @Override
        public boolean isProfileToSave() {
            return false;
        }

        @Override
        public boolean isBuiltInProfile() {
            return true;
        }
    }

    public static class CustomProfile
    extends Profile {
        private String fName;
        private Map<String, Object> fSettings;
        protected ProfileManager fManager;

        public CustomProfile(String name, Map<String, Object> settings) {
            this.fName = name;
            this.fSettings = settings;
        }

        @Override
        public String getName() {
            return this.fName;
        }

        @Override
        public Profile rename(String name, ProfileManager manager) {
            String trimmed = name.trim();
            if (trimmed.equals(this.getName())) {
                return this;
            }
            String oldID = this.getID();
            this.fName = trimmed;
            manager.profileRenamed(this, oldID);
            return this;
        }

        @Override
        public Map<String, Object> getSettings() {
            return this.fSettings;
        }

        @Override
        public void setSettings(Map<String, Object> settings) {
            if (settings == null) {
                throw new IllegalArgumentException();
            }
            this.fSettings = settings;
            if (this.fManager != null) {
                this.fManager.profileChanged(this);
            }
        }

        @Override
        public String getID() {
            return ProfileManager.ID_PREFIX + this.fName;
        }

        public void setManager(ProfileManager profileManager) {
            this.fManager = profileManager;
        }

        public ProfileManager getManager() {
            return this.fManager;
        }

        @Override
        public int compareTo(Object o) {
            if (o instanceof SharedProfile) {
                return -1;
            }
            if (o instanceof CustomProfile) {
                return this.getName().compareToIgnoreCase(((Profile)o).getName());
            }
            return 1;
        }

        @Override
        public boolean isProfileToSave() {
            return true;
        }
    }

    public static abstract class Profile
    implements Comparable<Object>,
    IProfile {
        public abstract String getName();

        public abstract Profile rename(String var1, ProfileManager var2);

        public abstract Map<String, Object> getSettings();

        public abstract void setSettings(Map<String, Object> var1);

        public boolean hasEqualSettings(Map<String, Object> otherMap, List<String> allKeys) {
            Map<String, Object> settings = this.getSettings();
            for (String key : allKeys) {
                Object other = otherMap.get(key);
                Object curr = settings.get(key);
                if (!(other == null ? curr != null : !other.equals(curr))) continue;
                return false;
            }
            return true;
        }

        public abstract boolean isProfileToSave();

        public abstract String getID();

        public boolean isSharedProfile() {
            return false;
        }

        public boolean isBuiltInProfile() {
            return false;
        }
    }

    public static final class SharedProfile
    extends CustomProfile {
        public SharedProfile(String oldName, Map<String, Object> options) {
            super(oldName, options);
        }

        @Override
        public Profile rename(String name, ProfileManager manager) {
            CustomProfile profile = new CustomProfile(name.trim(), this.getSettings());
            manager.profileReplaced(this, profile);
            return profile;
        }

        @Override
        public String getID() {
            return ProfileManager.SHARED_PROFILE;
        }

        @Override
        public final int compareTo(Object o) {
            return 1;
        }

        @Override
        public boolean isProfileToSave() {
            return false;
        }

        @Override
        public boolean isSharedProfile() {
            return true;
        }
    }
}

