/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.psf.handler;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.infra.psf.Activator;
import org.eclipse.papyrus.infra.psf.runtime.ImportResult;
import org.eclipse.papyrus.infra.psf.runtime.ProjectSetImporter;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

public class ImportPSFHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        final Shell activeShell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        ISelection currentSelection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (currentSelection instanceof IStructuredSelection) {
            IStructuredSelection selection = (IStructuredSelection)currentSelection;
            if (selection.isEmpty()) {
                return null;
            }
            for (Object selectedElement : selection) {
                IFile file = (IFile)Platform.getAdapterManager().getAdapter(selectedElement, IFile.class);
                if (file == null || !"psf".equals(file.getLocation().getFileExtension())) continue;
                final String fileName = file.getLocation().toString();
                Job job = new Job(String.format("Import %s", file.getName())){

                    protected IStatus run(IProgressMonitor monitor) {
                        ImportProjectSetOperation operation = new ImportProjectSetOperation(this.getName(), fileName, activeShell);
                        try {
                            IStatus result = OperationHistoryFactory.getOperationHistory().execute((IUndoableOperation)operation, monitor, null);
                            if (!monitor.isCanceled()) {
                                result.getSeverity();
                            }
                            return result;
                        }
                        catch (ExecutionException ex) {
                            Activator.log.error((Throwable)ex);
                            return new Status(4, "org.eclipse.papyrus.infra.psf", String.format("An error occurred when importing the PSF %s", fileName), (Throwable)ex);
                        }
                    }
                };
                job.setUser(true);
                job.schedule();
                job.setPriority(30);
            }
        }
        return null;
    }

    public static class ImportProjectSetOperation
    extends AbstractOperation {
        private String psfFileName;
        private IProject[] importedProjects;
        private Shell shell;

        public ImportProjectSetOperation(String name, String psfFileName, Shell shell) {
            super(name);
            this.psfFileName = psfFileName;
            this.shell = shell;
        }

        public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            if (this.importedProjects == null || this.importedProjects.length == 0) {
                return Status.OK_STATUS;
            }
            IProject[] iProjectArray = this.importedProjects;
            int n = this.importedProjects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                try {
                    project.delete(false, true, monitor);
                }
                catch (CoreException e) {
                    throw new ExecutionException(e.getMessage(), (Throwable)e);
                }
                ++n2;
            }
            return Status.OK_STATUS;
        }

        public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            return this.execute(monitor, info);
        }

        public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            try {
                if (ProjectSetImporter.isValidProjectSetFile(this.psfFileName)) {
                    ImportResult result = ProjectSetImporter.importProjectSet(this.psfFileName, this.shell, monitor);
                    this.importedProjects = result.getImportedProjects();
                    if (!result.getDiagnostic().isEmpty()) {
                        if (result.getDiagnostic().size() == 1) {
                            return result.getDiagnostic().get(0);
                        }
                        IStatus[] status = result.getDiagnostic().toArray(new IStatus[0]);
                        int code = 0;
                        IStatus[] iStatusArray = status;
                        int n = status.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IStatus currentStatus = iStatusArray[n2];
                            if (currentStatus.getSeverity() > code) {
                                code = currentStatus.getSeverity();
                            }
                            ++n2;
                        }
                        MultiStatus resultStatus = new MultiStatus("org.eclipse.papyrus.infra.psf", code, status, "The following errors occurred during import:", null);
                        return resultStatus;
                    }
                    return Status.OK_STATUS;
                }
                return new Status(4, "org.eclipse.papyrus.infra.psf", "The selected file is not a valid Project Set File");
            }
            catch (InvocationTargetException ex) {
                return new Status(4, "org.eclipse.papyrus.infra.psf", String.format("An error occurred when importing the PSF %s", this.psfFileName), (Throwable)ex);
            }
        }
    }
}

