/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.utils;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.RunnableWithResult;
import org.eclipse.emf.transaction.Transaction;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.impl.InternalTransaction;
import org.eclipse.emf.transaction.impl.InternalTransactionalEditingDomain;
import org.eclipse.papyrus.infra.core.resource.ReadOnlyAxis;
import org.eclipse.papyrus.infra.core.utils.IExecutorPolicy;
import org.eclipse.papyrus.infra.core.utils.TransactionPrecommitExecutor;
import org.eclipse.papyrus.infra.tools.util.IProgressCallable;
import org.eclipse.papyrus.infra.tools.util.IProgressRunnable;

public class TransactionHelper {
    public static final String TRANSACTION_OPTION_READ_ONLY_AXIS = "papyrus.read_only_axis";
    @Deprecated
    public static final String TRANSACTION_OPTION_NO_READ_ONLY_CACHE = "papyrus.no_read_only_cache";
    public static final String TRANSACTION_OPTION_INTERACTIVE = "papyrus.interactive";
    public static final String TRANSACTION_OPTION_MERGE_NESTED_READ = "papyrus.merge_nested_read";

    public static void run(EditingDomain domain, Runnable writeOperation) throws InterruptedException, RollbackException {
        if (domain instanceof TransactionalEditingDomain) {
            TransactionHelper.run((TransactionalEditingDomain)domain, writeOperation);
        } else {
            writeOperation.run();
        }
    }

    public static void run(TransactionalEditingDomain domain, final Runnable writeOperation) throws InterruptedException, RollbackException {
        if (domain instanceof InternalTransactionalEditingDomain) {
            TransactionHelper.run((InternalTransactionalEditingDomain)domain, writeOperation);
        } else {
            domain.getCommandStack().execute((Command)new RecordingCommand(domain){

                protected void doExecute() {
                    writeOperation.run();
                }
            });
        }
    }

    public static void run(InternalTransactionalEditingDomain domain, Runnable writeOperation) throws InterruptedException, RollbackException {
        InternalTransaction transaction = domain.startTransaction(false, Collections.emptyMap());
        try {
            writeOperation.run();
        }
        finally {
            transaction.commit();
        }
    }

    public static boolean isDisposed(TransactionalEditingDomain domain) {
        return domain == null || domain.getCommandStack() == null;
    }

    public static Map<String, Object> mergeReadOnlyAxisOption(Map<String, Object> options, ReadOnlyAxis axis) {
        return TransactionHelper.mergeReadOnlyAxisOption(options, Collections.singleton(axis));
    }

    public static Map<String, Object> mergeReadOnlyAxisOption(Map<String, Object> options, Set<ReadOnlyAxis> axes) {
        options.put(TRANSACTION_OPTION_READ_ONLY_AXIS, axes);
        return options;
    }

    public static Map<String, Object> addReadOnlyAxisOption(Map<String, ?> options, ReadOnlyAxis axis) {
        return TransactionHelper.addReadOnlyAxisOption(options, Collections.singleton(axis));
    }

    public static Map<String, Object> addReadOnlyAxisOption(Map<String, ?> options, Set<ReadOnlyAxis> axes) {
        HashMap result = options == null ? Maps.newHashMap() : Maps.newHashMap(options);
        result.put(TRANSACTION_OPTION_READ_ONLY_AXIS, axes);
        return result;
    }

    public static Map<String, Object> readOnlyAxisOption(ReadOnlyAxis axis) {
        return TransactionHelper.readOnlyAxisOption(Collections.singleton(axis));
    }

    public static Map<String, Object> readOnlyAxisOption(Set<ReadOnlyAxis> axes) {
        return TransactionHelper.addReadOnlyAxisOption(null, axes);
    }

    public static Set<ReadOnlyAxis> getReadOnlyAxisOption(Transaction transaction) {
        Object value = transaction.getOptions().get(TRANSACTION_OPTION_READ_ONLY_AXIS);
        ImmutableSet result = value instanceof Set ? (ImmutableSet)value : (value instanceof Iterable ? Sets.immutableEnumSet((Iterable)((Iterable)value)) : ReadOnlyAxis.anyAxis());
        return result;
    }

    @Deprecated
    public static Map<String, Object> mergeDisableReadOnlyOption(Map<String, Object> options, boolean disableCache) {
        options.put(TRANSACTION_OPTION_NO_READ_ONLY_CACHE, disableCache);
        return options;
    }

    @Deprecated
    public static Map<String, Object> addDisableReadOnlyCacheOption(Map<String, ?> options, boolean disableCache) {
        HashMap result = options == null ? Maps.newHashMap() : Maps.newHashMap(options);
        result.put(TRANSACTION_OPTION_NO_READ_ONLY_CACHE, disableCache);
        return result;
    }

    @Deprecated
    public static Map<String, Object> disableReadOnlyCacheOption(boolean disableCache) {
        return TransactionHelper.addDisableReadOnlyCacheOption(null, disableCache);
    }

    @Deprecated
    public static boolean isReadOnlyCacheDisabled(Transaction transaction) {
        Object value = transaction.getOptions().get(TRANSACTION_OPTION_NO_READ_ONLY_CACHE);
        return value instanceof Boolean ? (Boolean)value : false;
    }

    public static Map<String, Object> mergeMergeReadOnlyOption(Map<String, Object> options, boolean mergeReadOnly) {
        options.put(TRANSACTION_OPTION_MERGE_NESTED_READ, mergeReadOnly);
        return options;
    }

    public static Map<String, Object> addMergeReadOnlyOption(Map<String, ?> options, boolean mergeReadOnly) {
        HashMap result = options == null ? Maps.newHashMap() : Maps.newHashMap(options);
        result.put(TRANSACTION_OPTION_MERGE_NESTED_READ, mergeReadOnly);
        return result;
    }

    public static Map<String, Object> mergeReadOnlyOption(boolean mergeReadOnly) {
        return TransactionHelper.addMergeReadOnlyOption(null, mergeReadOnly);
    }

    public static boolean isMergeReadOnly(Transaction transaction) {
        Object value = transaction.getOptions().get(TRANSACTION_OPTION_MERGE_NESTED_READ);
        return value instanceof Boolean ? (Boolean)value : false;
    }

    public static Map<String, Object> mergeInteractiveOption(Map<String, Object> options, boolean interactive) {
        options.put(TRANSACTION_OPTION_INTERACTIVE, interactive);
        return options;
    }

    public static Map<String, Object> addInteractiveOption(Map<String, ?> options, boolean interactive) {
        HashMap result = options == null ? Maps.newHashMap() : Maps.newHashMap(options);
        result.put(TRANSACTION_OPTION_INTERACTIVE, interactive);
        return result;
    }

    public static Map<String, Object> interactiveOption(boolean interactive) {
        return TransactionHelper.addInteractiveOption(null, interactive);
    }

    public static boolean isInteractive(Transaction transaction) {
        Object value = transaction.getOptions().get(TRANSACTION_OPTION_INTERACTIVE);
        return value instanceof Boolean ? (Boolean)value : true;
    }

    public static boolean isTriggerTransaction(Transaction transaction) {
        Object value = transaction.getOptions().get("is_trigger_transaction");
        return value instanceof Boolean ? (Boolean)value : false;
    }

    public static Executor createTransactionExecutor(TransactionalEditingDomain domain, Executor fallback) {
        return TransactionHelper.createTransactionExecutor(domain, fallback, null, null);
    }

    public static Executor createTransactionExecutor(TransactionalEditingDomain domain, Executor fallback, IExecutorPolicy policy) {
        return TransactionHelper.createTransactionExecutor(domain, fallback, policy, null);
    }

    public static Executor createTransactionExecutor(TransactionalEditingDomain domain, Executor fallback, Map<?, ?> options) {
        return TransactionHelper.createTransactionExecutor(domain, fallback, null, options);
    }

    public static Executor createTransactionExecutor(TransactionalEditingDomain domain, Executor fallback, IExecutorPolicy policy, Map<?, ?> options) {
        if (domain == null || fallback == null) {
            throw new NullPointerException();
        }
        return new TransactionPrecommitExecutor(domain, fallback, policy, options);
    }

    public static IProgressRunnable createPrivilegedRunnable(TransactionalEditingDomain domain, IProgressRunnable runnable) {
        IProgressMonitor[] monitorHolder = new IProgressMonitor[1];
        RunnableWithResult privileged = domain.createPrivilegedRunnable(() -> runnable.run(monitorHolder[0]));
        return new PrivilegedProgressRunnable((Runnable)privileged, m -> {
            IProgressMonitor iProgressMonitor = m;
        });
    }

    public static <V> IProgressCallable<V> createPrivilegedCallable(TransactionalEditingDomain domain, IProgressCallable<V> callable) {
        AtomicReference resultHolder = new AtomicReference();
        Exception[] failHolder = new Exception[1];
        IProgressRunnable[] privileged = new IProgressRunnable[]{TransactionHelper.createPrivilegedRunnable(domain, monitor -> {
            try {
                resultHolder.set(callable.call(monitor));
            }
            catch (Exception e) {
                exceptionArray[0] = e;
            }
        })};
        return monitor -> {
            if (privileged[0] == null) {
                throw new IllegalStateException("Privileged callable was already run");
            }
            try {
                privileged[0].run(monitor);
            }
            finally {
                iProgressRunnableArray[0] = null;
            }
            if (failHolder[0] != null) {
                throw failHolder[0];
            }
            return resultHolder.get();
        };
    }

    private static final class PrivilegedProgressRunnable
    implements IProgressRunnable {
        private final Consumer<? super IProgressMonitor> monitorSlot;
        private Runnable privileged;

        PrivilegedProgressRunnable(Runnable privileged, Consumer<? super IProgressMonitor> monitorSlot) {
            this.monitorSlot = monitorSlot;
            this.privileged = privileged;
        }

        public void run(IProgressMonitor monitor) {
            if (this.privileged == null) {
                throw new IllegalArgumentException("Privileged runnable was already run");
            }
            this.monitorSlot.accept((IProgressMonitor)monitor);
            try {
                this.privileged.run();
            }
            finally {
                this.privileged = null;
            }
        }
    }
}

