/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.evaluation;

import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.PivotPackage;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.internal.library.executor.LazyModelManager;
import org.eclipse.ocl.pivot.internal.manager.PivotMetamodelManager;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.ParserException;

public class PivotModelManager
extends LazyModelManager {
    private static final Logger logger = Logger.getLogger(PivotModelManager.class);
    protected final @NonNull EnvironmentFactoryInternal environmentFactory;
    private boolean generatedErrorMessage = false;

    public PivotModelManager(@NonNull EnvironmentFactoryInternal environmentFactory, EObject context) {
        super(context);
        this.environmentFactory = environmentFactory;
    }

    @Override
    protected boolean isInstance(@NonNull Type requiredType, @NonNull EObject eObject) {
        Type objectType;
        block4: {
            PivotMetamodelManager metamodelManager = this.environmentFactory.getMetamodelManager();
            EClass eClass = eObject.eClass();
            EPackage ePackage = eClass.getEPackage();
            objectType = null;
            if (ePackage == PivotPackage.eINSTANCE) {
                String name = ClassUtil.nonNullEMF(eClass.getName());
                objectType = metamodelManager.getASClass(name);
            } else {
                try {
                    objectType = metamodelManager.getASOf(Type.class, (EObject)eClass);
                }
                catch (ParserException e) {
                    if (this.generatedErrorMessage) break block4;
                    this.generatedErrorMessage = true;
                    logger.error((Object)("Failed to load an '" + eClass.getName() + "'"), (Throwable)e);
                }
            }
        }
        return objectType != null && objectType.conformsTo(this.environmentFactory.getStandardLibrary(), requiredType);
    }
}

