/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.io;

import java.io.IOException;
import java.io.InputStream;

public class LimitedInputStream
extends InputStream {
    private InputStream in;
    private long remaining;
    private long remainingAtMark = 0L;

    public LimitedInputStream(InputStream in, long length) {
        this.in = in;
        this.remaining = length;
    }

    public int read() throws IOException {
        if (--this.remaining < 0L) {
            return -1;
        }
        return this.in.read();
    }

    public int read(byte[] cbuf, int off, int len) throws IOException {
        if (this.remaining <= 0L) {
            return -1;
        }
        if ((long)len > this.remaining) {
            len = (int)this.remaining;
        }
        this.remaining = (len = this.in.read(cbuf, off, len)) > 0 ? (this.remaining -= (long)len) : (this.remaining -= this.remaining);
        return len;
    }

    public long skip(long n) throws IOException {
        if (n > this.remaining) {
            n = this.remaining;
        }
        n = this.in.skip(n);
        this.remaining -= n;
        return n;
    }

    public boolean markSupported() {
        return this.in.markSupported();
    }

    public synchronized void mark(int readlimit) {
        if (this.markSupported()) {
            this.in.mark(readlimit);
            this.remainingAtMark = this.remaining;
        }
    }

    public synchronized void reset() throws IOException {
        this.in.reset();
        this.remaining = this.remainingAtMark;
    }

    public void close() throws IOException {
        this.remaining = 0L;
        this.in.close();
    }
}

