/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.cache;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import org.eclipse.net4j.internal.util.bundle.OM;
import org.eclipse.net4j.util.cache.ICache;
import org.eclipse.net4j.util.cache.ICacheMonitor;
import org.eclipse.net4j.util.cache.ICacheProbe;
import org.eclipse.net4j.util.concurrent.Worker;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Cache<E>
extends Worker
implements ICache {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, Cache.class);
    private ICacheMonitor cacheMonitor;
    private ICacheProbe cacheProbe;
    private ReferenceQueue<E> referenceQueue = new ReferenceQueue();

    @Override
    public ICacheMonitor getCacheMonitor() {
        return this.cacheMonitor;
    }

    public void setCacheMonitor(ICacheMonitor cacheMonitor) {
        this.cacheMonitor = cacheMonitor;
    }

    protected ICacheProbe getCacheProbe() {
        return this.cacheProbe;
    }

    protected ReferenceQueue<E> getReferenceQueue() {
        return this.referenceQueue;
    }

    @Override
    protected void doBeforeActivate() throws Exception {
        super.doBeforeActivate();
        if (this.cacheMonitor == null) {
            throw new IllegalStateException("cacheMonitor == null");
        }
    }

    @Override
    protected void doActivate() throws Exception {
        super.doActivate();
        this.cacheProbe = this.cacheMonitor.registerCache(this);
    }

    @Override
    protected void doDeactivate() throws Exception {
        this.cacheMonitor.deregisterCache(this);
        this.cacheProbe = null;
        super.doDeactivate();
    }

    @Override
    protected void work(Worker.WorkContext context) throws Exception {
        Reference<E> reference = this.referenceQueue.remove(200L);
        if (reference != null) {
            this.unreachableElement((E)reference);
        }
    }

    protected void unreachableElement(Reference<? extends E> reference) {
        E element = reference.get();
        if (element != null) {
            this.unreachableElement(element);
        }
    }

    protected void unreachableElement(E element) {
        if (TRACER.isEnabled()) {
            TRACER.trace("Unreachable: " + element);
        }
    }
}

