/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.viewport.command;

import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;

public class ViewportDragCommand
implements ILayerCommand {
    private int x;
    private int y;
    private boolean configuredForMoveDirection = false;
    private SelectionLayer.MoveDirectionEnum horizontal;
    private SelectionLayer.MoveDirectionEnum vertical;

    public ViewportDragCommand(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public ViewportDragCommand(SelectionLayer.MoveDirectionEnum horizontal, SelectionLayer.MoveDirectionEnum vertical) {
        this.horizontal = horizontal;
        this.vertical = vertical;
        this.configuredForMoveDirection = true;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public SelectionLayer.MoveDirectionEnum getHorizontal() {
        return this.horizontal;
    }

    public SelectionLayer.MoveDirectionEnum getVertical() {
        return this.vertical;
    }

    public boolean isConfiguredForMoveDirection() {
        return this.configuredForMoveDirection;
    }

    @Override
    public boolean convertToTargetLayer(ILayer targetLayer) {
        return true;
    }

    @Override
    public ILayerCommand cloneCommand() {
        if (!this.configuredForMoveDirection) {
            return new ViewportDragCommand(this.x, this.y);
        }
        return new ViewportDragCommand(this.horizontal, this.vertical);
    }
}

