/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.rpm.ui.editor;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.linuxtools.internal.rpm.ui.editor.Activator;
import org.eclipse.linuxtools.internal.rpm.ui.editor.RPMUtils;
import org.eclipse.linuxtools.rpm.ui.editor.parser.Specfile;
import org.eclipse.linuxtools.rpm.ui.editor.parser.SpecfileDefine;
import org.eclipse.linuxtools.rpm.ui.editor.parser.SpecfileParser;
import org.eclipse.swt.graphics.Point;

public class SpecfileHover
implements ITextHover,
ITextHoverExtension {
    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        String currentSelection;
        if (hoverRegion == null || hoverRegion.getLength() == 0) {
            return null;
        }
        Specfile spec = new SpecfileParser().parse(textViewer.getDocument());
        try {
            currentSelection = textViewer.getDocument().get(hoverRegion.getOffset() + 1, hoverRegion.getLength() - 1);
        }
        catch (BadLocationException e) {
            return null;
        }
        SpecfileDefine define = spec.getDefine(currentSelection);
        String value = String.valueOf(currentSelection) + ": ";
        if (define != null) {
            return String.valueOf(value) + define.getStringValue();
        }
        String macroLower = currentSelection.toLowerCase();
        String retrivedValue = RPMUtils.getSourceOrPatchValue(spec, macroLower);
        if (retrivedValue != null) {
            return String.valueOf(value) + retrivedValue;
        }
        retrivedValue = RPMUtils.getMacroValueFromMacroList(currentSelection);
        if (retrivedValue != null) {
            return String.valueOf(value) + retrivedValue;
        }
        retrivedValue = Activator.getDefault().getRpmPackageList().getValue(currentSelection.replaceFirst(":", ""));
        if (retrivedValue != null) {
            return retrivedValue;
        }
        return null;
    }

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        if (textViewer != null) {
            Point selectedRange = textViewer.getSelectedRange();
            if (selectedRange.x >= 0 && selectedRange.y > 0 && offset >= selectedRange.x && offset <= selectedRange.x + selectedRange.y) {
                return new Region(selectedRange.x, selectedRange.y);
            }
            IRegion region = SpecfileHover.findWord(textViewer.getDocument(), offset);
            if (region.equals(new Region(offset, 0))) {
                region = SpecfileHover.findPackages(textViewer.getDocument(), offset);
            }
            return region;
        }
        return null;
    }

    public IInformationControlCreator getHoverControlCreator() {
        return parent -> new DefaultInformationControl(parent, false);
    }

    public static IRegion findWord(IDocument document, int offset) {
        int start = -1;
        int end = -1;
        boolean beginsWithBrace = false;
        try {
            char c;
            int pos = offset;
            while (pos >= 0) {
                c = document.getChar(pos);
                if (c == '%') {
                    if (document.getChar(pos + 1) != '{') break;
                    beginsWithBrace = true;
                    break;
                }
                if (c == '\n' || c == '}') {
                    return new Region(offset, 0);
                }
                --pos;
            }
            if (!beginsWithBrace) {
                --pos;
            }
            start = pos;
            pos = offset;
            int length = document.getLength();
            while (pos < length) {
                c = document.getChar(pos);
                if (beginsWithBrace && c == '}' || c == '\n' || c == '%' || c == '(' || !beginsWithBrace && c == ' ') break;
                ++pos;
            }
            end = pos;
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        if (start >= -1 && end > -1) {
            if (start == offset) {
                return new Region(start, end - start);
            }
            return new Region(start + 1, end - start - 1);
        }
        return null;
    }

    public static IRegion findPackages(IDocument document, int offset) {
        int start = -1;
        int end = -1;
        boolean beginsWithSpace = false;
        try {
            char c;
            int pos = offset;
            while (pos >= 0) {
                c = document.getChar(pos);
                if (c == ' ' || c == '\t' || c == ':') {
                    if (Character.isLetter(document.getChar(pos + 1))) {
                        beginsWithSpace = true;
                        break;
                    }
                    if (c == '\n') {
                        return new Region(offset, 0);
                    }
                }
                --pos;
            }
            start = --pos;
            pos = offset;
            int length = document.getLength();
            while (pos < length) {
                c = document.getChar(pos);
                if (beginsWithSpace && !Character.isLetter(c) && !Character.isDigit(c) && c != '-') break;
                if (c == '\n') {
                    return new Region(offset, 0);
                }
                ++pos;
            }
            end = pos;
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        if (start > -1 && end > -1) {
            return new Region(start, end - start);
        }
        return null;
    }
}

