/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.views;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.linuxtools.docker.core.IDockerContainerConfig;
import org.eclipse.linuxtools.docker.core.IDockerImageInfo;
import org.eclipse.linuxtools.internal.docker.ui.views.LabelProviderUtils;

public class ImageInspectContentProvider
implements ITreeContentProvider {
    private static final Object[] EMPTY = new Object[0];

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof IDockerImageInfo) {
            IDockerImageInfo info = (IDockerImageInfo)inputElement;
            return new Object[]{new Object[]{"Id", info.id()}, new Object[]{"Parent", info.parent()}, new Object[]{"Comment", info.comment()}, new Object[]{"Created", LabelProviderUtils.toCreatedDate(info.created())}, new Object[]{"Container", info.container()}, new Object[]{"ContainerConfig", info.containerConfig()}, new Object[]{"DockerVersion", info.dockerVersion()}, new Object[]{"Author", info.author()}, new Object[]{"Config", info.config()}, new Object[]{"Architecture", info.architecture()}, new Object[]{"Os", info.os()}, new Object[]{"Size", LabelProviderUtils.toString(info.size())}};
        }
        return EMPTY;
    }

    public Object[] getChildren(Object parentElement) {
        Object propertyValue = ((Object[])parentElement)[1];
        if (propertyValue instanceof IDockerContainerConfig) {
            IDockerContainerConfig config = (IDockerContainerConfig)propertyValue;
            return new Object[]{new Object[]{"Hostname", config.hostname()}, new Object[]{"Domainname", config.domainname()}, new Object[]{"User", config.user()}, new Object[]{"Memory", LabelProviderUtils.toString(config.memory())}, new Object[]{"MemorySwap", LabelProviderUtils.toString(config.memorySwap())}, new Object[]{"CpuShares", LabelProviderUtils.toString(config.cpuShares())}, new Object[]{"Cpuset", config.cpuset()}, new Object[]{"AttachStdin", config.attachStdin()}, new Object[]{"AttachStdout", config.attachStdout()}, new Object[]{"AttachStderr", config.attachStderr()}, new Object[]{"PortSpecs", LabelProviderUtils.reduce(config.portSpecs())}, new Object[]{"ExposedPorts", config.exposedPorts()}, new Object[]{"Tty", config.tty()}, new Object[]{"OpenStdin", config.openStdin()}, new Object[]{"StdinOnce", config.stdinOnce()}, new Object[]{"Env", LabelProviderUtils.reduce(config.env())}, new Object[]{"Cmd", LabelProviderUtils.reduce(config.cmd())}, new Object[]{"Image", config.image()}, new Object[]{"Volumes", LabelProviderUtils.reduce(config.volumes())}, new Object[]{"WorkingDir", config.workingDir()}, new Object[]{"EntryPoint", LabelProviderUtils.reduce(config.entrypoint())}, new Object[]{"NetworkDisabled", config.networkDisabled()}, new Object[]{"OnBuild", LabelProviderUtils.reduce(config.onBuild())}};
        }
        if (propertyValue instanceof List) {
            List propertyValues = (List)propertyValue;
            Object[] result = new Object[propertyValues.size()];
            int i = 0;
            while (i < propertyValues.size()) {
                result[i] = new Object[]{"", LabelProviderUtils.toString(propertyValues.get(i))};
                ++i;
            }
            return result;
        }
        if (propertyValue instanceof Set) {
            Set propertyValues = (Set)propertyValue;
            Object[] result = new Object[propertyValues.size()];
            Iterator iterator = propertyValues.iterator();
            int i = 0;
            while (i < propertyValues.size()) {
                result[i] = new Object[]{"", LabelProviderUtils.toString(iterator.next())};
                ++i;
            }
            return result;
        }
        if (propertyValue instanceof Map) {
            Map propertyValues = (Map)propertyValue;
            Object[] result = new Object[propertyValues.size()];
            int i = 0;
            for (Map.Entry entry : propertyValues.entrySet()) {
                result[i] = new Object[]{entry.getKey(), entry.getValue()};
                ++i;
            }
            return result;
        }
        return EMPTY;
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof Object[]) {
            Object value = ((Object[])element)[1];
            return value instanceof List || value instanceof Map || value instanceof IDockerContainerConfig;
        }
        return false;
    }
}

