/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ldt.debug.ui.internal.actions;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.sourcelookup.ISourceLookupResult;
import org.eclipse.dltk.debug.core.model.IScriptValue;
import org.eclipse.dltk.debug.core.model.IScriptVariable;
import org.eclipse.dltk.debug.ui.DLTKDebugUIPlugin;
import org.eclipse.dltk.debug.ui.ScriptDebugModelPresentation;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ldt.debug.core.internal.LuaFunctionType;
import org.eclipse.ldt.debug.ui.internal.Activator;
import org.eclipse.ldt.debug.ui.internal.actions.Messages;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.texteditor.ITextEditor;

public class GotoFunctionDefinitionAction
implements IObjectActionDelegate {
    private IScriptValue value;
    private IWorkbenchPart part;

    public void run(IAction action) {
        LuaFunctionType.FunctionData data = ((LuaFunctionType)this.value.getType()).getData(this.value);
        ISourceLocator locator = this.value.getDebugTarget().getLaunch().getSourceLocator();
        ISourceLookupResult result = DebugUITools.lookupSource((Object)data.getPath(), (ISourceLocator)locator);
        if (result.getSourceElement() == null) {
            String title = Messages.GotoFunctionDefinitionAction_name;
            String message = Messages.GotoFunctionDefinitionAction_open_error_msg;
            String cause = Messages.GotoFunctionDefinitionAction_lookup_failed_msg;
            ErrorDialog.openError((Shell)DLTKDebugUIPlugin.getActiveWorkbenchShell(), (String)title, (String)message, (IStatus)new Status(4, "org.eclipse.ldt.debug.ui", cause));
            return;
        }
        try {
            ScriptDebugModelPresentation presentation = DLTKDebugUIPlugin.getDefault().getModelPresentation(this.value.getModelIdentifier());
            IEditorInput input = presentation.getEditorInput(result.getSourceElement());
            String editorId = presentation.getEditorId(input, result.getSourceElement());
            ITextEditor editor = (ITextEditor)this.part.getSite().getPage().openEditor(input, editorId);
            IDocument doc = editor.getDocumentProvider().getDocument((Object)input);
            editor.selectAndReveal(doc.getLineOffset(data.getLine() - 1), 0);
        }
        catch (PartInitException e) {
            Activator.logError("Failed to open editor", e);
        }
        catch (BadLocationException e) {
            Activator.logError("Failed to set definition line", e);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        boolean enabled = false;
        try {
            IScriptVariable var;
            if (selection instanceof IStructuredSelection && (var = (IScriptVariable)((IStructuredSelection)selection).getFirstElement()) != null) {
                this.value = (IScriptValue)var.getValue();
                if (this.value.getType() instanceof LuaFunctionType) {
                    enabled = true;
                }
            }
        }
        catch (DebugException debugException) {
            enabled = false;
        }
        action.setEnabled(enabled);
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.part = targetPart;
    }
}

