/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.propertytester;

import org.apache.commons.lang.ArrayUtils;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.jubula.client.core.i18n.Messages;
import org.eclipse.osgi.util.NLS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBooleanPropertyTester
extends PropertyTester {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractBooleanPropertyTester.class);

    public final boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (receiver != null && this.getType().isAssignableFrom(receiver.getClass())) {
            if (ArrayUtils.indexOf((Object[])this.getProperties(), (Object)property) >= 0) {
                boolean expectedBoolean;
                boolean bl = expectedBoolean = expectedValue instanceof Boolean ? (Boolean)expectedValue : true;
                return this.testImpl(receiver, property, args) == expectedBoolean;
            }
            LOG.warn(NLS.bind((String)Messages.PropertyTesterPropertyNotSupported, (Object)property));
            return false;
        }
        String receiverClass = receiver != null ? receiver.getClass().getName() : "null";
        LOG.warn(NLS.bind((String)Messages.PropertyTesterTypeNotSupported, (Object)receiverClass));
        return false;
    }

    public abstract boolean testImpl(Object var1, String var2, Object[] var3);

    public abstract Class<? extends Object> getType();

    public abstract String[] getProperties();
}

