/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.internal.resource;

import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.core.resources.IResource;
import org.eclipse.jst.jsf.common.internal.managedobject.AbstractManagedObject;
import org.eclipse.jst.jsf.common.internal.resource.EventResult;
import org.eclipse.jst.jsf.common.internal.resource.IResourceLifecycleListener;
import org.eclipse.jst.jsf.common.internal.resource.ResourceLifecycleEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ResourceTracker<RESTYPE extends IResource>
extends AbstractManagedObject
implements IResourceLifecycleListener {
    private final RESTYPE _resource;
    private final AtomicLong _lastModifiedStamp = new AtomicLong();

    public ResourceTracker(RESTYPE resource) {
        this._resource = resource;
        this._lastModifiedStamp.set(resource.getModificationStamp());
    }

    public final RESTYPE getResource() {
        return this._resource;
    }

    public final long getLastModifiedStamp() {
        return this._lastModifiedStamp.get();
    }

    @Override
    public EventResult acceptEvent(ResourceLifecycleEvent event) {
        if (!this.isInteresting(event)) {
            return EventResult.getDefaultEventResult();
        }
        ResourceLifecycleEvent.EventType eventType = event.getEventType();
        ResourceLifecycleEvent.ReasonType reasonType = event.getReasonType();
        switch (eventType) {
            case RESOURCE_ADDED: {
                this.fireResourceAdded(event.getAffectedResource(), reasonType);
                break;
            }
            case RESOURCE_CHANGED: {
                this.fireResourceChanged(event.getAffectedResource(), reasonType);
                break;
            }
            case RESOURCE_INACCESSIBLE: {
                this.fireResourceInAccessible(event.getAffectedResource(), reasonType);
            }
        }
        return EventResult.getDefaultEventResult();
    }

    protected boolean isInteresting(ResourceLifecycleEvent event) {
        return this._resource.equals(event.getAffectedResource());
    }

    protected abstract void fireResourceInAccessible(IResource var1, ResourceLifecycleEvent.ReasonType var2);

    protected abstract void fireResourceChanged(IResource var1, ResourceLifecycleEvent.ReasonType var2);

    protected abstract void fireResourceAdded(IResource var1, ResourceLifecycleEvent.ReasonType var2);

    @Override
    public void dispose() {
        super.dispose();
    }

    @Override
    public void checkpoint() {
    }

    @Override
    public void destroy() {
    }
}

