/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.pgm;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.RemoteListCommand;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.pgm.Command;
import org.eclipse.jgit.pgm.Fetch;
import org.eclipse.jgit.pgm.TextBuiltin;
import org.eclipse.jgit.pgm.internal.CLIText;
import org.eclipse.jgit.pgm.opt.CmdLineParser;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.util.io.ThrowingPrintWriter;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;

@Command(common=false, usage="usage_Remote")
class Remote
extends TextBuiltin {
    @Option(name="--verbose", aliases={"-v"}, usage="usage_beVerbose")
    private boolean verbose = false;
    @Option(name="--prune", aliases={"-p"}, usage="usage_pruneStaleTrackingRefs")
    private boolean prune;
    @Option(name="--push", usage="usage_pushUrls")
    private boolean push;
    @Argument(index=0, metaVar="metaVar_command")
    private String command;
    @Argument(index=1, metaVar="metaVar_remoteName")
    private String name;
    @Argument(index=2, metaVar="metaVar_uriish")
    private String uri;

    Remote() {
    }

    @Override
    protected void run() throws Exception {
        block20: {
            try (Git git = new Git(this.db);){
                RemoteListCommand cmd;
                if (this.command == null) {
                    cmd = git.remoteList();
                    List remotes = cmd.call();
                    this.print(remotes);
                    break block20;
                }
                if ("add".equals(this.command)) {
                    cmd = git.remoteAdd();
                    cmd.setName(this.name);
                    cmd.setUri(new URIish(this.uri));
                    cmd.call();
                    break block20;
                }
                if ("remove".equals(this.command) || "rm".equals(this.command)) {
                    cmd = git.remoteRemove();
                    cmd.setName(this.name);
                    cmd.call();
                    break block20;
                }
                if ("set-url".equals(this.command)) {
                    cmd = git.remoteSetUrl();
                    cmd.setName(this.name);
                    cmd.setUri(new URIish(this.uri));
                    cmd.setPush(this.push);
                    cmd.call();
                    break block20;
                }
                if ("update".equals(this.command)) {
                    Fetch fetch = new Fetch();
                    fetch.init(this.db, this.gitdir);
                    StringWriter osw = new StringWriter();
                    fetch.outw = new ThrowingPrintWriter((Writer)osw);
                    StringWriter esw = new StringWriter();
                    fetch.errw = new ThrowingPrintWriter((Writer)esw);
                    ArrayList<String> fetchArgs = new ArrayList<String>();
                    if (this.verbose) {
                        fetchArgs.add("--verbose");
                    }
                    if (this.prune) {
                        fetchArgs.add("--prune");
                    }
                    if (this.name != null) {
                        fetchArgs.add(this.name);
                    }
                    fetch.execute(fetchArgs.toArray(new String[fetchArgs.size()]));
                    fetch.outw.flush();
                    fetch.errw.flush();
                    this.outw.println(osw.toString());
                    this.errw.println(esw.toString());
                    break block20;
                }
                throw new JGitInternalException(MessageFormat.format(CLIText.get().unknownSubcommand, this.command));
            }
        }
    }

    @Override
    public void printUsage(String message, CmdLineParser clp) throws IOException {
        this.errw.println(message);
        this.errw.println("jgit remote [--verbose (-v)] [--help (-h)]");
        this.errw.println("jgit remote add name uri-ish [--help (-h)]");
        this.errw.println("jgit remote remove name [--help (-h)]");
        this.errw.println("jgit remote rm name [--help (-h)]");
        this.errw.println("jgit remote [--verbose (-v)] update [name] [--prune (-p)] [--help (-h)]");
        this.errw.println("jgit remote set-url name uri-ish [--push] [--help (-h)]");
        this.errw.println();
        clp.printUsage((Writer)this.errw, this.getResourceBundle());
        this.errw.println();
        this.errw.flush();
    }

    private void print(List<RemoteConfig> remotes) throws IOException {
        for (RemoteConfig remote : remotes) {
            String remoteName = remote.getName();
            if (this.verbose) {
                List fetchURIs = remote.getURIs();
                List pushURIs = remote.getPushURIs();
                String fetchURI = "";
                if (!fetchURIs.isEmpty()) {
                    fetchURI = ((URIish)fetchURIs.get(0)).toString();
                } else if (!pushURIs.isEmpty()) {
                    fetchURI = ((URIish)pushURIs.get(0)).toString();
                }
                String pushURI = "";
                if (!pushURIs.isEmpty()) {
                    pushURI = ((URIish)pushURIs.get(0)).toString();
                } else if (!fetchURIs.isEmpty()) {
                    pushURI = ((URIish)fetchURIs.get(0)).toString();
                }
                this.outw.println(String.format("%s\t%s (fetch)", remoteName, fetchURI));
                this.outw.println(String.format("%s\t%s (push)", remoteName, pushURI));
                continue;
            }
            this.outw.println(remoteName);
        }
    }
}

