/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.efacet.ui.internal.wizards.pages;

import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.facet.efacet.ui.internal.Messages;
import org.eclipse.emf.facet.efacet.ui.internal.composites.SelectETypeComposite;
import org.eclipse.emf.facet.efacet.ui.internal.widget.EClassifierSelectionControl;
import org.eclipse.emf.facet.efacet.ui.internal.wizards.pages.SelectEPackageWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.dialogs.FilteredList;

public class SelectEClassifierWizardPage
extends WizardPage {
    private EClassifierSelectionControl eClassSelectionControl;
    private final SelectETypeComposite.ETypeSelectionOptions eTypeSelectionOption;
    private String metamodelNsUri;

    public SelectEClassifierWizardPage(SelectETypeComposite.ETypeSelectionOptions eTypeSelectionOption, EPackage ePackage) {
        super("Whatever");
        if (eTypeSelectionOption == SelectETypeComposite.ETypeSelectionOptions.ECLASS) {
            this.setTitle(Messages.Select_EClass);
        } else if (eTypeSelectionOption == SelectETypeComposite.ETypeSelectionOptions.EDATATYPE) {
            this.setTitle(Messages.Select_EDataType);
        } else {
            this.setTitle(Messages.Select_EClassifier);
        }
        if (ePackage != null) {
            this.metamodelNsUri = ePackage.getNsURI();
        }
        this.eTypeSelectionOption = eTypeSelectionOption;
    }

    public boolean isPageComplete() {
        return this.eClassSelectionControl.getSelectedEClassifier() != null;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (this.getPreviousPage() instanceof SelectEPackageWizardPage) {
            SelectEPackageWizardPage selectEPackageWizardPage = (SelectEPackageWizardPage)this.getPreviousPage();
            this.metamodelNsUri = selectEPackageWizardPage.getFirstSelectedEPackage().getNsURI();
            if (this.metamodelNsUri != null) {
                this.setDescription(selectEPackageWizardPage.getFirstSelectedEPackage().getNsURI());
            }
        }
        this.eClassSelectionControl.updateList(this.metamodelNsUri);
    }

    public void createControl(Composite parent) {
        this.eClassSelectionControl = new EClassifierSelectionControl(parent, this.metamodelNsUri, this.eTypeSelectionOption);
        FilteredList filteredList = this.eClassSelectionControl.getFilteredList();
        filteredList.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (e.item != null) {
                    SelectEClassifierWizardPage.this.updateButton();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                if (SelectEClassifierWizardPage.this.getWizard().canFinish()) {
                    SelectEClassifierWizardPage.this.getWizard().performFinish();
                }
                if (SelectEClassifierWizardPage.this.getNextPage() != null) {
                    SelectEClassifierWizardPage.this.goToNextPage();
                }
            }
        });
        this.eClassSelectionControl.getFilterText().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SelectEClassifierWizardPage.this.updateButton();
            }
        });
        filteredList.setSelection(new int[0]);
        this.setPageComplete(false);
        this.setControl((Control)this.eClassSelectionControl);
    }

    protected void goToNextPage() {
        this.getContainer().showPage(this.getNextPage());
    }

    protected void updateButton() {
        if (this.getContainer() != null && this.getContainer().getCurrentPage() != null) {
            this.getContainer().updateButtons();
        }
    }

    public EClassifier getSelectedEclassifier() {
        return this.eClassSelectionControl.getSelectedEClassifier();
    }
}

