/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.mylyn;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IElementChangedListener;
import org.eclipse.dltk.internal.mylyn.ActiveFoldingEditorTracker;
import org.eclipse.dltk.internal.mylyn.DLTKEditingMonitor;
import org.eclipse.dltk.internal.mylyn.DLTKUiUtil;
import org.eclipse.dltk.internal.mylyn.InterestUpdateDeltaListener;
import org.eclipse.dltk.internal.mylyn.LandmarkMarkerManager;
import org.eclipse.dltk.internal.mylyn.TypeHistoryManager;
import org.eclipse.dltk.internal.ui.editor.ScriptEditor;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.context.core.AbstractContextListener;
import org.eclipse.mylyn.context.core.ContextCore;
import org.eclipse.mylyn.context.ui.IContextUiStartup;
import org.eclipse.mylyn.monitor.ui.MonitorUi;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.progress.UIJob;
import org.osgi.framework.BundleContext;

public class DLTKUiBridgePlugin
extends AbstractUIPlugin {
    public static final String ID_PLUGIN = "org.eclipse.dltk.mylyn";
    public static final String AUTO_FOLDING_ENABLED = "org.eclipse.mylyn.context.ui.editor.folding.enabled";
    private static DLTKUiBridgePlugin INSTANCE;
    private ActiveFoldingEditorTracker editorTracker;
    private TypeHistoryManager typeHistoryManager;
    private LandmarkMarkerManager landmarkMarkerManager;
    private DLTKEditingMonitor dltkEditingMonitor;
    private InterestUpdateDeltaListener dltkElementChangeListener;
    private static final String MYLYN_PREVIOUS_RUN = "org.eclipse.mylyn.ui.first.run.0_4_9";
    private static final String MYLYN_RUN_COUNT = "org.eclipse.dltk.mylyn.run.count.1_1_0";
    private static final String NUM_COMPUTERS_PREF_KEY = "content_assist_number_of_computers";

    public void start(BundleContext context) throws Exception {
        super.start(context);
        INSTANCE = this;
        IPreferenceStore dltkPrefs = DLTKUIPlugin.getDefault().getPreferenceStore();
        int count = this.getPreferenceStore().getInt(MYLYN_RUN_COUNT);
        if (count < 1) {
            int lastNumberOfComputers;
            this.getPreferenceStore().setValue(MYLYN_RUN_COUNT, count + 1);
            if (count == 0 && this.getPreferenceStore().contains(MYLYN_PREVIOUS_RUN) && dltkPrefs.contains(NUM_COMPUTERS_PREF_KEY) && (lastNumberOfComputers = dltkPrefs.getInt(NUM_COMPUTERS_PREF_KEY)) > 0) {
                dltkPrefs.putValue(NUM_COMPUTERS_PREF_KEY, Integer.toString(lastNumberOfComputers - 2));
            }
            new UIJob("Initialize Content Assist"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    IPreferenceStore store = DLTKUIPlugin.getDefault().getPreferenceStore();
                    DLTKUiUtil.installContentAssist(store, false);
                    return Status.OK_STATUS;
                }
            }.schedule();
        }
        String defaultValue = dltkPrefs.getDefaultString("content_assist_disabled_computers");
        dltkPrefs.setDefault("content_assist_disabled_computers", String.valueOf(defaultValue) + "org.eclipse.dltk.mylyn.dltkAllProposalCategory" + "\u0000");
    }

    private void lazyStart() {
        this.landmarkMarkerManager = new LandmarkMarkerManager();
        ContextCore.getContextManager().addListener((AbstractContextListener)this.landmarkMarkerManager);
        this.dltkEditingMonitor = new DLTKEditingMonitor();
        MonitorUi.getSelectionMonitors().add(this.dltkEditingMonitor);
        this.installEditorTracker(PlatformUI.getWorkbench());
        this.dltkElementChangeListener = new InterestUpdateDeltaListener();
        DLTKCore.addElementChangedListener((IElementChangedListener)this.dltkElementChangeListener);
        try {
            this.typeHistoryManager = new TypeHistoryManager();
            ContextCore.getContextManager().addListener((AbstractContextListener)this.typeHistoryManager);
        }
        catch (Throwable t) {
            StatusHandler.log((IStatus)new Status(4, ID_PLUGIN, "Could not install type history manager: incompatible Eclipse version", t));
        }
    }

    private void lazyStop() {
        if (this.typeHistoryManager != null) {
            ContextCore.getContextManager().removeListener((AbstractContextListener)this.typeHistoryManager);
        }
        if (this.landmarkMarkerManager != null) {
            ContextCore.getContextManager().removeListener((AbstractContextListener)this.landmarkMarkerManager);
        }
        if (this.dltkEditingMonitor != null) {
            MonitorUi.getSelectionMonitors().remove((Object)this.dltkEditingMonitor);
        }
        if (this.dltkElementChangeListener != null) {
            DLTKCore.removeElementChangedListener((IElementChangedListener)this.dltkElementChangeListener);
        }
    }

    public void stop(BundleContext context) throws Exception {
        this.lazyStop();
        super.stop(context);
        INSTANCE = null;
    }

    private void installEditorTracker(IWorkbench workbench) {
        this.editorTracker = new ActiveFoldingEditorTracker();
        this.editorTracker.install(workbench);
        IWorkbenchWindow[] iWorkbenchWindowArray = PlatformUI.getWorkbench().getWorkbenchWindows();
        int n = iWorkbenchWindowArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow w = iWorkbenchWindowArray[n2];
            IWorkbenchPage page = w.getActivePage();
            if (page != null) {
                IEditorReference[] references;
                IEditorReference[] iEditorReferenceArray = references = page.getEditorReferences();
                int n3 = references.length;
                int n4 = 0;
                while (n4 < n3) {
                    IEditorReference reference = iEditorReferenceArray[n4];
                    IEditorPart part = reference.getEditor(false);
                    if (part instanceof ScriptEditor) {
                        ScriptEditor editor = (ScriptEditor)part;
                        this.editorTracker.registerEditor(editor);
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }

    public static DLTKUiBridgePlugin getDefault() {
        return INSTANCE;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)ID_PLUGIN, (String)path);
    }

    public ActiveFoldingEditorTracker getEditorTracker() {
        return this.editorTracker;
    }

    public static class DLTKUiBridgeStartup
    implements IContextUiStartup {
        public void lazyStartup() {
            DLTKUiBridgePlugin.getDefault().lazyStart();
        }
    }
}

