/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.autotools.core;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.lang.reflect.Method;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.core.IErrorParser;
import org.eclipse.cdt.core.ProblemMarkerInfo;
import org.eclipse.cdt.internal.autotools.core.AutotoolsProblemMarkerInfo;
import org.eclipse.cdt.internal.autotools.core.ErrorParserManager;
import org.eclipse.cdt.internal.autotools.core.MarkerGenerator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class ErrorParser
extends MarkerGenerator
implements IErrorParser {
    public static final String ID = "org.eclipse.cdt.autotools.core.errorParser";
    private Pattern pkgconfigError = Pattern.compile(".*?(configure:\\s+error:\\s+Package requirements\\s+\\((.*?)\\)\\s+were not met).*");
    private Pattern genconfigError = Pattern.compile(".*?configure:\\s+error:\\s+(.*)");
    private Pattern checkingFail = Pattern.compile("checking for (.*)\\.\\.\\. no");
    private Pattern changingConfigDirectory = Pattern.compile("Configuring in (.*)");
    private IPath buildDir;
    private IPath sourcePath;
    private IProject project;

    public ErrorParser() {
    }

    public ErrorParser(IPath sourcePath, IPath buildPath) {
        this.buildDir = buildPath;
        this.sourcePath = sourcePath;
    }

    public boolean processLine(String line, org.eclipse.cdt.core.ErrorParserManager eoParser) {
        AutotoolsProblemMarkerInfo marker;
        if (this.project == null) {
            this.project = eoParser.getProject();
        }
        if (this.buildDir == null) {
            this.buildDir = new Path(eoParser.getWorkingDirectoryURI().getPath());
        }
        if (this.sourcePath == null) {
            this.sourcePath = eoParser.getProject().getLocation();
        }
        if ((marker = this.processLine(line)) != null) {
            Method method = eoParser.getClass().getMethod("addProblemMarker", ProblemMarkerInfo.class);
            try {
                method.invoke((Object)eoParser, marker);
                return true;
            }
            catch (Exception e) {
                try {
                    throw new RuntimeException(e);
                }
                catch (NoSuchMethodException | SecurityException e2) {
                    return false;
                }
            }
        }
        return false;
    }

    public boolean processLine(String line, ErrorParserManager eoParser) {
        AutotoolsProblemMarkerInfo marker;
        if (this.project == null) {
            this.project = eoParser.getProject();
        }
        if ((marker = this.processLine(line)) != null) {
            eoParser.addProblemMarker(marker);
            return true;
        }
        return false;
    }

    public AutotoolsProblemMarkerInfo processLine(String line) {
        AutotoolsProblemMarkerInfo.Type type;
        Matcher m = this.changingConfigDirectory.matcher(line);
        if (m.matches()) {
            this.buildDir = this.buildDir.append(m.group(1));
            this.sourcePath = this.sourcePath.append(m.group(1));
            return null;
        }
        m = this.pkgconfigError.matcher(line);
        if (m.matches()) {
            return new AutotoolsProblemMarkerInfo((IResource)this.getProject(), -1, m.group(1), 3, null, null, m.group(2), AutotoolsProblemMarkerInfo.Type.PACKAGE);
        }
        m = this.genconfigError.matcher(line);
        if (m.matches()) {
            return new AutotoolsProblemMarkerInfo((IResource)this.getProject(), -1, m.group(1), 3, null, AutotoolsProblemMarkerInfo.Type.GENERIC);
        }
        m = this.checkingFail.matcher(line);
        if (m.matches() && (type = this.getCheckType(m.group(1))) != null) {
            return new AutotoolsProblemMarkerInfo((IResource)this.getProject(), "Missing " + (Object)((Object)type) + " " + m.group(1), 0, m.group(1), type);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private AutotoolsProblemMarkerInfo.Type getCheckType(String name) {
        int lineNumber = this.getErrorConfigLineNumber(name);
        File file = new File(this.sourcePath + "/configure");
        if (!file.exists()) {
            return null;
        }
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try {
                LineNumberReader reader = new LineNumberReader(new FileReader(file));
                try {
                    Pattern errorPattern = Pattern.compile(".*ac_cv_([a-z]*)_.*");
                    String line = reader.readLine();
                    int i = 0;
                    while (i < lineNumber + 10) {
                        if (line == null) {
                            return null;
                        }
                        if (i < lineNumber) {
                            line = reader.readLine();
                        } else {
                            Matcher m = errorPattern.matcher(line);
                            if (m.matches()) {
                                String typeString = m.group(1);
                                if (typeString.equals("prog")) {
                                    return AutotoolsProblemMarkerInfo.Type.PROG;
                                }
                                if (typeString.equals("header")) {
                                    return AutotoolsProblemMarkerInfo.Type.HEADER;
                                }
                                if (typeString.equals("file")) {
                                    return AutotoolsProblemMarkerInfo.Type.FILE;
                                }
                                if (!typeString.equals("lib")) return null;
                                return AutotoolsProblemMarkerInfo.Type.LIB;
                            }
                            line = reader.readLine();
                        }
                        ++i;
                    }
                    return null;
                }
                catch (Throwable throwable2) {
                    throw throwable2;
                }
                finally {
                    if (reader == null) return AutotoolsProblemMarkerInfo.Type.PROG;
                    reader.close();
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                }
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
                throw throwable;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int getErrorConfigLineNumber(String name) {
        File file = new File(this.buildDir + "/config.log");
        if (!file.exists()) {
            return -1;
        }
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try {
                int n;
                LineNumberReader reader = new LineNumberReader(new FileReader(file));
                try {
                    String line;
                    Matcher m;
                    Pattern errorPattern = Pattern.compile("configure:(\\d+): checking for " + name);
                    do {
                        if ((line = reader.readLine()) != null) continue;
                        return -1;
                    } while (!(m = errorPattern.matcher(line)).matches());
                    n = Integer.parseInt(m.group(1));
                    return n;
                }
                finally {
                    if (reader == null) return n;
                    reader.close();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (IOException e) {
            return -1;
        }
    }

    @Override
    public IProject getProject() {
        return this.project;
    }
}

