/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.jdbc.dbprofile.ui.internal.sqb;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.Properties;
import org.eclipse.birt.report.data.oda.jdbc.dbprofile.impl.Connection;
import org.eclipse.birt.report.data.oda.jdbc.dbprofile.ui.internal.sqb.CustomSQLBuilderDialog;
import org.eclipse.birt.report.data.oda.jdbc.dbprofile.ui.internal.sqb.SQLBuilderDesignState;
import org.eclipse.birt.report.data.oda.jdbc.dbprofile.ui.internal.sqb.SQLQueryUtility;
import org.eclipse.birt.report.data.oda.jdbc.dbprofile.ui.nls.Messages;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.internal.ui.dialogs.ExceptionHandler;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.design.DataSetDesign;
import org.eclipse.datatools.connectivity.oda.design.DataSourceDesign;
import org.eclipse.datatools.connectivity.oda.design.DesignFactory;
import org.eclipse.datatools.connectivity.oda.design.DesignerState;
import org.eclipse.datatools.connectivity.oda.design.ResourceIdentifiers;
import org.eclipse.datatools.connectivity.oda.design.ResultSetDefinition;
import org.eclipse.datatools.connectivity.oda.design.SortSpecification;
import org.eclipse.datatools.connectivity.oda.design.ui.designsession.DesignSessionUtil;
import org.eclipse.datatools.connectivity.oda.design.ui.wizards.DataSetWizardPage;
import org.eclipse.datatools.connectivity.oda.design.util.DesignUtil;
import org.eclipse.datatools.connectivity.oda.profile.OdaProfileExplorer;
import org.eclipse.datatools.modelbase.sql.query.QueryStatement;
import org.eclipse.datatools.sqltools.editor.core.connection.ISQLEditorConnectionInfo;
import org.eclipse.datatools.sqltools.sqlbuilder.input.ISQLBuilderEditorInput;
import org.eclipse.datatools.sqltools.sqlbuilder.input.ISQLBuilderEditorInputUsageOptions;
import org.eclipse.datatools.sqltools.sqlbuilder.input.SQLBuilderEditorInputUsageOptions;
import org.eclipse.datatools.sqltools.sqlbuilder.input.SQLBuilderStorageEditorInput;
import org.eclipse.datatools.sqltools.sqlbuilder.model.ControlStateInfo;
import org.eclipse.datatools.sqltools.sqlbuilder.model.IControlStateInfo;
import org.eclipse.datatools.sqltools.sqlbuilder.model.IWindowStateInfo;
import org.eclipse.datatools.sqltools.sqlbuilder.model.SQLBuilderConnectionInfo;
import org.eclipse.datatools.sqltools.sqlbuilder.model.WindowStateInfo;
import org.eclipse.datatools.sqltools.sqleditor.SQLEditorStorage;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class SQBDataSetWizardPage
extends DataSetWizardPage {
    private static final String NEWLINE_CHAR = "\n";
    private static final String EMPTY_STR = "";
    private static final String DEFAULT_MESSAGE = Messages.sqbWizPage_defaultMessage;
    private IConnectionProfile m_dataSourceProfile;
    private CustomSQLBuilderDialog m_sqbDialog;
    private boolean m_updatedQueryInput = false;
    private SortSpecification m_initQuerySortSpec;

    public SQBDataSetWizardPage(String pageName) {
        super(pageName);
        this.setMessage(DEFAULT_MESSAGE, 0);
    }

    private IConnectionProfile getConnectionProfile(boolean raiseErrorIfNull, boolean refreshProfileStore) {
        if (this.m_dataSourceProfile == null) {
            if (refreshProfileStore) {
                OdaProfileExplorer.getInstance().refresh();
            }
            Properties connProps = DesignUtil.convertDataSourceProperties((DataSourceDesign)this.getEditingDesign().getDataSourceDesign());
            this.m_dataSourceProfile = SQBDataSetWizardPage.loadConnectionProfile(connProps, this.getEditingDesign().getDataSourceDesign().getHostResourceIdentifiers());
            if (this.m_dataSourceProfile == null && raiseErrorIfNull) {
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.sqbWizPage_dataSourceDesignError, (String)Messages.sqbWizPage_noConnProfileMsg);
            }
        }
        return this.m_dataSourceProfile;
    }

    private static IConnectionProfile loadConnectionProfile(Properties connProps, ResourceIdentifiers designResourceIdentifiers) {
        Map designSessionContext = DesignSessionUtil.createResourceIdentifiersContext((ResourceIdentifiers)designResourceIdentifiers);
        try {
            return Connection.loadProfileFromProperties((Properties)connProps, (Map)designSessionContext);
        }
        catch (OdaException odaException) {
            return null;
        }
    }

    private String getDataSetDesignName() {
        return this.getEditingDesign().getName();
    }

    private String getDataSetDesignQueryText() {
        return this.getEditingDesign().getQueryText();
    }

    public void createPageCustomControl(Composite parent) {
        IConnectionProfile connProfile = this.getConnectionProfile(true, true);
        if (connProfile == null) {
            return;
        }
        ISQLBuilderEditorInput sqbInput = this.createSQBInput(parent, connProfile);
        this.setControl(this.createSQBControl(parent, sqbInput));
        SQLQueryUtility.setSystemHelp(this.getControl(), "org.eclipse.birt.cshelp.Wizard_SQLQuery_Dataset_ID");
    }

    protected void refresh(DataSetDesign dataSetDesign) {
        super.refresh(dataSetDesign);
        if (this.m_sqbDialog != null) {
            this.resetQueryDesignState(this.m_sqbDialog.getSQLQueryStatement(), dataSetDesign);
        }
    }

    private ISQLBuilderEditorInput createSQBInput(Composite parent, IConnectionProfile connProfile) {
        String sqlText;
        this.m_updatedQueryInput = false;
        SQLBuilderDesignState sqbState = this.restoreSQLBuilderStateFromDesign(parent.getShell());
        if (sqbState == null || !sqbState.hasSQBInput()) {
            return new DefaultSQBInput(connProfile);
        }
        SQLBuilderStorageEditorInput sqbInput = sqbState.getSQBStorageInput();
        String string = sqlText = sqbInput.exists() ? sqbInput.getSQL() : EMPTY_STR;
        if (!this.isSQLUpToDateInSQBInput(sqbState) && SQBDataSetWizardPage.openReplaceSQLMessageBox(parent.getShell())) {
            sqlText = this.getDataSetDesignQueryText();
            this.m_updatedQueryInput = true;
        }
        sqbInput.setStorage((IStorage)new SQLEditorStorage(this.getDataSetDesignName(), sqlText));
        sqbInput.setName(this.getDataSetDesignName());
        sqbInput.setConnectionInfo((ISQLEditorConnectionInfo)new SQLBuilderConnectionInfo(connProfile));
        SQBDataSetWizardPage.setUseWindowState(sqbInput, true);
        return sqbInput;
    }

    private void resetQueryDesignState(QueryStatement queryStmt, DataSetDesign dataSetDesign) {
        ResultSetDefinition resultSetDefn;
        this.m_initQuerySortSpec = null;
        if (queryStmt == null) {
            return;
        }
        ResultSetDefinition resultSetDefinition = resultSetDefn = dataSetDesign != null ? dataSetDesign.getPrimaryResultSet() : null;
        if (resultSetDefn == null) {
            return;
        }
        try {
            this.m_initQuerySortSpec = SQLQueryUtility.convertOrderByClauseToSortSpec(queryStmt, null, resultSetDefn);
        }
        catch (OdaException odaException) {}
    }

    private SQLBuilderDesignState restoreSQLBuilderStateFromDesign(Shell parentShell) {
        SQLBuilderDesignState sqbState;
        DesignerState designerState = this.getInitializationDesignerState();
        if (designerState == null || designerState.getStateContent() == null) {
            return null;
        }
        try {
            sqbState = new SQLBuilderDesignState(designerState);
        }
        catch (OdaException odaException) {
            SQBDataSetWizardPage.openInvalidInputMessageBox(parentShell, false);
            return null;
        }
        return sqbState;
    }

    private boolean isSQLUpToDateInSQBInput(SQLBuilderDesignState sqbState) {
        String editingQueryText;
        SQLBuilderStorageEditorInput sqbInput = sqbState.getSQBStorageInput();
        String sqlInSQBInput = sqbInput != null && sqbInput.exists() ? sqbInput.getSQL() : EMPTY_STR;
        if (SQLQueryUtility.isEquivalentSQL(sqlInSQBInput, editingQueryText = this.getDataSetDesignQueryText())) {
            return true;
        }
        sqlInSQBInput = sqbState.getPreparableSQL();
        return sqlInSQBInput != null && sqlInSQBInput.equals(editingQueryText);
    }

    private static void setUseWindowState(SQLBuilderStorageEditorInput sqbInput, boolean useWindowState) {
        ISQLBuilderEditorInputUsageOptions usageOption = sqbInput.getInputUsageOptions();
        if (usageOption != null) {
            usageOption.setUseWindowState(useWindowState);
            return;
        }
        usageOption = new SQLBuilderEditorInputUsageOptions(useWindowState);
        sqbInput.setInputUsageOptions(usageOption);
    }

    private Control createSQBControl(Composite parent, ISQLBuilderEditorInput sqbInput) {
        Composite pageContainer = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 2;
        pageContainer.setLayout((Layout)layout);
        pageContainer.setLayoutData((Object)new GridData(1808));
        Shell parentShell = parent.getShell();
        boolean isConnected = this.connect(parentShell, sqbInput);
        if (!isConnected) {
            this.setPageComplete(false);
            return pageContainer;
        }
        this.m_sqbDialog = new CustomSQLBuilderDialog(parentShell);
        boolean isInputLoaded = this.m_sqbDialog.setInput(sqbInput);
        if (!isInputLoaded && !(sqbInput instanceof DefaultSQBInput) && SQBDataSetWizardPage.openInvalidInputMessageBox(parentShell, true)) {
            isInputLoaded = this.m_sqbDialog.setInput((ISQLBuilderEditorInput)new DefaultSQBInput(sqbInput.getConnectionInfo()));
            this.m_updatedQueryInput = true;
        }
        if (isInputLoaded) {
            this.m_sqbDialog.createDialogArea(pageContainer);
            if (this.m_updatedQueryInput) {
                this.m_sqbDialog.setDirty(true);
            }
        } else {
            this.m_sqbDialog = null;
        }
        this.setPageComplete(isInputLoaded);
        return pageContainer;
    }

    private boolean connect(Shell parentShell, ISQLBuilderEditorInput sqbInput) {
        IConnectionProfile connProfile = sqbInput.getConnectionInfo().getConnectionProfile();
        if (connProfile.supportsWorkOfflineMode() && connProfile.canWorkOffline()) {
            return true;
        }
        if (connProfile.getConnectionState() == 1) {
            return true;
        }
        assert (connProfile.equals(this.getConnectionProfile(false, false)));
        return this.runConnect(parentShell);
    }

    private boolean runConnect(Shell parentShell) {
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                monitor.beginTask(Messages.sqbWizPage_connectingDB, -1);
                IStatus status = SQBDataSetWizardPage.this.doConnect();
                monitor.done();
                if (status == null || !status.isOK()) {
                    throw new InvocationTargetException(Connection.getStatusException((IStatus)status));
                }
            }
        };
        try {
            new ProgressMonitorDialog(parentShell){}.run(true, false, runnable);
        }
        catch (InvocationTargetException e) {
            SQBDataSetWizardPage.raiseConnectionErrorMessage(parentShell, e);
            return false;
        }
        catch (InterruptedException e) {
            SQBDataSetWizardPage.raiseConnectionErrorMessage(parentShell, e);
            return false;
        }
        return true;
    }

    private IStatus doConnect() {
        IConnectionProfile connProfile = this.getConnectionProfile(false, false);
        assert (connProfile != null);
        return connProfile.connectWithoutJob();
    }

    private static void raiseConnectionErrorMessage(Shell parentShell, Throwable connectException) {
        String dbMessage;
        String errorMessage = Messages.sqbWizPage_cannotOpenConnectionMsg;
        if (connectException != null && (dbMessage = connectException.getMessage()) != null) {
            errorMessage = String.valueOf(errorMessage) + NEWLINE_CHAR + Messages.sqbWizPage_dbErrorMsg + dbMessage;
        }
        ExceptionHandler.showException((Shell)parentShell, (String)Messages.sqbWizPage_cannotOpenConnectionTitle, (String)errorMessage, (Throwable)connectException);
    }

    protected void collectResponseState() {
        if (this.getControl() == null || this.getControl().isDisposed() || this.m_sqbDialog == null) {
            this.setResponseDesignerState(this.getInitializationDesignerState());
            return;
        }
        super.collectResponseState();
        SQLBuilderDesignState sqbState = this.m_sqbDialog.saveSQBState(this.getDataSetDesignName());
        if (sqbState == null) {
            return;
        }
        String sqbStateContent = sqbState.toString();
        if (sqbStateContent.length() == 0) {
            return;
        }
        DesignerState designerState = DesignFactory.eINSTANCE.createDesignerState();
        designerState.setNewStateContentAsString(sqbStateContent);
        designerState.setVersion(sqbState.getVersion());
        this.setResponseDesignerState(designerState);
    }

    protected DataSetDesign collectDataSetDesign(DataSetDesign design) {
        if (this.getControl() == null || this.getControl().isDisposed()) {
            return design;
        }
        if (this.m_sqbDialog == null) {
            return null;
        }
        if (this.m_sqbDialog.isDirty()) {
            SQLQueryUtility.updateDataSetDesign(design, this.m_sqbDialog.getSQLQueryStatement(), this.getConnectionProfile(false, false), this.getInitializationDesign(), this.m_initQuerySortSpec);
            this.m_sqbDialog.setDirty(false);
        }
        return design;
    }

    protected void cleanup() {
        Connection.closeProfile((IConnectionProfile)this.m_dataSourceProfile);
        this.m_dataSourceProfile = null;
        this.m_initQuerySortSpec = null;
        if (this.m_sqbDialog != null) {
            this.m_sqbDialog.close();
            this.m_sqbDialog = null;
        }
    }

    private static boolean openInvalidInputMessageBox(Shell parentShell, boolean askUser) {
        String userMessage = Messages.sqbWizPage_invalidSqbStateMsg;
        if (askUser) {
            userMessage = String.valueOf(userMessage) + NEWLINE_CHAR + Messages.sqbWizPage_inputFailOnOpenAskUserMessage;
            return MessageDialog.openQuestion((Shell)parentShell, (String)Messages.sqbWizPage_invalidSqbStateTitle, (String)userMessage);
        }
        MessageDialog.openWarning((Shell)parentShell, (String)Messages.sqbWizPage_invalidSqbStateTitle, (String)userMessage);
        return true;
    }

    private static boolean openReplaceSQLMessageBox(Shell parentShell) {
        return MessageDialog.openQuestion((Shell)parentShell, (String)Messages.sqbWizPage_detectSqlTextChangedTitle, (String)Messages.sqbWizPage_detectExternalSqlTextChangedMsg);
    }

    private class DefaultSQBInput
    extends SQLBuilderStorageEditorInput {
        private static final int SQBCONTROL_HEIGHT = 400;

        DefaultSQBInput(IConnectionProfile connProfile) {
            this((ISQLEditorConnectionInfo)new SQLBuilderConnectionInfo(connProfile));
        }

        DefaultSQBInput(ISQLEditorConnectionInfo connInfo) {
            super(SQBDataSetWizardPage.this.getDataSetDesignName(), SQBDataSetWizardPage.this.getDataSetDesignQueryText());
            this.init(connInfo);
        }

        private void init(ISQLEditorConnectionInfo connInfo) {
            this.setConnectionInfo(connInfo);
            this.setOmitSchemaInfo(null);
            this.setWindowStateInfo(this.createDefaultWindowState());
            SQBDataSetWizardPage.setUseWindowState(this, true);
        }

        private IWindowStateInfo createDefaultWindowState() {
            ControlStateInfo outlineControlState = new ControlStateInfo(3);
            outlineControlState.setIsVisible(false);
            WindowStateInfo windowState = new WindowStateInfo();
            windowState.put(outlineControlState.getControlType(), (IControlStateInfo)outlineControlState);
            windowState.setHeight(400);
            return windowState;
        }
    }
}

