/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.outline.quickoutline;

import java.util.regex.Pattern;

public class StringMatcher {
    private final String expression;
    private final boolean ignoreCase;
    private Pattern pattern;

    public StringMatcher(String pattern, boolean ignoreCase) {
        this.expression = this.translatePattern(pattern);
        this.ignoreCase = ignoreCase;
    }

    protected String translatePattern(String pattern) {
        String expression = pattern.replaceAll("\\(", "\\\\(");
        expression = expression.replaceAll("\\)", "\\\\)");
        expression = expression.replaceAll("\\[", "\\\\[");
        expression = expression.replaceAll("\\]", "\\\\]");
        expression = expression.replaceAll("\\{", "\\\\{");
        expression = expression.replaceAll("\\}", "\\\\}");
        expression = expression.replaceAll("\\*", ".*");
        if (!(expression = expression.replaceAll("\\?", ".")).startsWith("^")) {
            expression = "^" + expression;
        }
        return expression;
    }

    protected Pattern getPattern() {
        if (this.pattern == null) {
            this.pattern = this.ignoreCase ? Pattern.compile(this.expression, 2) : Pattern.compile(this.expression);
        }
        return this.pattern;
    }

    public boolean match(String text) {
        return this.getPattern().matcher(text).find();
    }
}

