/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.wst.validation.internal.IProjectValidationHelper;
import org.eclipse.wst.validation.internal.ResourceHandler;
import org.eclipse.wst.validation.internal.ValidationRegistryReader;
import org.eclipse.wst.validation.internal.ValidatorFilter;
import org.eclipse.wst.validation.internal.ValidatorNameFilter;
import org.eclipse.wst.validation.internal.delegates.ValidatorDelegatesRegistry;
import org.eclipse.wst.validation.internal.operations.IWorkbenchContext;
import org.eclipse.wst.validation.internal.operations.WorkbenchContext;
import org.eclipse.wst.validation.internal.plugin.ValidationHelperRegistryReader;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;
import org.eclipse.wst.validation.internal.provisional.core.IValidatorJob;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidatorMetaData {
    private final ValidatorFilter[] _filters;
    private final ValidatorNameFilter[] _projectNatureFilters;
    private final String[] _facetFilters;
    private final AtomicReference<IValidator> _validator = new AtomicReference();
    private final AtomicReference<IWorkbenchContext> _helper = new AtomicReference();
    private final String _validatorDisplayName;
    private final String _validatorUniqueName;
    private final String[] _aggregatedValidators;
    private final String[] _contentTypeIds;
    private final String[] _validatorNames;
    private final String _pluginId;
    private final boolean _supportsIncremental;
    private final boolean _supportsFullBuild;
    private final boolean _isEnabledByDefault;
    private final MigrationMetaData _migrationMetaData;
    private final int _ruleGroup;
    private final boolean _async;
    private final boolean _dependentValidator;
    private final String[] _markerIds;
    private final String _helperClassName;
    private final IConfigurationElement _helperClassElement;
    private final IConfigurationElement _validatorClassElement;
    private volatile boolean _cannotLoad;
    private volatile boolean _manualValidation = true;
    private volatile boolean _buildValidation = true;
    private final Map<IValidatorJob, IWorkbenchContext> _helpers = Collections.synchronizedMap(new HashMap());
    private final Expression _enablementExpression;
    private boolean _validateByProject = true;

    ValidatorMetaData(boolean async, String[] aggregatedValidators, boolean isEnabledByDefault, boolean supportsIncremental, boolean supportsFullBuild, IConfigurationElement helperClassElement, String helperClassName, MigrationMetaData migrationMetaData, String pluginId, int ruleGroup, IConfigurationElement validatorClassElement, String validatorDisplayName, String validatorUniqueName, String[] contentTypeIds, boolean dependentValidator, Expression enablementExpression, String[] facetFilters, ValidatorFilter[] filters, ValidatorNameFilter[] projectNatureFilters, String[] markerIds, boolean validateByProject) {
        this._async = async;
        this._aggregatedValidators = aggregatedValidators;
        this._isEnabledByDefault = isEnabledByDefault;
        this._supportsIncremental = supportsIncremental;
        this._supportsFullBuild = supportsFullBuild;
        this._helperClassElement = helperClassElement;
        this._helperClassName = helperClassName;
        this._migrationMetaData = migrationMetaData;
        this._pluginId = pluginId;
        this._ruleGroup = ruleGroup;
        this._validatorClassElement = validatorClassElement;
        this._validatorDisplayName = validatorDisplayName;
        this._validatorUniqueName = validatorUniqueName;
        this._contentTypeIds = contentTypeIds;
        this._dependentValidator = dependentValidator;
        this._enablementExpression = enablementExpression;
        this._facetFilters = facetFilters;
        this._filters = filters;
        this._projectNatureFilters = projectNatureFilters;
        this._markerIds = markerIds;
        this._validatorNames = this.buildValidatorNames();
        this._validateByProject = validateByProject;
    }

    protected String[] getFacetFilters() {
        return this._facetFilters;
    }

    public List<String> getNameFilters() {
        ArrayList<String> nameFilters = new ArrayList<String>();
        if (this._filters != null && this._filters.length > 0) {
            ValidatorFilter[] validatorFilterArray = this._filters;
            int n = this._filters.length;
            int n2 = 0;
            while (n2 < n) {
                ValidatorFilter filter = validatorFilterArray[n2];
                ValidatorNameFilter nameFilter = filter.get_nameFilter();
                if (nameFilter != null) {
                    nameFilters.add(nameFilter.getNameFilter());
                }
                ++n2;
            }
        }
        return nameFilters;
    }

    public String[] getValidatorNames() {
        return this._validatorNames;
    }

    private String[] buildValidatorNames() {
        int aLength = this._aggregatedValidators == null ? 0 : this._aggregatedValidators.length;
        String[] validatorNames = new String[aLength + 1];
        validatorNames[0] = this.getValidatorUniqueName();
        if (this._aggregatedValidators != null) {
            System.arraycopy(this._aggregatedValidators, 0, validatorNames, 1, aLength);
        }
        return validatorNames;
    }

    public String[] getAggregatedValidatorNames() {
        return this._aggregatedValidators;
    }

    public ValidatorFilter[] getFilters() {
        return this._filters;
    }

    public boolean isActive() {
        if (this._helperClassElement != null) {
            return false;
        }
        if (this._validatorClassElement != null) {
            return false;
        }
        Bundle bundle = Platform.getBundle((String)this._pluginId);
        if (bundle != null) {
            return bundle.getState() == 32;
        }
        return false;
    }

    public IWorkbenchContext getHelper(IProject project) throws InstantiationException {
        IWorkbenchContext helper = this._helper.get();
        if (helper != null) {
            IProject oldProject = helper.getProject();
            if (oldProject == null || !oldProject.equals((Object)project)) {
                helper.setProject(project);
            }
            return helper;
        }
        helper = ValidationRegistryReader.createHelper(this._helperClassElement, this._helperClassName);
        if (helper == null) {
            helper = new WorkbenchContext();
        }
        if (helper.getProject() == null || !helper.getProject().equals((Object)project)) {
            helper.setProject(project);
        }
        if (this._helper.compareAndSet(null, helper)) {
            return helper;
        }
        return this._helper.get();
    }

    private void setCannotLoad() {
        this._cannotLoad = true;
    }

    public boolean cannotLoad() {
        return this._cannotLoad;
    }

    public MigrationMetaData getMigrationMetaData() {
        return this._migrationMetaData;
    }

    public int getRuleGroup() {
        return this._ruleGroup;
    }

    ValidatorNameFilter[] getProjectNatureFilters() {
        return this._projectNatureFilters;
    }

    public IValidator getValidator() throws InstantiationException {
        IValidator val = this._validator.get();
        if (val != null) {
            return val;
        }
        val = ValidationRegistryReader.createValidator(this._validatorClassElement, this.getValidatorUniqueName());
        if (val == null) {
            this.setCannotLoad();
            throw new InstantiationException(ResourceHandler.getExternalizedMessage("VBF_EXC_DISABLEV", new String[]{this.getValidatorUniqueName()}));
        }
        if (this._validator.compareAndSet(null, val)) {
            return val;
        }
        return this._validator.get();
    }

    public String getValidatorDisplayName() {
        return this._validatorDisplayName;
    }

    public String getValidatorUniqueName() {
        return this._validatorUniqueName;
    }

    public boolean isApplicableTo(IResource resource) {
        return this.isApplicableTo(resource, 7);
    }

    public boolean isApplicableTo(IResource resource, int resourceDelta) {
        if (this._filters == null && this.getContentTypeIds() == null) {
            return true;
        }
        return this.isApplicableTo(resource, resourceDelta, this._filters);
    }

    boolean isApplicableTo(IResource resource, int resourceDelta, ValidatorFilter[] filters) {
        if (filters != null && this.checkIfValidSourceFile(resource)) {
            ValidatorFilter[] validatorFilterArray = filters;
            int n = filters.length;
            int n2 = 0;
            while (n2 < n) {
                ValidatorFilter filter = validatorFilterArray[n2];
                if (filter.isApplicableType(resource) && filter.isApplicableName(resource) && filter.isApplicableAction(resourceDelta)) {
                    return true;
                }
                ++n2;
            }
        }
        if (this.getContentTypeIds() != null) {
            IContentDescription description = null;
            try {
                if (resource.getType() == 1 && resource.exists()) {
                    description = ((IFile)resource).getContentDescription();
                }
            }
            catch (CoreException coreException) {}
            if (description == null) {
                return false;
            }
            if (this.isApplicableContentType(description)) {
                return true;
            }
        }
        return false;
    }

    private boolean checkIfValidSourceFile(IResource file) {
        if (file.getType() == 1) {
            IProjectValidationHelper helper = ValidationHelperRegistryReader.getInstance().getValidationHelper();
            IProject project = file.getProject();
            if (helper == null || project == null) {
                return true;
            }
            IContainer[] outputContainers = helper.getOutputContainers(project);
            IContainer[] sourceContainers = helper.getSourceContainers(project);
            if (outputContainers != null && sourceContainers != null) {
                int i = 0;
                while (i < outputContainers.length) {
                    String outputPath = outputContainers[i].getProjectRelativePath().makeAbsolute().toString();
                    String filePath = file.getProjectRelativePath().makeAbsolute().toString();
                    if (filePath.startsWith(outputPath)) {
                        int j = 0;
                        while (j < sourceContainers.length) {
                            if (outputContainers[i].equals((Object)sourceContainers[j])) {
                                return true;
                            }
                            ++j;
                        }
                        return false;
                    }
                    ++i;
                }
            }
        }
        return true;
    }

    ValidatorNameFilter findProjectNature(String projId) {
        if (projId == null) {
            return null;
        }
        if (this._projectNatureFilters == null) {
            return null;
        }
        int i = 0;
        while (i < this._projectNatureFilters.length) {
            ValidatorNameFilter filter = this._projectNatureFilters[i];
            String projectNatureID = filter.getNameFilter();
            if (projId.equals(projectNatureID)) {
                return filter;
            }
            ++i;
        }
        return null;
    }

    public boolean isConfiguredOnProject(IProject project) {
        return ValidationRegistryReader.getReader().isConfiguredOnProject(this, project);
    }

    public boolean isEnabledByDefault() {
        return this._isEnabledByDefault;
    }

    public boolean isIncremental() {
        return this._supportsIncremental;
    }

    public boolean isFullBuild() {
        return this._supportsFullBuild;
    }

    public boolean isAsync() {
        return this._async;
    }

    public String toString() {
        return this.getValidatorUniqueName();
    }

    public boolean isDependentValidator() {
        return this._dependentValidator;
    }

    public String[] getMarkerIds() {
        return this._markerIds;
    }

    public boolean isBuildValidation() {
        return this._buildValidation;
    }

    public void setBuildValidation(boolean buildValidation) {
        this._buildValidation = buildValidation;
    }

    public boolean isManualValidation() {
        return this._manualValidation;
    }

    public void setManualValidation(boolean manualValidation) {
        this._manualValidation = manualValidation;
    }

    public boolean isDelegating() {
        String targetID = this.getValidatorUniqueName();
        return ValidatorDelegatesRegistry.getInstance().hasDelegates(targetID);
    }

    public IValidator createValidator() throws InstantiationException {
        return ValidationRegistryReader.createValidator(this._validatorClassElement, this.getValidatorUniqueName());
    }

    public IWorkbenchContext createHelper(IProject project) throws InstantiationException {
        IWorkbenchContext helper = ValidationRegistryReader.createHelper(this._helperClassElement, this._helperClassName);
        if (helper == null) {
            helper = new WorkbenchContext();
        }
        helper.setProject(project);
        return helper;
    }

    public void addHelper(IValidatorJob validator, IWorkbenchContext helper) {
        this._helpers.put(validator, helper);
    }

    public void removeHelper(IValidatorJob validator) {
        this._helpers.remove(validator);
    }

    private IWorkbenchContext getHelper(IValidatorJob validator) {
        return this._helpers.get(validator);
    }

    public IWorkbenchContext getHelper(IProject project, IValidator validator) {
        if (validator instanceof IValidatorJob) {
            IWorkbenchContext helper = this.getHelper((IValidatorJob)validator);
            if (helper == null) {
                try {
                    helper = this.getHelper(project);
                    return helper;
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                }
            }
            return helper;
        }
        try {
            IWorkbenchContext helper = this.getHelper(project);
            return helper;
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Expression getEnablementExpresion() {
        return this._enablementExpression;
    }

    public String[] getContentTypeIds() {
        return this._contentTypeIds;
    }

    private boolean isApplicableContentType(IContentDescription desc) {
        IContentType ct = desc.getContentType();
        String[] applicableContentTypes = this.getContentTypeIds();
        if (applicableContentTypes != null) {
            int i = 0;
            while (i < applicableContentTypes.length) {
                if (applicableContentTypes[i].equals(ct.getId())) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public boolean isValidateByProject() {
        return this._validateByProject;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class MigrationMetaData {
        private Set<String[]> _ids;

        public void addId(String oldId, String newId) {
            if (oldId == null) {
                return;
            }
            if (newId == null) {
                return;
            }
            String[] ids = new String[]{oldId, newId};
            this.getIds().add(ids);
        }

        public Set<String[]> getIds() {
            if (this._ids == null) {
                this._ids = new HashSet<String[]>();
            }
            return this._ids;
        }
    }
}

