/**
 * Copyright (c) 2010-2016, Abel Hegedus, IncQuery Labs Ltd.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * Contributors:
 * Abel Hegedus - initial API and implementation
 */
package org.eclipse.viatra.query.tooling.ui.queryresult;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import java.util.Arrays;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.viatra.query.runtime.api.AdvancedViatraQueryEngine;
import org.eclipse.viatra.query.runtime.api.IPatternMatch;
import org.eclipse.viatra.query.runtime.api.IQuerySpecification;
import org.eclipse.viatra.query.runtime.api.ViatraQueryMatcher;
import org.eclipse.viatra.query.runtime.emf.helper.ViatraQueryRuntimeHelper;
import org.eclipse.viatra.query.runtime.registry.IQuerySpecificationRegistryEntry;
import org.eclipse.viatra.query.tooling.ui.ViatraQueryGUIPlugin;
import org.eclipse.viatra.query.tooling.ui.queryexplorer.util.DisplayUtil;
import org.eclipse.viatra.query.tooling.ui.queryresult.QueryResultTreeInput;
import org.eclipse.viatra.query.tooling.ui.queryresult.QueryResultTreeMatcher;
import org.eclipse.viatra.query.tooling.ui.queryresult.util.QueryResultViewUtil;
import org.eclipse.xtend2.lib.StringConcatenation;

/**
 * @author Abel Hegedus
 */
@SuppressWarnings("all")
class QueryResultTreeLabelProvider extends ColumnLabelProvider {
  private final ImageRegistry imageRegistry = ViatraQueryGUIPlugin.getDefault().getImageRegistry();
  
  private AdapterFactoryLabelProvider adapterFactoryLabelProvider;
  
  public QueryResultTreeLabelProvider() {
    final AdapterFactory adapterFactory = QueryResultViewUtil.getGenericAdapterFactory();
    AdapterFactoryLabelProvider _adapterFactoryLabelProvider = new AdapterFactoryLabelProvider(adapterFactory);
    this.adapterFactoryLabelProvider = _adapterFactoryLabelProvider;
  }
  
  @Override
  public Image getImage(final Object element) {
    return this.getImageInternal(element);
  }
  
  protected Image _getImageInternal(final QueryResultTreeInput element) {
    return this.imageRegistry.get(ViatraQueryGUIPlugin.ICON_ROOT);
  }
  
  protected Image _getImageInternal(final QueryResultTreeMatcher element) {
    Image _xifexpression = null;
    Exception _exception = element.getException();
    boolean _notEquals = (!Objects.equal(_exception, null));
    if (_notEquals) {
      _xifexpression = this.imageRegistry.get(ViatraQueryGUIPlugin.ICON_ERROR);
    } else {
      _xifexpression = this.imageRegistry.get(ViatraQueryGUIPlugin.ICON_MATCHER);
    }
    return _xifexpression;
  }
  
  protected Image _getImageInternal(final IPatternMatch element) {
    return this.imageRegistry.get(ViatraQueryGUIPlugin.ICON_MATCH);
  }
  
  protected Image _getImageInternal(final Object element) {
    return this.adapterFactoryLabelProvider.getImage(element);
  }
  
  @Override
  public String getText(final Object element) {
    return this.getTextInternal(element);
  }
  
  protected String _getTextInternal(final QueryResultTreeInput element) {
    AdvancedViatraQueryEngine _engine = element.getEngine();
    return _engine.toString();
  }
  
  protected String _getTextInternal(final QueryResultTreeMatcher element) {
    Exception _exception = element.getException();
    boolean _notEquals = (!Objects.equal(_exception, null));
    if (_notEquals) {
      StringConcatenation _builder = new StringConcatenation();
      IQuerySpecificationRegistryEntry _entry = element.getEntry();
      String _fullyQualifiedName = null;
      if (_entry!=null) {
        _fullyQualifiedName=_entry.getFullyQualifiedName();
      }
      _builder.append(_fullyQualifiedName, "");
      _builder.append(" - ");
      Exception _exception_1 = element.getException();
      String _message = _exception_1.getMessage();
      _builder.append(_message, "");
      return _builder.toString();
    }
    final ViatraQueryMatcher matcher = element.getMatcher();
    IPatternMatch _filterMatch = element.getFilterMatch();
    final int count = matcher.countMatches(_filterMatch);
    String _switchResult = null;
    switch (count) {
      case 0:
        _switchResult = "No matches";
        break;
      case 1:
        _switchResult = "1 match";
        break;
      default:
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append(count, "");
        _builder_1.append(" matches");
        _switchResult = _builder_1.toString();
        break;
    }
    final String countMsg = _switchResult;
    String _xifexpression = null;
    boolean _isFiltered = element.isFiltered();
    if (_isFiltered) {
      _xifexpression = " (Filtered)";
    } else {
      _xifexpression = "";
    }
    final String filterMsg = _xifexpression;
    StringConcatenation _builder_1 = new StringConcatenation();
    IQuerySpecification _specification = matcher.getSpecification();
    String _fullyQualifiedName_1 = _specification.getFullyQualifiedName();
    _builder_1.append(_fullyQualifiedName_1, "");
    _builder_1.append(" - ");
    _builder_1.append(countMsg, "");
    _builder_1.append(filterMsg, "");
    return _builder_1.toString();
  }
  
  protected String _getTextInternal(final IPatternMatch element) {
    final String message = DisplayUtil.getMessage(element);
    boolean _notEquals = (!Objects.equal(message, null));
    if (_notEquals) {
      final Function<Object, String> _function = new Function<Object, String>() {
        @Override
        public String apply(final Object it) {
          return QueryResultTreeLabelProvider.this.adapterFactoryLabelProvider.getText(it);
        }
      };
      return ViatraQueryRuntimeHelper.getMessage(element, message, _function);
    }
    return element.prettyPrint();
  }
  
  protected String _getTextInternal(final Object element) {
    return this.adapterFactoryLabelProvider.getText(element);
  }
  
  public Image getImageInternal(final Object element) {
    if (element instanceof IPatternMatch) {
      return _getImageInternal((IPatternMatch)element);
    } else if (element instanceof QueryResultTreeInput) {
      return _getImageInternal((QueryResultTreeInput)element);
    } else if (element instanceof QueryResultTreeMatcher) {
      return _getImageInternal((QueryResultTreeMatcher)element);
    } else if (element != null) {
      return _getImageInternal(element);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(element).toString());
    }
  }
  
  public String getTextInternal(final Object element) {
    if (element instanceof IPatternMatch) {
      return _getTextInternal((IPatternMatch)element);
    } else if (element instanceof QueryResultTreeInput) {
      return _getTextInternal((QueryResultTreeInput)element);
    } else if (element instanceof QueryResultTreeMatcher) {
      return _getTextInternal((QueryResultTreeMatcher)element);
    } else if (element != null) {
      return _getTextInternal(element);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(element).toString());
    }
  }
}
