/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.synchronization;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigDecimal;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.tmf.core.Activator;
import org.eclipse.tracecompass.internal.tmf.core.synchronization.TmfConstantTransform;
import org.eclipse.tracecompass.internal.tmf.core.synchronization.TmfTimestampTransform;
import org.eclipse.tracecompass.internal.tmf.core.synchronization.TmfTimestampTransformLinearFast;
import org.eclipse.tracecompass.tmf.core.TmfCommonConstants;
import org.eclipse.tracecompass.tmf.core.synchronization.ITmfTimestampTransform;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;

@NonNullByDefault
public final class TimestampTransformFactory {
    private static final String SYNCHRONIZATION_FORMULA_FILE = "sync_formula";

    private TimestampTransformFactory() {
    }

    public static ITmfTimestampTransform getDefaultTransform() {
        return TmfTimestampTransform.IDENTITY;
    }

    public static ITmfTimestampTransform createWithOffset(long offset) {
        if (offset == 0L) {
            return TmfTimestampTransform.IDENTITY;
        }
        return new TmfConstantTransform(offset);
    }

    public static ITmfTimestampTransform createWithOffset(ITmfTimestamp offset) {
        if (offset.getValue() == 0L) {
            return TmfTimestampTransform.IDENTITY;
        }
        return new TmfConstantTransform(offset);
    }

    public static ITmfTimestampTransform createLinear(double factor, ITmfTimestamp offset) {
        if (factor == 1.0) {
            return TimestampTransformFactory.createWithOffset(offset);
        }
        return new TmfTimestampTransformLinearFast(factor, offset.toNanos());
    }

    public static ITmfTimestampTransform createLinear(double factor, long offset) {
        if (factor == 1.0) {
            return TimestampTransformFactory.createWithOffset(offset);
        }
        return new TmfTimestampTransformLinearFast(factor, offset);
    }

    public static ITmfTimestampTransform createLinear(BigDecimal factor, BigDecimal offset) {
        if (factor.equals(BigDecimal.ONE)) {
            return TimestampTransformFactory.createWithOffset(offset.longValueExact());
        }
        return new TmfTimestampTransformLinearFast(factor, offset);
    }

    private static @Nullable File getSyncFormulaFile(@Nullable IResource resource) {
        if (resource == null) {
            return null;
        }
        try {
            String supplDirectory = resource.getPersistentProperty(TmfCommonConstants.TRACE_SUPPLEMENTARY_FOLDER);
            return new File(String.valueOf(supplDirectory) + File.separator + SYNCHRONIZATION_FORMULA_FILE);
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ITmfTimestampTransform getTimestampTransform(@Nullable IResource resource) {
        File syncFile = TimestampTransformFactory.getSyncFormulaFile(resource);
        if (syncFile == null) return TimestampTransformFactory.getDefaultTransform();
        if (!syncFile.exists()) return TimestampTransformFactory.getDefaultTransform();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try {
                FileInputStream fis = new FileInputStream(syncFile);
                try {
                    ITmfTimestampTransform iTmfTimestampTransform;
                    block16: {
                        ObjectInputStream ois = new ObjectInputStream(fis);
                        try {
                            iTmfTimestampTransform = (ITmfTimestampTransform)NonNullUtils.checkNotNull((Object)((ITmfTimestampTransform)ois.readObject()));
                            return iTmfTimestampTransform;
                        }
                        finally {
                            if (ois == null) break block16;
                            ois.close();
                        }
                    }
                    if (fis != null) {
                        fis.close();
                    }
                    return iTmfTimestampTransform;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (fis == null) throw throwable;
                    fis.close();
                    throw throwable;
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                }
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
                throw throwable;
            }
        }
        catch (IOException | ClassNotFoundException exception) {
            // empty catch block
        }
        return TimestampTransformFactory.getDefaultTransform();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void setTimestampTransform(@Nullable IResource resource, @Nullable ITmfTimestampTransform tt) {
        File syncFile = TimestampTransformFactory.getSyncFormulaFile(resource);
        if (syncFile == null) return;
        if (syncFile.exists()) {
            syncFile.delete();
        }
        if (tt == null) {
            return;
        }
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try {
                FileOutputStream fos = new FileOutputStream(syncFile, false);
                try {
                    try (ObjectOutputStream oos = new ObjectOutputStream(fos);){
                        oos.writeObject(tt);
                    }
                    if (fos == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (fos == null) throw throwable;
                    fos.close();
                    throw throwable;
                }
                fos.close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException e1) {
            Activator.logError("Error writing timestamp transform for trace", e1);
        }
    }
}

