/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.statesystem.core.statevalue;

import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateValueTypeException;
import org.eclipse.tracecompass.statesystem.core.statevalue.DoubleStateValue;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.statesystem.core.statevalue.IntegerStateValue;
import org.eclipse.tracecompass.statesystem.core.statevalue.TmfStateValue;

final class LongStateValue
extends TmfStateValue {
    private final long value;

    public LongStateValue(long valueAsLong) {
        this.value = valueAsLong;
    }

    @Override
    public ITmfStateValue.Type getType() {
        return ITmfStateValue.Type.LONG;
    }

    @Override
    public boolean isNull() {
        return false;
    }

    public boolean equals(@Nullable Object object) {
        if (!(object instanceof LongStateValue)) {
            return false;
        }
        LongStateValue other = (LongStateValue)object;
        return this.value == other.value;
    }

    public int hashCode() {
        return (int)this.value ^ (int)(this.value >>> 32);
    }

    public @Nullable String toString() {
        return String.format("%3d", this.value);
    }

    @Override
    public long unboxLong() {
        return this.value;
    }

    @Override
    public int compareTo(@Nullable ITmfStateValue other) {
        if (other == null) {
            throw new IllegalArgumentException();
        }
        switch (other.getType()) {
            case INTEGER: {
                long otherLongValue = ((IntegerStateValue)other).unboxInt();
                return Long.compare(this.value, otherLongValue);
            }
            case DOUBLE: {
                double otherDoubleValue = ((DoubleStateValue)other).unboxDouble();
                return Double.compare(this.value, otherDoubleValue);
            }
            case LONG: {
                long otherLongValue = ((LongStateValue)other).unboxLong();
                return Long.compare(this.value, otherLongValue);
            }
            case NULL: {
                return Long.compare(this.value, other.unboxLong());
            }
            case STRING: {
                throw new StateValueTypeException("A Long state value cannot be compared to a String state value.");
            }
        }
        throw new StateValueTypeException("A Long state value cannot be compared to the type " + (Object)((Object)other.getType()));
    }
}

