/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.ctf.core.event.types;

import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableSet;
import java.nio.ByteOrder;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.ctf.core.CTFException;
import org.eclipse.tracecompass.ctf.core.event.io.BitBuffer;
import org.eclipse.tracecompass.ctf.core.event.scope.IDefinitionScope;
import org.eclipse.tracecompass.ctf.core.event.types.Declaration;
import org.eclipse.tracecompass.ctf.core.event.types.EnumDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.IDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.ISimpleDatatypeDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.IntegerDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.IntegerDefinition;

public final class EnumDeclaration
extends Declaration
implements ISimpleDatatypeDeclaration {
    private final TreeMap<Pair, String> fEnumTree = new TreeMap(Comparator.comparingLong(Pair::getFirst).thenComparingLong(Pair::getSecond));
    private final IntegerDeclaration fContainerType;
    private Pair fLastAdded = new Pair(-1L, -1L);

    public EnumDeclaration(IntegerDeclaration containerType) {
        this.fContainerType = containerType;
    }

    public IntegerDeclaration getContainerType() {
        return this.fContainerType;
    }

    @Override
    public long getAlignment() {
        return this.getContainerType().getAlignment();
    }

    @Override
    public int getMaximumSize() {
        return this.fContainerType.getMaximumSize();
    }

    @Override
    public boolean isByteOrderSet() {
        return this.fContainerType.isByteOrderSet();
    }

    @Override
    public ByteOrder getByteOrder() {
        return this.fContainerType.getByteOrder();
    }

    @Override
    public EnumDefinition createDefinition(@Nullable IDefinitionScope definitionScope, String fieldName, BitBuffer input) throws CTFException {
        this.alignRead(input);
        IntegerDefinition value = this.getContainerType().createDefinition(definitionScope, fieldName, input);
        return new EnumDefinition(this, definitionScope, fieldName, value);
    }

    public boolean add(long low, long high, @Nullable String label) {
        Map.Entry entry;
        if (high < low) {
            return false;
        }
        Set descendingSet = this.fEnumTree.descendingMap().tailMap(new Pair(high, Long.MAX_VALUE), true).entrySet();
        Iterator iterator = descendingSet.iterator();
        if (iterator.hasNext() && ((Pair)(entry = iterator.next()).getKey()).fSecond >= low) {
            return false;
        }
        this.fLastAdded = new Pair(low, high);
        this.fEnumTree.put(this.fLastAdded, label);
        return true;
    }

    public boolean add(@Nullable String label) {
        return this.add(this.fLastAdded.fFirst + 1L, this.fLastAdded.fSecond + 1L, label);
    }

    public @Nullable String query(long value) {
        Map.Entry<Pair, String> floorEntry = this.fEnumTree.floorEntry(new Pair(value, Long.MAX_VALUE));
        if (floorEntry != null && floorEntry.getKey().fSecond >= value) {
            return floorEntry.getValue();
        }
        return null;
    }

    public Map<String, Pair> getEnumTable() {
        return ImmutableBiMap.copyOf(this.fEnumTree).inverse();
    }

    public Set<String> getLabels() {
        return ImmutableSet.copyOf(this.fEnumTree.values());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[declaration] enum[");
        for (String label : this.fEnumTree.values()) {
            sb.append("label:").append(label).append(' ');
        }
        sb.append("type:").append(this.fContainerType.toString());
        sb.append(']');
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 31 + this.fContainerType.hashCode();
        for (String label : this.fEnumTree.values()) {
            result = 31 * result + label.hashCode();
        }
        result = 31 * result + this.fEnumTree.hashCode();
        return result;
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EnumDeclaration other = (EnumDeclaration)obj;
        if (!this.fContainerType.equals(other.fContainerType)) {
            return false;
        }
        return this.fEnumTree.equals(other.fEnumTree);
    }

    @Override
    public boolean isBinaryEquivalent(@Nullable IDeclaration obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EnumDeclaration other = (EnumDeclaration)obj;
        if (!this.fContainerType.isBinaryEquivalent((IDeclaration)other.fContainerType)) {
            return false;
        }
        return this.fEnumTree.equals(other.fEnumTree);
    }

    public static class Pair {
        private final long fFirst;
        private final long fSecond;

        private Pair(long first, long second) {
            this.fFirst = first;
            this.fSecond = second;
        }

        public long getFirst() {
            return this.fFirst;
        }

        public long getSecond() {
            return this.fSecond;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Pair other = (Pair)obj;
            return this.fFirst == other.fFirst && this.fSecond == other.fSecond;
        }

        public int hashCode() {
            return Objects.hash(this.fFirst, this.fSecond);
        }
    }
}

