/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.ui.util;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;

public class RetrieveNameAttributeHelper {
    private static final String NAME = "name";
    private static final String ID = "id";
    private Map<EClass, NameAttributeInfo> nameAttributeCache = new WeakHashMap<EClass, NameAttributeInfo>();

    public EAttribute getNameAttribute(EObject object) {
        ArrayList<EClass> eTypes = new ArrayList<EClass>();
        eTypes.add(object.eClass());
        eTypes.addAll((Collection<EClass>)object.eClass().getEAllSuperTypes());
        for (EClass eType : eTypes) {
            NameAttributeInfo info;
            if (!this.nameAttributeCache.containsKey(eType) || (info = this.nameAttributeCache.get(eType)).isFallback()) continue;
            return info.getEAttribute();
        }
        NameAttributeInfo info = this.getNameAttribute((List<EAttribute>)object.eClass().getEAllAttributes());
        if (info != null) {
            if (!this.nameAttributeCache.containsKey(info.getEAttribute().getEContainingClass())) {
                this.nameAttributeCache.put(info.getEAttribute().getEContainingClass(), info);
            }
            return info.getEAttribute();
        }
        return null;
    }

    protected NameAttributeInfo getNameAttribute(List<EAttribute> nameAttributeCandidates) {
        EAttribute nameAttribute = null;
        boolean isFallback = true;
        for (EAttribute attribute : nameAttributeCandidates) {
            String attributeName = attribute.getName();
            if (attributeName == null) continue;
            if (attributeName.equalsIgnoreCase(NAME)) {
                nameAttribute = attribute;
                isFallback = false;
                continue;
            }
            if (attributeName.equalsIgnoreCase(ID)) {
                if (nameAttribute != null && nameAttribute.getName().toLowerCase().endsWith(NAME)) continue;
                nameAttribute = attribute;
                isFallback = false;
                continue;
            }
            if (attributeName.toLowerCase().endsWith(NAME)) {
                if (nameAttribute != null && (nameAttribute.getName().toLowerCase().endsWith(NAME) || nameAttribute.getName().equalsIgnoreCase(ID))) continue;
                nameAttribute = attribute;
                isFallback = false;
                continue;
            }
            if (attributeName.toLowerCase().indexOf(NAME) != -1) {
                if (nameAttribute != null && (nameAttribute.getName().toLowerCase().indexOf(NAME) != -1 || nameAttribute.getName().equalsIgnoreCase(ID))) continue;
                nameAttribute = attribute;
                isFallback = false;
                continue;
            }
            if (nameAttribute != null) continue;
            nameAttribute = attribute;
        }
        return nameAttribute != null ? new NameAttributeInfo(nameAttribute, isFallback) : null;
    }

    public boolean hasNameAttribute(EObject object) {
        return this.getNameAttribute(object) != null;
    }

    protected EAttribute cacheAttribute(NameAttributeInfo nameAttribute) {
        if (!this.nameAttributeCache.containsKey(nameAttribute.getEAttribute().getEContainingClass())) {
            this.nameAttributeCache.put(nameAttribute.getEAttribute().getEContainingClass(), nameAttribute);
        }
        return nameAttribute.getEAttribute();
    }

    private class NameAttributeInfo {
        private WeakReference<EAttribute> eAttribute;
        private boolean isFallback;

        public NameAttributeInfo(EAttribute attr, boolean isFallback) {
            Assert.isNotNull((Object)attr);
            this.eAttribute = new WeakReference<EAttribute>(attr);
            this.isFallback = isFallback;
        }

        public EAttribute getEAttribute() {
            return (EAttribute)this.eAttribute.get();
        }

        public boolean isFallback() {
            return this.isFallback;
        }
    }
}

