/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.internal.resources;

import java.io.IOException;
import java.util.Arrays;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.rcptt.core.builder.IQ7ProblemReporter;
import org.eclipse.rcptt.core.model.IContext;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.core.persistence.IPersistenceModel;
import org.eclipse.rcptt.ctx.resources.ImportUtils;
import org.eclipse.rcptt.ctx.resources.WSUtils;
import org.eclipse.rcptt.internal.core.RcpttPlugin;
import org.eclipse.rcptt.util.Predicate;
import org.eclipse.rcptt.workspace.WSFile;
import org.eclipse.rcptt.workspace.WSLink;
import org.eclipse.rcptt.workspace.WSResource;
import org.eclipse.rcptt.workspace.WorkspaceContext;

public class WSValidators {
    public static void validateContent(final WorkspaceContext ctx, final IContext element, final IQ7ProblemReporter reporter, final SubMonitor monitor) {
        try {
            final IPersistenceModel model = element.getPersistenceModel();
            model.extractAll();
            WSUtils.visitWorkspace((WorkspaceContext)ctx, (SubMonitor)monitor, (Predicate)new Predicate<WSResource>(){

                public boolean apply(WSResource input) {
                    if (monitor.isCanceled()) {
                        return true;
                    }
                    if (input instanceof WSFile) {
                        String name = ImportUtils.getName((WSFile)((WSFile)input));
                        try {
                            WSUtils.getFileStream(null, (WSFile)((WSFile)input), (IPersistenceModel)model).close();
                        }
                        catch (IOException iOException) {
                            String message = String.format("File %s is absent in workspace %s. Please recapture the context or delete broken file.", name, ctx.getName());
                            reporter.reportProblem((IFile)element.getResource(), IQ7ProblemReporter.ProblemType.Error, message, -1, -1, -1, -1);
                        }
                    }
                    return false;
                }
            });
        }
        catch (ModelException e) {
            RcpttPlugin.log((Throwable)e);
            reporter.reportProblem((IFile)element.getResource(), IQ7ProblemReporter.ProblemType.Error, e.getMessage(), -1, -1, -1, -1);
        }
    }

    public static boolean validateLink(WSLink link, IFile resource, IQ7ProblemReporter reporter) {
        IResource member;
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(link.getProject());
        if (project == null || !project.exists()) {
            if (reporter != null) {
                reporter.reportProblem(resource, IQ7ProblemReporter.ProblemType.Error, String.format("Can not resolve \"%s\" project from link \"%s/%s\".", link.getProject(), link.getProject(), link.getPath()), -1, -1, -1, -1);
            }
            return false;
        }
        if (resource != null) {
            try {
                IProject thisProject = resource.getProject();
                if (!project.equals((Object)thisProject) && !Arrays.asList(thisProject.getReferencedProjects()).contains(project)) {
                    if (reporter != null) {
                        reporter.reportProblem(resource, IQ7ProblemReporter.ProblemType.Error, String.format("\"%s\" project from link \"%s/%s\" is not referenced by project \"%s\".", link.getProject(), link.getProject(), link.getPath(), thisProject.getName()), -1, -1, -1, -1);
                    }
                    return false;
                }
            }
            catch (CoreException e) {
                RcpttPlugin.log((Throwable)e);
                if (reporter != null) {
                    reporter.reportProblem(resource, IQ7ProblemReporter.ProblemType.Error, String.format(e.getMessage(), link.getProject(), link.getProject(), link.getPath()), -1, -1, -1, -1);
                }
                return false;
            }
        }
        if ((member = project.findMember(link.getPath())) == null || !member.exists()) {
            if (reporter != null) {
                reporter.reportProblem(resource, IQ7ProblemReporter.ProblemType.Error, String.format("Can not resolve \"%s\" file or directory from link \"%s/%s\".", link.getPath(), link.getProject(), link.getPath()), -1, -1, -1, -1);
            }
            return false;
        }
        return true;
    }

    public static void validateLinks(WorkspaceContext ctx, final IFile resource, final IQ7ProblemReporter reporter, SubMonitor monitor) {
        WSUtils.visitWorkspace((WorkspaceContext)ctx, (SubMonitor)monitor, (Predicate)new Predicate<WSResource>(){

            public boolean apply(WSResource input) {
                if (input instanceof WSLink) {
                    WSValidators.validateLink((WSLink)input, resource, reporter);
                }
                return false;
            }
        });
    }
}

