/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.nattable.config;

import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.edit.EditConfigAttributes;
import org.eclipse.nebula.widgets.nattable.edit.editor.ComboBoxCellEditor;
import org.eclipse.nebula.widgets.nattable.edit.editor.IComboBoxDataProvider;
import org.eclipse.nebula.widgets.nattable.painter.cell.TextPainter;
import org.eclipse.papyrus.infra.nattable.celleditor.config.ICellAxisConfiguration;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.manager.table.ITableAxisElementProvider;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.IdAxis;
import org.eclipse.papyrus.infra.nattable.utils.AxisUtils;
import org.eclipse.papyrus.infra.nattable.utils.NattableConfigAttributes;
import org.eclipse.papyrus.uml.nattable.dataprovider.UMLStereotypeSingleEnumerationComboBoxDataProvider;
import org.eclipse.papyrus.uml.nattable.utils.UMLTableUtils;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;

public class UMLStereotypeSingleUMLEnumerationCellEditorConfiguration
implements ICellAxisConfiguration {
    public static final String ID = "org.eclipse.papyrus.uml.nattable.celleditor.configuration.UMLStereotypeSingleUMLEnumerationCellEditorConfiguration.ComboBox";

    public String getConfigurationId() {
        return ID;
    }

    public String getConfigurationDescription() {
        return "This configuration provides a multi editor for a single UML Enumeration type";
    }

    public boolean handles(Table table, Object axisElement) {
        Property prop;
        boolean result = false;
        String id = AxisUtils.getPropertyId((Object)axisElement);
        if (id != null && id.startsWith("property_of_stereotype:/") && (prop = UMLTableUtils.getRealStereotypeProperty(table.getContext(), id)) != null && !prop.isMultivalued()) {
            Type type = prop.getType();
            result = type instanceof Enumeration;
        }
        return result;
    }

    public void configureCellEditor(IConfigRegistry configRegistry, Object axis, String configLabel) {
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, (Object)new TextPainter(), "EDIT", configLabel);
        INattableModelManager modelManager = (INattableModelManager)configRegistry.getConfigAttribute(NattableConfigAttributes.NATTABLE_MODEL_MANAGER_CONFIG_ATTRIBUTE, "NORMAL", new String[]{"nattable_model_manager_id"});
        configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITOR, (Object)new ComboBoxCellEditor(this.getComboDataProvider(modelManager.getTable(), axis, modelManager.getTableAxisElementProvider())), "EDIT", configLabel);
    }

    protected IComboBoxDataProvider getComboDataProvider(Table table, Object axisElement, ITableAxisElementProvider elementProvider) {
        UMLStereotypeSingleEnumerationComboBoxDataProvider comboDataProvider = null;
        String id = axisElement instanceof IdAxis ? ((IdAxis)axisElement).getElement() : (axisElement instanceof String ? (String)axisElement : null);
        if (id != null) {
            comboDataProvider = new UMLStereotypeSingleEnumerationComboBoxDataProvider(axisElement, elementProvider);
        }
        return comboDataProvider;
    }
}

