/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.sync;

import com.google.common.base.Objects;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.papyrus.infra.sync.EMFDispatchManager;
import org.eclipse.papyrus.infra.sync.EStructuralFeatureSyncDispatcher;
import org.eclipse.papyrus.infra.sync.SyncBucket;
import org.eclipse.papyrus.infra.sync.SyncFeature;
import org.eclipse.papyrus.infra.sync.SyncItem;

public class EObjectEAttributeSyncFeature<M extends EObject>
extends SyncFeature<M, EObject, Notification> {
    private final EAttribute attribute;
    private EMFDispatchManager<Dispatcher> dispatchMgr = this.createSingleDispatchManager();

    public EObjectEAttributeSyncFeature(SyncBucket<M, EObject, Notification> bucket, EAttribute attribute) {
        super(bucket);
        this.attribute = attribute;
    }

    public static <M extends EObject> EObjectEAttributeSyncFeature<M> create(SyncBucket<M, EObject, Notification> bucket, EAttribute attribute) {
        return new EObjectEAttributeSyncFeature<M>(bucket, attribute);
    }

    @Override
    public void observe(SyncItem<M, EObject> item) {
        this.dispatchMgr.add(item, new Dispatcher(item, (EStructuralFeature)this.attribute));
    }

    @Override
    public void unobserve(SyncItem<M, EObject> item) {
        this.dispatchMgr.remove(item);
    }

    @Override
    protected void onClear() {
        this.dispatchMgr.removeAll();
    }

    @Override
    public void synchronize(SyncItem<M, EObject> from, SyncItem<M, EObject> to, Notification message) {
        if (message == null) {
            this.synchronizeInit(from, to);
        } else {
            this.synchronizeIncrement(from, to, message);
        }
    }

    private void synchronizeInit(SyncItem<M, EObject> from, SyncItem<M, EObject> to) {
        Object valueTo;
        Object valueFrom = from.getBackend().eGet((EStructuralFeature)this.attribute);
        if (!Objects.equal((Object)valueFrom, (Object)(valueTo = to.getBackend().eGet((EStructuralFeature)this.attribute)))) {
            Command command = SetCommand.create((EditingDomain)this.getEditingDomain(), (Object)to.getBackend(), (Object)this.attribute, (Object)valueFrom);
            this.execute(command);
        }
    }

    private void synchronizeIncrement(SyncItem<M, EObject> from, SyncItem<M, EObject> to, Notification message) {
        Dispatcher dispatcher = this.dispatchMgr.getDispatcher(from, message.getFeature());
        switch (message.getEventType()) {
            case 3: {
                dispatcher.handleAdd(from, to, message.getNewValue());
                break;
            }
            case 5: {
                for (Object next : (Iterable)message.getNewValue()) {
                    dispatcher.handleAdd(from, to, next);
                }
                break;
            }
            case 4: {
                dispatcher.handleRemove(from, to, message.getOldValue());
                break;
            }
            case 6: {
                for (Object next : (Iterable)message.getOldValue()) {
                    dispatcher.handleRemove(from, to, next);
                }
                break;
            }
            case 1: {
                if (message.getOldValue() != null) {
                    dispatcher.handleRemove(from, to, message.getOldValue());
                }
                if (message.getNewValue() == null) break;
                dispatcher.handleAdd(from, to, message.getNewValue());
                break;
            }
            case 2: {
                if (!(message.getOldValue() instanceof EObject)) break;
                dispatcher.handleRemove(from, to, message.getOldValue());
            }
        }
    }

    protected Command getAddCommand(SyncItem<M, EObject> from, SyncItem<M, EObject> to, Object value) {
        return this.attribute.isMany() ? AddCommand.create((EditingDomain)this.getEditingDomain(), (Object)to.getBackend(), (Object)this.attribute, (Object)value) : SetCommand.create((EditingDomain)this.getEditingDomain(), (Object)to.getBackend(), (Object)this.attribute, (Object)value);
    }

    protected Command getRemoveCommand(SyncItem<M, EObject> from, SyncItem<M, EObject> to, Object value) {
        return this.attribute.isMany() ? RemoveCommand.create((EditingDomain)this.getEditingDomain(), (Object)to.getBackend(), (Object)this.attribute, (Object)value) : SetCommand.create((EditingDomain)this.getEditingDomain(), (Object)to.getBackend(), (Object)this.attribute, (Object)SetCommand.UNSET_VALUE);
    }

    protected EObject getModelOf(EObject backend) {
        EObject notifier = this.getNotifier(backend);
        return notifier == null ? null : this.getModelOfNotifier(notifier);
    }

    protected EObject getNotifier(EObject backend) {
        return backend;
    }

    protected EObject getModelOfNotifier(EObject backendNotifier) {
        return backendNotifier;
    }

    private class Dispatcher
    extends EStructuralFeatureSyncDispatcher<M, EObject> {
        public Dispatcher(SyncItem<M, EObject> item, EStructuralFeature feature) {
            super(item, feature);
        }

        @Override
        public EObject getNotifier() {
            return EObjectEAttributeSyncFeature.this.getNotifier((EObject)this.getItem().getBackend());
        }

        @Override
        public void onClear() {
            EObjectEAttributeSyncFeature.this.getBucket().clear();
        }

        @Override
        public void onChange(Notification notification) {
            EObjectEAttributeSyncFeature.this.onChange(this.getItem(), notification);
        }

        List<?> getContents(EObject owner) {
            Object value;
            List result = EObjectEAttributeSyncFeature.this.attribute.isMany() ? (List)owner.eGet((EStructuralFeature)EObjectEAttributeSyncFeature.this.attribute) : ((value = owner.eGet((EStructuralFeature)EObjectEAttributeSyncFeature.this.attribute)) == null ? ECollections.EMPTY_ELIST : ECollections.singletonEList((Object)value));
            return result;
        }

        boolean handleAdd(SyncItem<M, EObject> from, SyncItem<M, EObject> to, Object value) {
            boolean result;
            List<?> values = this.getContents(to.getBackend());
            boolean bl = result = !values.contains(value);
            if (result) {
                this.react(EObjectEAttributeSyncFeature.this.getAddCommand(from, to, value));
            }
            return result;
        }

        boolean handleRemove(SyncItem<M, EObject> from, SyncItem<M, EObject> to, Object value) {
            List<?> values = this.getContents(to.getBackend());
            boolean result = values.contains(value);
            if (result) {
                this.react(EObjectEAttributeSyncFeature.this.getRemoveCommand(from, to, value));
            }
            return result;
        }
    }
}

