/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.properties.modelelement;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.papyrus.infra.architecture.representation.PapyrusRepresentationKind;
import org.eclipse.papyrus.infra.emf.nattable.selection.EObjectSelectionExtractor;
import org.eclipse.papyrus.infra.nattable.contentprovider.ColumnAxisIdentifierContentProvider;
import org.eclipse.papyrus.infra.nattable.contentprovider.ColumnContainmentFeatureContentProvider;
import org.eclipse.papyrus.infra.nattable.contentprovider.ColumnElementTypeIdContentProvider;
import org.eclipse.papyrus.infra.nattable.contentprovider.ContextFeatureContentProvider;
import org.eclipse.papyrus.infra.nattable.contentprovider.RowAxisIdentifierContentProvider;
import org.eclipse.papyrus.infra.nattable.contentprovider.RowContainmentFeatureContentProvider;
import org.eclipse.papyrus.infra.nattable.contentprovider.RowElementTypeIdContentProvider;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.model.nattable.NattablePackage;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.AbstractHeaderAxisConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.NattableaxisconfigurationPackage;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablelabelprovider.ILabelProviderConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablelabelprovider.NattablelabelproviderPackage;
import org.eclipse.papyrus.infra.nattable.properties.observable.ColumnDisplayFilterHeaderObservableValue;
import org.eclipse.papyrus.infra.nattable.properties.observable.ColumnDisplayIndexHeaderObservableValue;
import org.eclipse.papyrus.infra.nattable.properties.observable.ColumnDisplayLabelHeaderObservableValue;
import org.eclipse.papyrus.infra.nattable.properties.observable.ColumnFeatureLabelDisplayIconObservableValue;
import org.eclipse.papyrus.infra.nattable.properties.observable.ColumnFeatureLabelDisplayIsDerivedObservableValue;
import org.eclipse.papyrus.infra.nattable.properties.observable.ColumnFeatureLabelDisplayLabelObservableValue;
import org.eclipse.papyrus.infra.nattable.properties.observable.ColumnFeatureLabelDisplayMultiplicityObservableValue;
import org.eclipse.papyrus.infra.nattable.properties.observable.ColumnFeatureLabelDisplayNameObservableValue;
import org.eclipse.papyrus.infra.nattable.properties.observable.ColumnFeatureLabelDisplayTypeObservableValue;
import org.eclipse.papyrus.infra.nattable.properties.observable.ColumnIndexHeaderStyleObservableValue;
import org.eclipse.papyrus.infra.nattable.properties.observable.ColumnObjectLabelDisplayIconObservableValue;
import org.eclipse.papyrus.infra.nattable.properties.observable.ColumnObjectLabelDisplayLabelObservableValue;
import org.eclipse.papyrus.infra.nattable.properties.observable.ColumnPasteEObjectAxisIdentifierObservableValue;
import org.eclipse.papyrus.infra.nattable.properties.observable.ColumnPasteEObjectContainmentFeatureObservableValue;
import org.eclipse.papyrus.infra.nattable.properties.observable.ColumnPasteEObjectElementTypeIdObservableValue;
import org.eclipse.papyrus.infra.nattable.properties.observable.ColumnPasteObjectDetachedModeObservableValue;
import org.eclipse.papyrus.infra.nattable.properties.observable.ColumnPasteObjectPostActionsObservableValue;
import org.eclipse.papyrus.infra.nattable.properties.observable.RowDisplayIndexHeaderObservableValue;
import org.eclipse.papyrus.infra.nattable.properties.observable.RowDisplayLabelHeaderObservableValue;
import org.eclipse.papyrus.infra.nattable.properties.observable.RowFeatureLabelDisplayIconObservableValue;
import org.eclipse.papyrus.infra.nattable.properties.observable.RowFeatureLabelDisplayIsDerivedObservableValue;
import org.eclipse.papyrus.infra.nattable.properties.observable.RowFeatureLabelDisplayLabelObservableValue;
import org.eclipse.papyrus.infra.nattable.properties.observable.RowFeatureLabelDisplayMultiplicityObservableValue;
import org.eclipse.papyrus.infra.nattable.properties.observable.RowFeatureLabelDisplayNameObservableValue;
import org.eclipse.papyrus.infra.nattable.properties.observable.RowFeatureLabelDisplayTypeObservableValue;
import org.eclipse.papyrus.infra.nattable.properties.observable.RowIndexHeaderStyleObservableValue;
import org.eclipse.papyrus.infra.nattable.properties.observable.RowObjectLabelDisplayIconObservableValue;
import org.eclipse.papyrus.infra.nattable.properties.observable.RowObjectLabelDisplayLabelObservableValue;
import org.eclipse.papyrus.infra.nattable.properties.observable.RowPasteEObjectAxisIdentifierObservableValue;
import org.eclipse.papyrus.infra.nattable.properties.observable.RowPasteEObjectContainmentFeatureObservableValue;
import org.eclipse.papyrus.infra.nattable.properties.observable.RowPasteEObjectElementTypeIdObservableValue;
import org.eclipse.papyrus.infra.nattable.properties.observable.RowPasteObjectDetachedModeObservableValue;
import org.eclipse.papyrus.infra.nattable.properties.observable.RowPasteObjectPostActionsObservableValue;
import org.eclipse.papyrus.infra.nattable.properties.observable.TableLabelObservableValue;
import org.eclipse.papyrus.infra.nattable.properties.provider.AxisIdentifierLabelProvider;
import org.eclipse.papyrus.infra.nattable.properties.provider.ColumnPostActionIdsProvider;
import org.eclipse.papyrus.infra.nattable.properties.provider.RowPostActionIdsProvider;
import org.eclipse.papyrus.infra.nattable.selection.ISelectionExtractor;
import org.eclipse.papyrus.infra.nattable.utils.HeaderAxisConfigurationManagementUtils;
import org.eclipse.papyrus.infra.nattable.utils.NattableModelManagerFactory;
import org.eclipse.papyrus.infra.properties.ui.modelelement.EMFModelElement;
import org.eclipse.papyrus.infra.viewpoints.policy.ViewPrototype;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class NatTableModelElement
extends EMFModelElement {
    private Adapter tableListener;
    private Collection<EStructuralFeature> interestingFeatures;
    private AbstractHeaderAxisConfiguration rowHeaderAxisConfiguration;
    private AbstractHeaderAxisConfiguration columnHeaderAxisConfiguration;
    private Collection<ILabelProviderConfiguration> columnLabelProviderConfigurations;
    private Collection<ILabelProviderConfiguration> rowLabelProviderConfigurations;
    private INattableModelManager tableModelManager;
    protected Table table;

    public NatTableModelElement(Table source, EditingDomain domain) {
        super((EObject)source, domain);
        this.table = source;
        this.init();
    }

    private void init() {
        this.tableModelManager = NattableModelManagerFactory.INSTANCE.createNatTableModelManager(this.getEditedTable(), (ISelectionExtractor)new EObjectSelectionExtractor(), false);
        this.interestingFeatures = new ArrayList<EStructuralFeature>();
        this.interestingFeatures.add((EStructuralFeature)NattablePackage.eINSTANCE.getTable_TableKindId());
        this.interestingFeatures.add((EStructuralFeature)NattablePackage.eINSTANCE.getTable_Owner());
        this.interestingFeatures.add((EStructuralFeature)NattablePackage.eINSTANCE.getTable_Context());
        this.interestingFeatures.add((EStructuralFeature)NattablePackage.eINSTANCE.getTable_InvertAxis());
        this.interestingFeatures.add((EStructuralFeature)NattablePackage.eINSTANCE.getTable_LocalColumnHeaderAxisConfiguration());
        this.interestingFeatures.add((EStructuralFeature)NattablePackage.eINSTANCE.getTable_LocalRowHeaderAxisConfiguration());
        this.interestingFeatures.add((EStructuralFeature)NattableaxisconfigurationPackage.eINSTANCE.getAbstractHeaderAxisConfiguration_DisplayFilter());
        this.interestingFeatures.add((EStructuralFeature)NattableaxisconfigurationPackage.eINSTANCE.getAbstractHeaderAxisConfiguration_DisplayIndex());
        this.interestingFeatures.add((EStructuralFeature)NattableaxisconfigurationPackage.eINSTANCE.getAbstractHeaderAxisConfiguration_DisplayLabel());
        this.interestingFeatures.add((EStructuralFeature)NattableaxisconfigurationPackage.eINSTANCE.getAbstractHeaderAxisConfiguration_IndexStyle());
        this.interestingFeatures.add((EStructuralFeature)NattablelabelproviderPackage.eINSTANCE.getFeatureLabelProviderConfiguration_DisplayIsDerived());
        this.interestingFeatures.add((EStructuralFeature)NattablelabelproviderPackage.eINSTANCE.getFeatureLabelProviderConfiguration_DisplayMultiplicity());
        this.interestingFeatures.add((EStructuralFeature)NattablelabelproviderPackage.eINSTANCE.getFeatureLabelProviderConfiguration_DisplayName());
        this.interestingFeatures.add((EStructuralFeature)NattablelabelproviderPackage.eINSTANCE.getFeatureLabelProviderConfiguration_DisplayType());
        this.interestingFeatures.add((EStructuralFeature)NattablelabelproviderPackage.eINSTANCE.getObjectLabelProviderConfiguration_DisplayIcon());
        this.interestingFeatures.add((EStructuralFeature)NattablelabelproviderPackage.eINSTANCE.getObjectLabelProviderConfiguration_DisplayLabel());
        if (this.table != null) {
            this.tableListener = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    if (NatTableModelElement.this.interestingFeatures.contains(msg.getFeature())) {
                        NatTableModelElement.this.updateValues();
                    }
                }
            };
            this.table.eAdapters().add((Object)this.tableListener);
            this.initOtherFieldsAndAddOthersListeners();
        }
    }

    private void initOtherFieldsAndAddOthersListeners() {
        this.columnHeaderAxisConfiguration = HeaderAxisConfigurationManagementUtils.getColumnAbstractHeaderAxisInTable((Table)this.getEditedTable());
        this.rowHeaderAxisConfiguration = HeaderAxisConfigurationManagementUtils.getRowAbstractHeaderAxisInTable((Table)this.getEditedTable());
        if (this.columnHeaderAxisConfiguration != null) {
            this.columnHeaderAxisConfiguration.eAdapters().add((Object)this.tableListener);
        }
        if (this.columnHeaderAxisConfiguration != null) {
            this.columnLabelProviderConfigurations = this.columnHeaderAxisConfiguration.getOwnedLabelConfigurations();
        }
        if (this.columnLabelProviderConfigurations != null) {
            for (ILabelProviderConfiguration conf : this.columnLabelProviderConfigurations) {
                conf.eAdapters().add((Object)this.tableListener);
            }
        }
        if (this.rowHeaderAxisConfiguration != null) {
            this.rowHeaderAxisConfiguration.eAdapters().add((Object)this.tableListener);
        }
        if (this.rowHeaderAxisConfiguration != null) {
            this.rowLabelProviderConfigurations = this.rowHeaderAxisConfiguration.getOwnedLabelConfigurations();
        }
        if (this.rowLabelProviderConfigurations != null) {
            for (ILabelProviderConfiguration conf : this.rowLabelProviderConfigurations) {
                conf.eAdapters().add((Object)this.tableListener);
            }
        }
    }

    private void removeListeners() {
        if (this.columnHeaderAxisConfiguration != null) {
            this.columnHeaderAxisConfiguration.eAdapters().remove((Object)this.tableListener);
        }
        if (this.columnLabelProviderConfigurations != null) {
            for (ILabelProviderConfiguration conf : this.columnLabelProviderConfigurations) {
                conf.eAdapters().remove((Object)this.tableListener);
            }
        }
        if (this.rowHeaderAxisConfiguration != null) {
            this.rowHeaderAxisConfiguration.eAdapters().remove((Object)this.tableListener);
        }
        if (this.rowLabelProviderConfigurations != null) {
            for (ILabelProviderConfiguration conf : this.rowLabelProviderConfigurations) {
                conf.eAdapters().remove((Object)this.tableListener);
            }
        }
    }

    private void updateValues() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                NatTableModelElement.this.removeListeners();
                NatTableModelElement.this.initOtherFieldsAndAddOthersListeners();
                Event event = new Event();
                for (IObservable current : NatTableModelElement.this.getObservables().values()) {
                    if (current.isDisposed() || !(current instanceof Listener)) continue;
                    ((Listener)current).handleEvent(event);
                }
            }
        });
    }

    public void dispose() {
        super.dispose();
        if (this.table != null) {
            this.table.eAdapters().remove((Object)this.tableListener);
            this.removeListeners();
            this.table = null;
        }
        this.columnLabelProviderConfigurations = null;
        this.rowLabelProviderConfigurations = null;
        this.tableModelManager.dispose();
        this.tableModelManager = null;
    }

    private Table getEditedTable() {
        return this.table;
    }

    protected IObservable doGetObservable(String propertyPath) {
        Object value = null;
        Table table = this.getEditedTable();
        if ("localColumnHeaderAxisConfiguration.displayFilter".equals(propertyPath)) {
            value = new ColumnDisplayFilterHeaderObservableValue(table);
        } else if ("localColumnHeaderAxisConfiguration.displayIndex".equals(propertyPath)) {
            value = new ColumnDisplayIndexHeaderObservableValue(table);
        } else if ("localColumnHeaderAxisConfiguration.displayLabel".equals(propertyPath)) {
            value = new ColumnDisplayLabelHeaderObservableValue(table);
        } else if ("localColumnHeaderAxisConfiguration.indexStyle".equals(propertyPath)) {
            value = new ColumnIndexHeaderStyleObservableValue(table);
        } else if ("localRowHeaderAxisConfiguration.displayIndex".equals(propertyPath)) {
            value = new RowDisplayIndexHeaderObservableValue(table);
        } else if ("localRowHeaderAxisConfiguration.displayLabel".equals(propertyPath)) {
            value = new RowDisplayLabelHeaderObservableValue(table);
        } else if ("localRowHeaderAxisConfiguration.indexStyle".equals(propertyPath)) {
            value = new RowIndexHeaderStyleObservableValue(table);
        } else if ("columnFeatureLabelProviderConfigurationDisplayIcon".equals(propertyPath)) {
            value = new ColumnFeatureLabelDisplayIconObservableValue(table);
        } else if ("columnFeatureLabelProviderConfigurationDisplayLabel".equals(propertyPath)) {
            value = new ColumnFeatureLabelDisplayLabelObservableValue(table);
        } else if ("columnFeatureLabelProviderConfigurationDisplayIsDerived".equals(propertyPath)) {
            value = new ColumnFeatureLabelDisplayIsDerivedObservableValue(table);
        } else if ("columnFeatureLabelProviderConfigurationDisplayName".equals(propertyPath)) {
            value = new ColumnFeatureLabelDisplayNameObservableValue(table);
        } else if ("columnFeatureLabelProviderConfigurationDisplayType".equals(propertyPath)) {
            value = new ColumnFeatureLabelDisplayTypeObservableValue(table);
        } else if ("columnFeatureLabelProviderConfigurationDisplayMultiplicity".equals(propertyPath)) {
            value = new ColumnFeatureLabelDisplayMultiplicityObservableValue(table);
        } else if ("columnObjectLabelProviderConfigurationDisplayIcon".equals(propertyPath)) {
            value = new ColumnObjectLabelDisplayIconObservableValue(table);
        } else if ("columnObjectLabelProviderConfigurationDisplayLabel".equals(propertyPath)) {
            value = new ColumnObjectLabelDisplayLabelObservableValue(table);
        } else if ("rowFeatureLabelProviderConfigurationDisplayIcon".equals(propertyPath)) {
            value = new RowFeatureLabelDisplayIconObservableValue(table);
        } else if ("rowFeatureLabelProviderConfigurationDisplayLabel".equals(propertyPath)) {
            value = new RowFeatureLabelDisplayLabelObservableValue(table);
        } else if ("rowFeatureLabelProviderConfigurationDisplayIsDerived".equals(propertyPath)) {
            value = new RowFeatureLabelDisplayIsDerivedObservableValue(table);
        } else if ("rowFeatureLabelProviderConfigurationDisplayName".equals(propertyPath)) {
            value = new RowFeatureLabelDisplayNameObservableValue(table);
        } else if ("rowFeatureLabelProviderConfigurationDisplayType".equals(propertyPath)) {
            value = new RowFeatureLabelDisplayTypeObservableValue(table);
        } else if ("rowFeatureLabelProviderConfigurationDisplayMultiplicity".equals(propertyPath)) {
            value = new RowFeatureLabelDisplayMultiplicityObservableValue(table);
        } else if ("rowObjectLabelProviderConfigurationDisplayIcon".equals(propertyPath)) {
            value = new RowObjectLabelDisplayIconObservableValue(table);
        } else if ("rowObjectLabelProviderConfigurationDisplayLabel".equals(propertyPath)) {
            value = new RowObjectLabelDisplayLabelObservableValue(table);
        } else if ("localRowHeaderAxisConfiguration.pastedEObjectContainmentFeature".equals(propertyPath)) {
            value = new RowPasteEObjectContainmentFeatureObservableValue(table);
        } else if ("localRowHeaderAxisConfiguration.pastedEObjectId".equals(propertyPath)) {
            value = new RowPasteEObjectElementTypeIdObservableValue(table);
        } else if ("localRowHeaderAxisConfiguration.detachedMode".equals(propertyPath)) {
            value = new RowPasteObjectDetachedModeObservableValue(this.getEditedTable());
        } else if ("localRowHeaderAxisConfiguration.postActions".equals(propertyPath)) {
            value = new RowPasteObjectPostActionsObservableValue(this.getDomain(), this.getEditedTable());
        } else if ("localRowHeaderAxisConfiguration.axisIdentifier".equals(propertyPath)) {
            value = new RowPasteEObjectAxisIdentifierObservableValue(table);
        } else if ("localColumnHeaderAxisConfiguration.pastedEObjectContainmentFeature".equals(propertyPath)) {
            value = new ColumnPasteEObjectContainmentFeatureObservableValue(table);
        } else if ("localColumnHeaderAxisConfiguration.pastedEObjectId".equals(propertyPath)) {
            value = new ColumnPasteEObjectElementTypeIdObservableValue(table);
        } else if ("localColumnHeaderAxisConfiguration.detachedMode".equals(propertyPath)) {
            value = new ColumnPasteObjectDetachedModeObservableValue(this.getEditedTable());
        } else if ("localColumnHeaderAxisConfiguration.postActions".equals(propertyPath)) {
            value = new ColumnPasteObjectPostActionsObservableValue(this.getDomain(), this.getEditedTable());
        } else if ("localColumnHeaderAxisConfiguration.axisIdentifier".equals(propertyPath)) {
            value = new ColumnPasteEObjectAxisIdentifierObservableValue(table);
        } else if ("label".equals(propertyPath)) {
            value = new TableLabelObservableValue(table);
        }
        if (value != null) {
            return value;
        }
        return super.doGetObservable(propertyPath);
    }

    protected boolean isFeatureEditable(String propertyPath) {
        boolean res = super.isFeatureEditable(propertyPath);
        if (!res) {
            if ("columnFeatureLabelProviderConfigurationDisplayIcon".equals(propertyPath)) {
                res = true;
            } else if ("columnFeatureLabelProviderConfigurationDisplayLabel".equals(propertyPath)) {
                res = true;
            } else if ("columnFeatureLabelProviderConfigurationDisplayIsDerived".equals(propertyPath)) {
                res = true;
            } else if ("columnFeatureLabelProviderConfigurationDisplayName".equals(propertyPath)) {
                res = true;
            } else if ("columnFeatureLabelProviderConfigurationDisplayType".equals(propertyPath)) {
                res = true;
            } else if ("columnFeatureLabelProviderConfigurationDisplayMultiplicity".equals(propertyPath)) {
                res = true;
            } else if ("columnObjectLabelProviderConfigurationDisplayIcon".equals(propertyPath)) {
                res = true;
            } else if ("columnObjectLabelProviderConfigurationDisplayLabel".equals(propertyPath)) {
                res = true;
            } else if ("rowFeatureLabelProviderConfigurationDisplayIcon".equals(propertyPath)) {
                res = true;
            } else if ("rowFeatureLabelProviderConfigurationDisplayLabel".equals(propertyPath)) {
                res = true;
            } else if ("rowFeatureLabelProviderConfigurationDisplayIsDerived".equals(propertyPath)) {
                res = true;
            } else if ("rowFeatureLabelProviderConfigurationDisplayName".equals(propertyPath)) {
                res = true;
            } else if ("rowFeatureLabelProviderConfigurationDisplayType".equals(propertyPath)) {
                res = true;
            } else if ("rowFeatureLabelProviderConfigurationDisplayMultiplicity".equals(propertyPath)) {
                res = true;
            } else if ("rowObjectLabelProviderConfigurationDisplayIcon".equals(propertyPath)) {
                res = true;
            } else if ("rowObjectLabelProviderConfigurationDisplayLabel".equals(propertyPath)) {
                res = true;
            } else if ("localRowHeaderAxisConfiguration.pastedEObjectContainmentFeature".equals(propertyPath)) {
                res = new RowContainmentFeatureContentProvider(this.getEditedTable(), this.getEditedTable().getContext().eClass()).getElements().length != 0;
            } else if ("localRowHeaderAxisConfiguration.pastedEObjectId".equals(propertyPath)) {
                res = new RowElementTypeIdContentProvider(this.tableModelManager).getElements().length != 0;
            } else if ("localRowHeaderAxisConfiguration.detachedMode".equals(propertyPath)) {
                res = true;
            } else if ("localRowHeaderAxisConfiguration.postActions".equals(propertyPath)) {
                res = new RowPostActionIdsProvider(this.tableModelManager).getElements().length != 0;
            } else if ("localRowHeaderAxisConfiguration.axisIdentifier".equals(propertyPath)) {
                res = new RowAxisIdentifierContentProvider(this.tableModelManager).getElements().length != 0;
            } else if ("localColumnHeaderAxisConfiguration.pastedEObjectContainmentFeature".equals(propertyPath)) {
                res = new ColumnContainmentFeatureContentProvider(this.getEditedTable(), this.getEditedTable().getContext().eClass()).getElements().length != 0;
            } else if ("localColumnHeaderAxisConfiguration.pastedEObjectId".equals(propertyPath)) {
                res = new ColumnElementTypeIdContentProvider(this.tableModelManager).getElements().length != 0;
            } else if ("localColumnHeaderAxisConfiguration.detachedMode".equals(propertyPath)) {
                res = true;
            } else if ("localColumnHeaderAxisConfiguration.postActions".equals(propertyPath)) {
                res = new ColumnPostActionIdsProvider(this.tableModelManager).getElements().length != 0;
            } else if ("localColumnHeaderAxisConfiguration.axisIdentifier".equals(propertyPath)) {
                res = new ColumnAxisIdentifierContentProvider(this.tableModelManager).getElements().length != 0;
            } else if ("label".equals(propertyPath)) {
                res = true;
            }
        }
        return res;
    }

    public IStaticContentProvider getContentProvider(String propertyPath) {
        Object provider = null;
        if ("context".equals(propertyPath)) {
            Table table = this.getEditedTable();
            provider = new ContextFeatureContentProvider(table, this.getRoot(table.getContext()));
        } else if ("owner".equals(propertyPath)) {
            Table table = this.getEditedTable();
            provider = new ContextFeatureContentProvider(table, this.getRoot(table.getOwner()));
        } else if ("localRowHeaderAxisConfiguration.pastedEObjectContainmentFeature".equals(propertyPath)) {
            provider = new RowContainmentFeatureContentProvider(this.getEditedTable(), this.getEditedTable().getContext().eClass());
        } else if ("localColumnHeaderAxisConfiguration.pastedEObjectContainmentFeature".equals(propertyPath)) {
            provider = new ColumnContainmentFeatureContentProvider(this.getEditedTable(), this.getEditedTable().getContext().eClass());
        } else if ("localRowHeaderAxisConfiguration.pastedEObjectId".equals(propertyPath)) {
            provider = new RowElementTypeIdContentProvider(this.tableModelManager);
        } else if ("localColumnHeaderAxisConfiguration.pastedEObjectId".equals(propertyPath)) {
            provider = new ColumnElementTypeIdContentProvider(this.tableModelManager);
        } else if ("localRowHeaderAxisConfiguration.postActions".equals(propertyPath)) {
            provider = new RowPostActionIdsProvider(this.tableModelManager);
        } else if ("localColumnHeaderAxisConfiguration.postActions".equals(propertyPath)) {
            provider = new RowPostActionIdsProvider(this.tableModelManager);
        } else if ("localRowHeaderAxisConfiguration.axisIdentifier".equals(propertyPath)) {
            provider = new RowAxisIdentifierContentProvider(this.tableModelManager);
        } else if ("localColumnHeaderAxisConfiguration.axisIdentifier".equals(propertyPath)) {
            provider = new ColumnAxisIdentifierContentProvider(this.tableModelManager);
        }
        if (provider != null) {
            return provider;
        }
        return super.getContentProvider(propertyPath);
    }

    public boolean isUnique(String propertyPath) {
        if ("localRowHeaderAxisConfiguration.postActions".equals(propertyPath)) {
            return true;
        }
        if ("localColumnHeaderAxisConfiguration.postActions".equals(propertyPath)) {
            return true;
        }
        return super.isUnique(propertyPath);
    }

    public boolean isOrdered(String propertyPath) {
        if ("localRowHeaderAxisConfiguration.postActions".equals(propertyPath)) {
            return true;
        }
        if ("localColumnHeaderAxisConfiguration.postActions".equals(propertyPath)) {
            return true;
        }
        return super.isOrdered(propertyPath);
    }

    public ILabelProvider getLabelProvider(String propertyPath) {
        Object provider = null;
        if (propertyPath.endsWith("prototype")) {
            provider = new ILabelProvider(){

                public void addListener(ILabelProviderListener listener) {
                }

                public void removeListener(ILabelProviderListener listener) {
                }

                public void dispose() {
                }

                public boolean isLabelProperty(Object element, String property) {
                    return false;
                }

                public Image getImage(Object element) {
                    if (!(element instanceof PapyrusRepresentationKind)) {
                        return null;
                    }
                    ViewPrototype proto = ViewPrototype.get((PapyrusRepresentationKind)((PapyrusRepresentationKind)element));
                    return proto.getIcon();
                }

                public String getText(Object element) {
                    if (!(element instanceof PapyrusRepresentationKind)) {
                        return null;
                    }
                    ViewPrototype proto = ViewPrototype.get((PapyrusRepresentationKind)((PapyrusRepresentationKind)element));
                    return proto.getQualifiedName();
                }
            };
        }
        if ("localColumnHeaderAxisConfiguration.axisIdentifier".equals(propertyPath) || "localRowHeaderAxisConfiguration.axisIdentifier".equals(propertyPath)) {
            provider = new AxisIdentifierLabelProvider(this.tableModelManager);
        }
        if (provider == null) {
            provider = super.getLabelProvider(propertyPath);
        }
        return provider;
    }

    private EObject getRoot(EObject obj) {
        EObject current = obj;
        EObject parent = obj.eContainer();
        while (parent != null) {
            current = parent;
            parent = parent.eContainer();
        }
        return current;
    }
}

