/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.properties.modelelement;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.infra.core.sasheditor.editor.IMultiPageEditorPart;
import org.eclipse.papyrus.infra.nattable.common.editor.NatTableEditor;
import org.eclipse.papyrus.infra.nattable.properties.modelelement.NatTableFactory;
import org.eclipse.papyrus.infra.nattable.properties.modelelement.NatTableModelElement;
import org.eclipse.papyrus.infra.properties.contexts.DataContextElement;
import org.eclipse.papyrus.infra.properties.ui.modelelement.EMFModelElement;
import org.eclipse.papyrus.infra.ui.util.EditorHelper;
import org.eclipse.ui.IEditorPart;

public class EObjectInNatTableFactory
extends NatTableFactory {
    @Override
    protected EMFModelElement doCreateFromSource(Object sourceElement, DataContextElement context) {
        EMFModelElement result = null;
        NatTableEditor nattableEditor = this.getCurrentNatTableEditor();
        if (nattableEditor != null) {
            TransactionalEditingDomain domain = nattableEditor.getTableEditingDomain();
            result = new NatTableModelElement(nattableEditor.getTable(), (EditingDomain)domain);
        } else {
            result = super.doCreateFromSource(sourceElement, context);
        }
        return result;
    }

    @Override
    protected void updateModelElement(EMFModelElement modelElement, Object newSourceElement) {
        NatTableEditor nattableEditor = this.getCurrentNatTableEditor();
        if (nattableEditor != null) {
            if (modelElement instanceof NatTableModelElement) {
                EObjectInNatTableFactory.updateTableModelElement((NatTableModelElement)modelElement, nattableEditor.getTable());
            }
            EObjectInNatTableFactory.updateEMFModelElement((EMFModelElement)modelElement, (EObject)nattableEditor.getTable());
        } else {
            super.updateModelElement(modelElement, newSourceElement);
        }
    }

    protected NatTableEditor getCurrentNatTableEditor() {
        NatTableEditor result = null;
        IEditorPart currentEditor = EditorHelper.getCurrentEditor();
        if (currentEditor instanceof IMultiPageEditorPart) {
            result = (NatTableEditor)((IMultiPageEditorPart)currentEditor).getActiveEditor().getAdapter(NatTableEditor.class);
        } else if (currentEditor instanceof IAdaptable) {
            result = (NatTableEditor)currentEditor.getAdapter(NatTableEditor.class);
        }
        return result;
    }
}

