/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.editor.xml.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.InputLocation;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginManagement;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.m2e.core.internal.Messages;
import org.eclipse.m2e.core.internal.markers.IEditorMarkerService;
import org.eclipse.m2e.core.internal.markers.IMarkerLocationService;
import org.eclipse.m2e.core.internal.markers.IMavenMarkerManager;
import org.eclipse.m2e.core.internal.preferences.ProblemSeverity;
import org.eclipse.m2e.core.ui.internal.M2EUIPluginActivator;
import org.eclipse.m2e.core.ui.internal.editing.PomEdits;
import org.eclipse.m2e.editor.xml.internal.NodeOperation;
import org.eclipse.m2e.editor.xml.internal.XmlUtils;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.xml.core.internal.parser.regions.TagNameRegion;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Comment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MarkerLocationService
implements IMarkerLocationService,
IEditorMarkerService {
    private static final Logger log = LoggerFactory.getLogger(MarkerLocationService.class);
    private static final String XSI_SCHEMA_LOCATION = "xsi:schemaLocation";
    private static final String PROJECT_NODE = "project";
    private static final String OFFSET = "offset";

    public void findLocationForMarker(IMarker marker) {
        IDOMModel domModel = null;
        try {
            Integer lineNumber = (Integer)marker.getAttribute("lineNumber");
            if (lineNumber == null) {
                return;
            }
            Integer columnStart = (Integer)marker.getAttribute("columnStart");
            if (columnStart == null) {
                return;
            }
            Integer columnEnd = (Integer)marker.getAttribute("columnEnd");
            if (columnEnd == null) {
                return;
            }
            try {
                int charEnd;
                IFile resource = (IFile)marker.getResource();
                domModel = (IDOMModel)StructuredModelManager.getModelManager().getModelForRead(resource);
                if (domModel == null) {
                    throw new IllegalArgumentException("Document is not structured: " + resource);
                }
                IStructuredDocument document = domModel.getStructuredDocument();
                int charStart = document.getLineOffset(lineNumber - 1) + columnStart - 1;
                marker.setAttribute("charStart", charStart);
                if (columnEnd > columnStart) {
                    charEnd = document.getLineOffset(lineNumber - 1) + columnEnd;
                } else {
                    IRegion line = document.getLineInformation(lineNumber - 1);
                    charEnd = line.getOffset() + line.getLength();
                }
                marker.setAttribute("charEnd", charEnd);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        finally {
            if (domModel != null) {
                domModel.releaseFromRead();
            }
        }
    }

    public void findLocationForMarker_(final IMarker marker) {
        String hint = marker.getAttribute("editor_hint", null);
        if ("not_covered_mojo_execution".equals(hint)) {
            try {
                boolean lookInPM = false;
                final String groupId = marker.getAttribute("groupId", "");
                final String artifactId = marker.getAttribute("artifactId", "");
                final String exec = marker.getAttribute("executionId", "");
                final String goal = marker.getAttribute("goal", "");
                XmlUtils.performOnRootElement((IFile)marker.getResource(), new NodeOperation<Element>(){

                    @Override
                    public void process(Element root, IStructuredDocument structuredDocument) {
                        Element build = PomEdits.findChild((Element)root, (String)"build");
                        ArrayList<Element> candidates = new ArrayList<Element>();
                        Element plugin = this.findPlugin(build, groupId, artifactId);
                        if (plugin != null) {
                            candidates.add(plugin);
                        }
                        List profiles = PomEdits.findChilds((Element)PomEdits.findChild((Element)root, (String)"profiles"), (String)"profile");
                        for (Element profile : profiles) {
                            Element profBuild = PomEdits.findChild((Element)profile, (String)"build");
                            plugin = this.findPlugin(profBuild, groupId, artifactId);
                            if (plugin == null) continue;
                            candidates.add(plugin);
                        }
                        Element ourMarkerPlacement = null;
                        for (Element candid : candidates) {
                            PomEdits.Matcher match = exec.equals("default") ? PomEdits.childMissingOrEqual((String)"id", (String)"default") : PomEdits.childEquals((String)"id", (String)exec);
                            Element execution = PomEdits.findChild((Element)PomEdits.findChild((Element)candid, (String)"executions"), (String)"execution", (PomEdits.Matcher[])new PomEdits.Matcher[]{match});
                            if (execution == null) continue;
                            Element goalEl = PomEdits.findChild((Element)PomEdits.findChild((Element)execution, (String)"goals"), (String)"goal", (PomEdits.Matcher[])new PomEdits.Matcher[]{PomEdits.textEquals((String)goal)});
                            if (goalEl != null) {
                                ourMarkerPlacement = goalEl;
                                break;
                            }
                            if (ourMarkerPlacement != null || (ourMarkerPlacement = PomEdits.findChild((Element)execution, (String)"id")) != null) continue;
                            ourMarkerPlacement = execution;
                        }
                        if (ourMarkerPlacement == null) {
                            plugin = candidates.size() > 0 ? (Element)candidates.get(0) : null;
                            ourMarkerPlacement = PomEdits.findChild((Element)plugin, (String)"artifactId");
                            ourMarkerPlacement = ourMarkerPlacement == null && plugin != null ? plugin : (build != null ? build : root);
                        }
                        MarkerLocationService.this.annotateMarker(marker, structuredDocument, ourMarkerPlacement);
                    }

                    private Element findPlugin(Element build, String groupId2, String artifactId2) {
                        PomEdits.Matcher grIdmatch = groupId2.equals("org.apache.maven.plugins") ? PomEdits.childMissingOrEqual((String)"groupId", (String)groupId2) : PomEdits.childEquals((String)"groupId", (String)groupId2);
                        return PomEdits.findChild((Element)PomEdits.findChild((Element)build, (String)"plugins"), (String)"plugin", (PomEdits.Matcher[])new PomEdits.Matcher[]{grIdmatch, PomEdits.childEquals((String)"artifactId", (String)artifactId2)});
                    }
                });
            }
            catch (IOException e) {
                log.error("Error locating marker", (Throwable)e);
            }
            catch (CoreException e) {
                log.error("Error locating marker", (Throwable)e);
            }
        }
    }

    private void annotateMarker(IMarker marker, IStructuredDocument structuredDocument, Element ourMarkerPlacement) {
        if (ourMarkerPlacement instanceof IndexedRegion) {
            IndexedRegion region = (IndexedRegion)ourMarkerPlacement;
            try {
                marker.setAttribute("charStart", region.getStartOffset());
                try {
                    IRegion line = structuredDocument.getLineInformationOfOffset(region.getStartOffset());
                    int end = Math.min(region.getEndOffset(), line.getOffset() + line.getLength());
                    marker.setAttribute("charEnd", end);
                }
                catch (BadLocationException e) {
                    marker.setAttribute("charEnd", region.getStartOffset() + region.getLength());
                }
                marker.setAttribute("lineNumber", structuredDocument.getLineOfOffset(region.getStartOffset()) + 1);
            }
            catch (CoreException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void addEditorHintMarkers(IMavenMarkerManager markerManager, IFile pom, MavenProject mavenProject, String type) {
        MarkerLocationService.checkForSchema(markerManager, (IResource)pom, type);
        MarkerLocationService.checkVarious(markerManager, (IResource)pom, mavenProject, type);
    }

    static void checkForSchema(IMavenMarkerManager mavenMarkerManager, IResource pomFile, String type) {
        block13: {
            IDOMModel domModel = null;
            try {
                if (!(pomFile instanceof IFile)) {
                    return;
                }
                try {
                    domModel = (IDOMModel)StructuredModelManager.getModelManager().getModelForRead((IFile)pomFile);
                    IStructuredDocument document = domModel.getStructuredDocument();
                    IStructuredDocumentRegion[] iStructuredDocumentRegionArray = document.getStructuredDocumentRegions();
                    int n = iStructuredDocumentRegionArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IStructuredDocumentRegion documentRegion = iStructuredDocumentRegionArray[n2];
                        if ("XML_TAG_NAME".equals(documentRegion.getType())) {
                            ITextRegion[] iTextRegionArray = documentRegion.getRegions().toArray();
                            int n3 = iTextRegionArray.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                ITextRegion textRegion = iTextRegionArray[n4];
                                if (textRegion instanceof TagNameRegion && PROJECT_NODE.equals(documentRegion.getText(textRegion))) {
                                    int offset;
                                    int lineNumber;
                                    IMarker marker;
                                    if (documentRegion.getText().lastIndexOf(XSI_SCHEMA_LOCATION) == -1 && (marker = mavenMarkerManager.addMarker(pomFile, type, Messages.MavenMarkerManager_error_noschema, lineNumber = document.getLineOfOffset(offset = documentRegion.getStartOffset()) + 1, 1)) != null) {
                                        marker.setAttribute(OFFSET, offset);
                                        marker.setAttribute("editor_hint", (Object)"missing_schema");
                                        marker.setAttribute("charStart", documentRegion.getStartOffset());
                                        marker.setAttribute("charEnd", documentRegion.getEndOffset());
                                        marker.setAttribute("problemType", (Object)"pomhint");
                                    }
                                    break block13;
                                }
                                ++n4;
                            }
                        }
                        ++n2;
                    }
                }
                catch (Exception ex) {
                    log.error("Error checking for schema", (Throwable)ex);
                }
            }
            finally {
                if (domModel != null) {
                    domModel.releaseFromRead();
                }
            }
        }
    }

    private static void checkManagedDependencies(IMavenMarkerManager mavenMarkerManager, Element root, IResource pomFile, MavenProject mavenproject, String type, IStructuredDocument document) throws CoreException {
        List deps;
        ProblemSeverity overridingManagedVersionSeverity = MarkerLocationService.getOverridingManagedVersionSeverity();
        if (ProblemSeverity.ignore.equals((Object)overridingManagedVersionSeverity)) {
            return;
        }
        ArrayList<Element> candidates = new ArrayList<Element>();
        Element dependencies = PomEdits.findChild((Element)root, (String)"dependencies");
        if (dependencies != null) {
            for (Element el : PomEdits.findChilds((Element)dependencies, (String)"dependency")) {
                Element version = PomEdits.findChild((Element)el, (String)"version");
                if (version == null) continue;
                candidates.add(el);
            }
        }
        String currentProjectKey = String.valueOf(mavenproject.getGroupId()) + ":" + mavenproject.getArtifactId() + ":" + mavenproject.getVersion();
        List activeprofiles = (List)mavenproject.getInjectedProfileIds().get(currentProjectKey);
        HashMap<Element, String> candidateProfile = new HashMap<Element, String>();
        Element profiles = PomEdits.findChild((Element)root, (String)"profiles");
        if (profiles != null) {
            for (Element profile : PomEdits.findChilds((Element)profiles, (String)"profile")) {
                String idString = PomEdits.getTextValue((Node)PomEdits.findChild((Element)profile, (String)"id"));
                if (idString == null || !activeprofiles.contains(idString) || (dependencies = PomEdits.findChild((Element)profile, (String)"dependencies")) == null) continue;
                for (Element el : PomEdits.findChilds((Element)dependencies, (String)"dependency")) {
                    Element version = PomEdits.findChild((Element)el, (String)"version");
                    if (version == null) continue;
                    candidates.add(el);
                    candidateProfile.put(el, idString);
                }
            }
        }
        HashMap<String, String> managed = new HashMap<String, String>();
        DependencyManagement dm = mavenproject.getDependencyManagement();
        if (dm != null && (deps = dm.getDependencies()) != null) {
            for (Dependency dep : deps) {
                if (dep.getVersion() == null) continue;
                managed.put(dep.getManagementKey(), dep.getVersion());
            }
        }
        for (Element dep : candidates) {
            IndexedRegion off;
            String classifier;
            String typeString;
            String id;
            Element version = PomEdits.findChild((Element)dep, (String)"version");
            String grpString = PomEdits.getTextValue((Node)PomEdits.findChild((Element)dep, (String)"groupId"));
            String artString = PomEdits.getTextValue((Node)PomEdits.findChild((Element)dep, (String)"artifactId"));
            String versionString = PomEdits.getTextValue((Node)version);
            if (grpString == null || artString == null || versionString == null || !managed.containsKey(id = MarkerLocationService.getDependencyKey(grpString, artString, typeString = PomEdits.getTextValue((Node)PomEdits.findChild((Element)dep, (String)"type")), classifier = PomEdits.getTextValue((Node)PomEdits.findChild((Element)dep, (String)"classifier"))))) continue;
            String managedVersion = (String)managed.get(id);
            if (!(version instanceof IndexedRegion) || MarkerLocationService.lookForIgnoreMarker(document, version, off = (IndexedRegion)version, "$NO-MVN-MAN-VER$")) continue;
            String msg = versionString.equals(managedVersion) ? Messages.MavenMarkerManager_redundant_managed_title : Messages.MavenMarkerManager_managed_title;
            IMarker mark = mavenMarkerManager.addMarker(pomFile, type, NLS.bind((String)msg, (Object)managedVersion, (Object)artString), document.getLineOfOffset(off.getStartOffset()) + 1, overridingManagedVersionSeverity.getSeverity());
            mark.setAttribute("editor_hint", (Object)"managed_dependency_override");
            mark.setAttribute("charStart", off.getStartOffset());
            mark.setAttribute("charEnd", off.getEndOffset());
            mark.setAttribute("problemType", (Object)"pomhint");
            mark.setAttribute("groupId", (Object)grpString);
            mark.setAttribute("artifactId", (Object)artString);
            String profile = (String)candidateProfile.get(dep);
            if (profile == null) continue;
            mark.setAttribute("profile", (Object)profile);
        }
    }

    private static String getDependencyKey(String groupId, String artifactId, String type, String classifier) {
        StringBuilder key = new StringBuilder(groupId).append(":").append(artifactId).append(":").append(type == null ? "jar" : type);
        if (classifier != null) {
            key.append(":").append(classifier);
        }
        return key.toString();
    }

    private static void checkManagedPlugins(IMavenMarkerManager mavenMarkerManager, Element root, IResource pomFile, MavenProject mavenproject, String type, IStructuredDocument document) throws CoreException {
        List plgs;
        ProblemSeverity overridingManagedVersionSeverity = MarkerLocationService.getOverridingManagedVersionSeverity();
        if (ProblemSeverity.ignore.equals((Object)overridingManagedVersionSeverity)) {
            return;
        }
        ArrayList<Element> candidates = new ArrayList<Element>();
        Element build = PomEdits.findChild((Element)root, (String)"build");
        if (build == null) {
            return;
        }
        Element plugins = PomEdits.findChild((Element)build, (String)"plugins");
        if (plugins != null) {
            for (Element el : PomEdits.findChilds((Element)plugins, (String)"plugin")) {
                Element version = PomEdits.findChild((Element)el, (String)"version");
                if (version == null) continue;
                candidates.add(el);
            }
        }
        String currentProjectKey = String.valueOf(mavenproject.getGroupId()) + ":" + mavenproject.getArtifactId() + ":" + mavenproject.getVersion();
        List activeprofiles = (List)mavenproject.getInjectedProfileIds().get(currentProjectKey);
        HashMap<Element, String> candidateProfile = new HashMap<Element, String>();
        Element profiles = PomEdits.findChild((Element)root, (String)"profiles");
        if (profiles != null) {
            for (Element profile : PomEdits.findChilds((Element)profiles, (String)"profile")) {
                String idString = PomEdits.getTextValue((Node)PomEdits.findChild((Element)profile, (String)"id"));
                if (idString == null || !activeprofiles.contains(idString) || (build = PomEdits.findChild((Element)profile, (String)"build")) == null || (plugins = PomEdits.findChild((Element)build, (String)"plugins")) == null) continue;
                for (Element el : PomEdits.findChilds((Element)plugins, (String)"plugin")) {
                    Element version = PomEdits.findChild((Element)el, (String)"version");
                    if (version == null) continue;
                    candidates.add(el);
                    candidateProfile.put(el, idString);
                }
            }
        }
        HashMap<String, String> managed = new HashMap<String, String>();
        PluginManagement pm = mavenproject.getPluginManagement();
        if (pm != null && (plgs = pm.getPlugins()) != null) {
            for (Plugin plg : plgs) {
                InputLocation loc = plg.getLocation((Object)"version");
                if (loc == null) continue;
                managed.put(plg.getKey(), plg.getVersion());
            }
        }
        for (Element dep : candidates) {
            IndexedRegion off;
            String id;
            String grpString = PomEdits.getTextValue((Node)PomEdits.findChild((Element)dep, (String)"groupId"));
            if (grpString == null) {
                grpString = "org.apache.maven.plugins";
            }
            String artString = PomEdits.getTextValue((Node)PomEdits.findChild((Element)dep, (String)"artifactId"));
            Element version = PomEdits.findChild((Element)dep, (String)"version");
            String versionString = PomEdits.getTextValue((Node)version);
            if (artString == null || versionString == null || !managed.containsKey(id = Plugin.constructKey((String)grpString, (String)artString))) continue;
            String managedVersion = (String)managed.get(id);
            if (!(version instanceof IndexedRegion) || MarkerLocationService.lookForIgnoreMarker(document, version, off = (IndexedRegion)version, "$NO-MVN-MAN-VER$")) continue;
            String msg = versionString.equals(managedVersion) ? Messages.MavenMarkerManager_redundant_managed_title : Messages.MavenMarkerManager_managed_title;
            IMarker mark = mavenMarkerManager.addMarker(pomFile, type, NLS.bind((String)msg, (Object)managedVersion, (Object)artString), document.getLineOfOffset(off.getStartOffset()) + 1, overridingManagedVersionSeverity.getSeverity());
            mark.setAttribute("editor_hint", (Object)"managed_plugin_override");
            mark.setAttribute("charStart", off.getStartOffset());
            mark.setAttribute("charEnd", off.getEndOffset());
            mark.setAttribute("problemType", (Object)"pomhint");
            mark.setAttribute("groupId", (Object)grpString);
            mark.setAttribute("artifactId", (Object)artString);
            String profile = (String)candidateProfile.get(dep);
            if (profile == null) continue;
            mark.setAttribute("profile", (Object)profile);
        }
    }

    private static void checkParentMatchingGroupIdVersion(IMavenMarkerManager mavenMarkerManager, Element root, IResource pomFile, String type, IStructuredDocument document) throws CoreException {
        Element parent = PomEdits.findChild((Element)root, (String)"parent");
        Element groupId = PomEdits.findChild((Element)root, (String)"groupId");
        ProblemSeverity matchingParentGroupIdSeverity = MarkerLocationService.getMatchingParentGroupIdSeverity();
        if (parent != null && groupId != null && !ProblemSeverity.ignore.equals((Object)matchingParentGroupIdSeverity)) {
            String parentString = PomEdits.getTextValue((Node)PomEdits.findChild((Element)parent, (String)"groupId"));
            String childString = PomEdits.getTextValue((Node)groupId);
            if (parentString != null && parentString.equals(childString) && groupId instanceof IndexedRegion) {
                IndexedRegion off = (IndexedRegion)groupId;
                IMarker mark = mavenMarkerManager.addMarker(pomFile, type, Messages.MavenMarkerManager_duplicate_groupid, document.getLineOfOffset(off.getStartOffset()) + 1, matchingParentGroupIdSeverity.getSeverity());
                mark.setAttribute("editor_hint", (Object)"parent_groupid");
                mark.setAttribute("charStart", off.getStartOffset());
                mark.setAttribute("charEnd", off.getEndOffset());
                mark.setAttribute("problemType", (Object)"pomhint");
            }
        }
        Element version = PomEdits.findChild((Element)root, (String)"version");
        ProblemSeverity matchingParentVersionSeverity = MarkerLocationService.getMatchingParentVersionSeverity();
        if (parent != null && version != null && !ProblemSeverity.ignore.equals((Object)matchingParentVersionSeverity)) {
            String parentString = PomEdits.getTextValue((Node)PomEdits.findChild((Element)parent, (String)"version"));
            String childString = PomEdits.getTextValue((Node)version);
            if (parentString != null && parentString.equals(childString) && version instanceof IndexedRegion) {
                IndexedRegion off = (IndexedRegion)version;
                IMarker mark = mavenMarkerManager.addMarker(pomFile, type, Messages.MavenMarkerManager_duplicate_version, document.getLineOfOffset(off.getStartOffset()) + 1, matchingParentVersionSeverity.getSeverity());
                mark.setAttribute("editor_hint", (Object)"parent_version");
                mark.setAttribute("charStart", off.getStartOffset());
                mark.setAttribute("charEnd", off.getEndOffset());
                mark.setAttribute("problemType", (Object)"pomhint");
            }
        }
    }

    private static ProblemSeverity getMatchingParentGroupIdSeverity() {
        return ProblemSeverity.get((String)M2EUIPluginActivator.getDefault().getPreferenceStore().getString("eclipse.m2.problem.duplicateParentGroupId"));
    }

    private static ProblemSeverity getMatchingParentVersionSeverity() {
        return ProblemSeverity.get((String)M2EUIPluginActivator.getDefault().getPreferenceStore().getString("eclipse.m2.problem.duplicateParentVersion"));
    }

    private static ProblemSeverity getOverridingManagedVersionSeverity() {
        return ProblemSeverity.get((String)M2EUIPluginActivator.getDefault().getPreferenceStore().getString("eclipse.m2.problem.overridingManagedVersion"));
    }

    static void checkVarious(IMavenMarkerManager mavenMarkerManager, IResource pomFile, MavenProject mavenProject, String type) {
        IDOMModel domModel = null;
        try {
            if (!(pomFile instanceof IFile)) {
                return;
            }
            try {
                domModel = (IDOMModel)StructuredModelManager.getModelManager().getModelForRead((IFile)pomFile);
                IStructuredDocument document = domModel.getStructuredDocument();
                Element root = domModel.getDocument().getDocumentElement();
                if (root.getNodeName().equals(PROJECT_NODE)) {
                    MarkerLocationService.checkParentMatchingGroupIdVersion(mavenMarkerManager, root, pomFile, type, document);
                    if (mavenProject != null) {
                        MarkerLocationService.checkManagedDependencies(mavenMarkerManager, root, pomFile, mavenProject, type, document);
                        MarkerLocationService.checkManagedPlugins(mavenMarkerManager, root, pomFile, mavenProject, type, document);
                    }
                }
            }
            catch (Exception t) {
                log.error("Error checking for warnings", (Throwable)t);
            }
        }
        finally {
            if (domModel != null) {
                domModel.releaseFromRead();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean lookForIgnoreMarker(IStructuredDocument document, Element version, IndexedRegion off, String ignoreString) {
        Node reg = version;
        int line = document.getLineOfOffset(off.getStartOffset());
        try {
            int lineend = document.getLineOffset(line) + document.getLineLength(line) - 1;
            int start = off.getStartOffset();
            while (reg != null) {
                Comment comm;
                String data;
                if (start >= lineend) {
                    return false;
                }
                if ((reg = reg.getNextSibling()) != null && reg instanceof Comment && (data = (comm = (Comment)reg).getData()) != null && data.contains(ignoreString)) {
                    return true;
                }
                if (reg == null) continue;
                start = ((IndexedRegion)reg).getStartOffset();
            }
            return false;
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return false;
    }
}

