/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal.wizards;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import org.apache.maven.archetype.catalog.Archetype;
import org.apache.maven.archetype.catalog.ArchetypeCatalog;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.archetype.ArchetypeUtil;
import org.eclipse.m2e.core.embedder.ArtifactKey;
import org.eclipse.m2e.core.embedder.IMaven;
import org.eclipse.m2e.core.internal.MavenPluginActivator;
import org.eclipse.m2e.core.internal.archetype.ArchetypeCatalogFactory;
import org.eclipse.m2e.core.internal.archetype.ArchetypeManager;
import org.eclipse.m2e.core.internal.index.IMutableIndex;
import org.eclipse.m2e.core.internal.index.IndexListener;
import org.eclipse.m2e.core.internal.index.IndexManager;
import org.eclipse.m2e.core.project.ProjectImportConfiguration;
import org.eclipse.m2e.core.repository.IRepository;
import org.eclipse.m2e.core.ui.internal.Messages;
import org.eclipse.m2e.core.ui.internal.util.M2EUIUtils;
import org.eclipse.m2e.core.ui.internal.wizards.AbstractMavenWizardPage;
import org.eclipse.m2e.core.ui.internal.wizards.CustomArchetypeDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenProjectWizardArchetypePage
extends AbstractMavenWizardPage
implements IndexListener {
    private static final Logger log = LoggerFactory.getLogger(MavenProjectWizardArchetypePage.class);
    private static final String KEY_CATALOG = "catalog";
    private static final String ALL_CATALOGS = Messages.MavenProjectWizardArchetypePage_all;
    public static final Comparator<Archetype> ARCHETYPE_COMPARATOR = new Comparator<Archetype>(){

        @Override
        public int compare(Archetype a1, Archetype a2) {
            String i2;
            String g2;
            String g1 = a1.getGroupId();
            int res = g1.compareTo(g2 = a2.getGroupId());
            if (res != 0) {
                return res;
            }
            String i1 = a1.getArtifactId();
            res = i1.compareTo(i2 = a2.getArtifactId());
            if (res != 0) {
                return res;
            }
            String v1 = a1.getVersion();
            String v2 = a2.getVersion();
            if (v1 == null) {
                return v2 == null ? 0 : -1;
            }
            return v1.compareTo(v2);
        }
    };
    private static final boolean DEFAULT_SHOW_LAST_VERSION = true;
    private static final boolean DEFAULT_INCLUDE_SNAPSHOTS = false;
    private Map<String, List<Archetype>> archetypesCache = new HashMap<String, List<Archetype>>();
    ComboViewer catalogsComboViewer;
    Text filterText;
    TableViewer viewer;
    Text descriptionText;
    Button showLastVersionButton;
    Button includeShapshotsButton;
    Button addArchetypeButton;
    volatile Collection<Archetype> archetypes;
    Map<String, List<ArtifactVersion>> archetypeVersions;
    private boolean isUsed = true;
    ArchetypeCatalogFactory catalogFactory = null;
    private RetrievingArchetypesJob job;

    public MavenProjectWizardArchetypePage(ProjectImportConfiguration projectImportConfiguration) {
        super("MavenProjectWizardArchetypePage", projectImportConfiguration);
        this.setTitle(Messages.wizardProjectPageArchetypeTitle);
        this.setDescription(Messages.wizardProjectPageArchetypeDescription);
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        this.archetypesCache.clear();
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        this.createViewer(composite);
        this.createAdvancedSettings(composite, new GridData(4, 128, true, false, 3, 1));
        MavenPlugin.getIndexManager().addIndexListener((IndexListener)this);
        this.setControl((Control)composite);
    }

    private void createViewer(Composite parent) {
        Label catalogsLabel = new Label(parent, 0);
        catalogsLabel.setText(Messages.MavenProjectWizardArchetypePage_lblCatalog);
        Composite catalogsComposite = new Composite(parent, 0);
        GridLayout catalogsCompositeLayout = new GridLayout();
        catalogsCompositeLayout.marginWidth = 0;
        catalogsCompositeLayout.marginHeight = 0;
        catalogsCompositeLayout.numColumns = 2;
        catalogsComposite.setLayout((Layout)catalogsCompositeLayout);
        catalogsComposite.setLayoutData((Object)new GridData(4, 4, false, false, 2, 1));
        this.catalogsComboViewer = new ComboViewer(catalogsComposite);
        this.catalogsComboViewer.getControl().setData("name", (Object)"catalogsCombo");
        this.catalogsComboViewer.getCombo().setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.catalogsComboViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object input) {
                if (input instanceof Collection) {
                    return ((Collection)input).toArray();
                }
                return new Object[0];
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }
        });
        this.catalogsComboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof ArchetypeCatalogFactory) {
                    return ((ArchetypeCatalogFactory)element).getDescription();
                }
                if (element instanceof String) {
                    return element.toString();
                }
                return super.getText(element);
            }
        });
        this.catalogsComboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection) {
                    Object factory = ((IStructuredSelection)selection).getFirstElement();
                    ArchetypeCatalogFactory newCatalogFactory = null;
                    if (factory instanceof ArchetypeCatalogFactory) {
                        newCatalogFactory = (ArchetypeCatalogFactory)factory;
                    }
                    if (Objects.equals(MavenProjectWizardArchetypePage.this.catalogFactory, newCatalogFactory) && MavenProjectWizardArchetypePage.this.viewer.getInput() != null) {
                        return;
                    }
                    MavenProjectWizardArchetypePage.this.catalogFactory = newCatalogFactory;
                    MavenProjectWizardArchetypePage.this.viewer.setInput(null);
                    MavenProjectWizardArchetypePage.this.reloadViewer();
                } else {
                    MavenProjectWizardArchetypePage.this.catalogFactory = null;
                    MavenProjectWizardArchetypePage.this.viewer.setInput(null);
                    MavenProjectWizardArchetypePage.this.loadArchetypes(null, null, null);
                }
                if (MavenProjectWizardArchetypePage.this.dialogSettings != null) {
                    if (MavenProjectWizardArchetypePage.this.catalogFactory != null) {
                        MavenProjectWizardArchetypePage.this.dialogSettings.put(MavenProjectWizardArchetypePage.KEY_CATALOG, MavenProjectWizardArchetypePage.this.catalogFactory.getId());
                    } else {
                        MavenProjectWizardArchetypePage.this.dialogSettings.put(MavenProjectWizardArchetypePage.KEY_CATALOG, ALL_CATALOGS);
                    }
                }
            }
        });
        final ArchetypeManager archetypeManager = MavenPluginActivator.getDefault().getArchetypeManager();
        ArrayList<String> allCatalogs = new ArrayList<String>(archetypeManager.getArchetypeCatalogs());
        allCatalogs.add(0, ALL_CATALOGS);
        this.catalogsComboViewer.setInput(allCatalogs);
        Button configureButton = new Button(catalogsComposite, 0);
        configureButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        configureButton.setText(Messages.MavenProjectWizardArchetypePage_btnConfigure);
        configureButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Collection oldCatalogs = archetypeManager.getArchetypeCatalogs();
                PreferencesUtil.createPreferenceDialogOn((Shell)MavenProjectWizardArchetypePage.this.getShell(), (String)"org.eclipse.m2e.core.preferences.MavenArchetypesPreferencePage", null, null).open();
                Collection newCatalogs = archetypeManager.getArchetypeCatalogs();
                if (MavenProjectWizardArchetypePage.this.catalogFactory != null && !newCatalogs.contains(MavenProjectWizardArchetypePage.this.catalogFactory)) {
                    MavenProjectWizardArchetypePage.this.catalogFactory = null;
                }
                ArchetypeCatalogFactory selectedCatalog = MavenProjectWizardArchetypePage.this.catalogFactory;
                for (ArchetypeCatalogFactory newCatalog : newCatalogs) {
                    if (oldCatalogs.contains(newCatalog)) continue;
                    selectedCatalog = newCatalog;
                    break;
                }
                ArrayList<String> allCatalogs = new ArrayList<String>(newCatalogs);
                allCatalogs.add(0, ALL_CATALOGS);
                MavenProjectWizardArchetypePage.this.catalogsComboViewer.setInput(allCatalogs);
                MavenProjectWizardArchetypePage.this.catalogsComboViewer.setSelection((ISelection)new StructuredSelection((Object)(selectedCatalog == null ? ALL_CATALOGS : selectedCatalog)));
            }
        });
        Label filterLabel = new Label(parent, 0);
        filterLabel.setLayoutData((Object)new GridData());
        filterLabel.setText(Messages.MavenProjectWizardArchetypePage_lblFilter);
        QuickViewerFilter quickViewerFilter = new QuickViewerFilter();
        VersionsFilter versionFilter = new VersionsFilter(true, false);
        this.filterText = new Text(parent, 2176);
        this.filterText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.filterText.addModifyListener((ModifyListener)quickViewerFilter);
        this.filterText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000002) {
                    MavenProjectWizardArchetypePage.this.viewer.getTable().setFocus();
                    MavenProjectWizardArchetypePage.this.viewer.getTable().setSelection(0);
                    MavenProjectWizardArchetypePage.this.viewer.setSelection((ISelection)new StructuredSelection(MavenProjectWizardArchetypePage.this.viewer.getElementAt(0)), true);
                }
            }
        });
        ToolBar toolBar = new ToolBar(parent, 0x800000);
        toolBar.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        final ToolItem clearToolItem = new ToolItem(toolBar, 8);
        clearToolItem.setEnabled(false);
        clearToolItem.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_ELCL_REMOVE"));
        clearToolItem.setDisabledImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_ELCL_REMOVE_DISABLED"));
        clearToolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MavenProjectWizardArchetypePage.this.filterText.setText("");
            }
        });
        this.filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                clearToolItem.setEnabled(MavenProjectWizardArchetypePage.this.filterText.getText().length() > 0);
            }
        });
        SashForm sashForm = new SashForm(parent, 512);
        GridData gd_sashForm = new GridData(4, 4, false, true, 3, 1);
        gd_sashForm.heightHint = 200;
        sashForm.setLayoutData((Object)gd_sashForm);
        sashForm.setLayout((Layout)new GridLayout());
        Composite composite1 = new Composite((Composite)sashForm, 0);
        GridLayout gridLayout1 = new GridLayout();
        gridLayout1.horizontalSpacing = 0;
        gridLayout1.marginWidth = 0;
        gridLayout1.marginHeight = 0;
        composite1.setLayout((Layout)gridLayout1);
        this.viewer = new TableViewer(composite1, 68356);
        Table table = this.viewer.getTable();
        table.setData("name", (Object)"archetypesTable");
        table.setHeaderVisible(true);
        TableColumn column1 = new TableColumn(table, 16384);
        column1.setWidth(150);
        column1.setText(Messages.wizardProjectPageArchetypeColumnGroupId);
        TableColumn column0 = new TableColumn(table, 16384);
        column0.setWidth(150);
        column0.setText(Messages.wizardProjectPageArchetypeColumnArtifactId);
        TableColumn column2 = new TableColumn(table, 16384);
        column2.setWidth(100);
        column2.setText(Messages.wizardProjectPageArchetypeColumnVersion);
        GridData tableData = new GridData(4, 4, true, true);
        tableData.widthHint = 400;
        tableData.heightHint = 200;
        table.setLayoutData((Object)tableData);
        this.viewer.setLabelProvider((IBaseLabelProvider)new ArchetypeLabelProvider());
        this.viewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                return ARCHETYPE_COMPARATOR.compare((Archetype)e1, (Archetype)e2);
            }
        });
        this.viewer.setComparer(new IElementComparer(){

            public int hashCode(Object obj) {
                if (obj instanceof Archetype) {
                    return ArchetypeUtil.getHashCode((Archetype)((Archetype)obj));
                }
                return obj.hashCode();
            }

            public boolean equals(Object one, Object another) {
                if (one instanceof Archetype && another instanceof Archetype) {
                    return ArchetypeUtil.areEqual((Archetype)((Archetype)one), (Archetype)((Archetype)another));
                }
                return one.equals(another);
            }
        });
        this.viewer.setFilters(new ViewerFilter[]{versionFilter, quickViewerFilter});
        this.viewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof Collection) {
                    return ((Collection)inputElement).toArray();
                }
                return new Object[0];
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Archetype archetype = MavenProjectWizardArchetypePage.this.getArchetype();
                if (archetype != null) {
                    String repositoryUrl = archetype.getRepository();
                    String description = archetype.getDescription();
                    String text = description == null ? "" : description;
                    text = text.replaceAll("\n", "").replaceAll("\\s{2,}", " ");
                    if (repositoryUrl != null) {
                        text = String.valueOf(text) + (text.length() > 0 ? "\n" + repositoryUrl : repositoryUrl);
                    }
                    MavenProjectWizardArchetypePage.this.descriptionText.setText(text);
                    MavenProjectWizardArchetypePage.this.setPageComplete(true);
                } else {
                    MavenProjectWizardArchetypePage.this.descriptionText.setText("");
                    MavenProjectWizardArchetypePage.this.setPageComplete(false);
                }
            }
        });
        this.viewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent openevent) {
                if (MavenProjectWizardArchetypePage.this.canFlipToNextPage()) {
                    MavenProjectWizardArchetypePage.this.getContainer().showPage(MavenProjectWizardArchetypePage.this.getNextPage());
                }
            }
        });
        Composite composite2 = new Composite((Composite)sashForm, 0);
        GridLayout gridLayout2 = new GridLayout();
        gridLayout2.marginHeight = 0;
        gridLayout2.marginWidth = 0;
        gridLayout2.horizontalSpacing = 0;
        composite2.setLayout((Layout)gridLayout2);
        this.descriptionText = new Text(composite2, 2634);
        GridData descriptionTextData = new GridData(4, 4, true, true);
        descriptionTextData.heightHint = 40;
        this.descriptionText.setLayoutData((Object)descriptionTextData);
        descriptionTextData.widthHint = 250;
        sashForm.setWeights(new int[]{80, 20});
        Composite buttonComposite = new Composite(parent, 0);
        GridData gd_buttonComposite = new GridData(4, 0x1000000, false, false, 3, 1);
        buttonComposite.setLayoutData((Object)gd_buttonComposite);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.numColumns = 3;
        buttonComposite.setLayout((Layout)gridLayout);
        this.showLastVersionButton = new Button(buttonComposite, 32);
        this.showLastVersionButton.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        this.showLastVersionButton.setText(Messages.MavenProjectWizardArchetypePage_btnLast);
        this.showLastVersionButton.setSelection(true);
        this.showLastVersionButton.addSelectionListener((SelectionListener)versionFilter);
        this.includeShapshotsButton = new Button(buttonComposite, 32);
        GridData buttonData = new GridData(16384, 0x1000000, true, false);
        buttonData.horizontalIndent = 25;
        this.includeShapshotsButton.setLayoutData((Object)buttonData);
        this.includeShapshotsButton.setText(Messages.MavenProjectWizardArchetypePage_btnSnapshots);
        this.includeShapshotsButton.setSelection(false);
        this.includeShapshotsButton.addSelectionListener((SelectionListener)versionFilter);
        this.addArchetypeButton = new Button(buttonComposite, 0);
        this.addArchetypeButton.setText(Messages.MavenProjectWizardArchetypePage_btnAdd);
        this.addArchetypeButton.setData("name", (Object)"addArchetypeButton");
        buttonData = new GridData(131072, 0x1000000, true, false);
        buttonData.horizontalIndent = 35;
        this.addArchetypeButton.setLayoutData((Object)buttonData);
        this.addArchetypeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CustomArchetypeDialog dialog = new CustomArchetypeDialog(MavenProjectWizardArchetypePage.this.getShell(), Messages.MavenProjectWizardArchetypePage_add_title);
                if (dialog.open() == 0) {
                    String archetypeGroupId = dialog.getArchetypeGroupId();
                    String archetypeArtifactId = dialog.getArchetypeArtifactId();
                    String archetypeVersion = dialog.getArchetypeVersion();
                    String repositoryUrl = dialog.getRepositoryUrl();
                    MavenProjectWizardArchetypePage.this.downloadArchetype(archetypeGroupId, archetypeArtifactId, archetypeVersion, repositoryUrl);
                }
            }
        });
    }

    protected IWizardContainer getContainer() {
        return super.getContainer();
    }

    public void addArchetypeSelectionListener(ISelectionChangedListener listener) {
        this.viewer.addSelectionChangedListener(listener);
    }

    @Override
    public void dispose() {
        if (this.job != null) {
            this.job.cancel();
            this.job = null;
        }
        MavenPlugin.getIndexManager().removeIndexListener((IndexListener)this);
        this.archetypesCache.clear();
        super.dispose();
    }

    public List<Archetype> getArchetypesForCatalog() {
        try {
            return this.getArchetypesForCatalog(this.catalogFactory, null);
        }
        catch (CoreException ce) {
            this.setErrorMessage(Messages.MavenProjectWizardArchetypePage_error_read);
            return null;
        }
    }

    public List<Archetype> getArchetypesForCatalog(ArchetypeCatalogFactory archCatalogFactory, IProgressMonitor monitor) throws CoreException {
        if (archCatalogFactory == null) {
            return this.getAllArchetypes(monitor);
        }
        String catalogId = archCatalogFactory.getId();
        List archs = this.archetypesCache.get(catalogId);
        if (archs == null) {
            archs = archCatalogFactory.getArchetypeCatalog().getArchetypes();
            if (archs == null) {
                archs = Collections.emptyList();
            }
            this.archetypesCache.put(catalogId, archs);
        }
        return archs;
    }

    private List<Archetype> getAllArchetypes(IProgressMonitor monitor) {
        ArchetypeManager manager = MavenPluginActivator.getDefault().getArchetypeManager();
        Collection archetypeCatalogs = manager.getArchetypeCatalogs();
        ArrayList<Archetype> list = new ArrayList<Archetype>();
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        for (ArchetypeCatalogFactory catalog : archetypeCatalogs) {
            if (monitor.isCanceled()) {
                return Collections.emptyList();
            }
            try {
                List<Archetype> arcs;
                if (catalog.getDescription().startsWith("Test") || (arcs = this.getArchetypesForCatalog(catalog, monitor)) == null) continue;
                list.addAll(arcs);
            }
            catch (Exception ce) {
                log.error("Unable to read archetype catalog: " + catalog.getId(), (Throwable)ce);
            }
        }
        return list;
    }

    void loadArchetypes(final String groupId, final String artifactId, final String version) {
        if (this.job != null) {
            this.job.cancel();
        }
        this.job = new RetrievingArchetypesJob(this.catalogFactory);
        this.job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                RetrievingArchetypesJob thisJob = (RetrievingArchetypesJob)event.getJob();
                if (8 == event.getResult().getSeverity() || !MavenProjectWizardArchetypePage.this.isCurrentPage()) {
                    return;
                }
                List<Archetype> catalogArchetypes = thisJob.catalogArchetypes;
                final String error = 4 == event.getResult().getSeverity() ? event.getResult().getMessage() : (catalogArchetypes == null || catalogArchetypes.isEmpty() ? (MavenProjectWizardArchetypePage.this.catalogFactory != null && "Nexus Indexer".equals(MavenProjectWizardArchetypePage.this.catalogFactory.getDescription()) ? Messages.MavenProjectWizardArchetypePage_error_emptyNexusIndexer : Messages.MavenProjectWizardArchetypePage_error_emptyCatalog) : null);
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        MavenProjectWizardArchetypePage.this.setErrorMessage(error);
                    }
                });
                TreeSet<Archetype> archs = new TreeSet<Archetype>(ARCHETYPE_COMPARATOR);
                if (catalogArchetypes != null) {
                    archs.addAll(catalogArchetypes);
                }
                MavenProjectWizardArchetypePage.this.archetypes = archs;
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        MavenProjectWizardArchetypePage.this.updateViewer(groupId, artifactId, version);
                    }
                });
            }
        });
        this.job.schedule();
    }

    private static String getArchetypeKey(Archetype archetype) {
        return archetype.getGroupId() + ":" + archetype.getArtifactId();
    }

    ArchetypeCatalog getArchetypeCatalog() throws CoreException {
        return this.catalogFactory == null ? null : this.catalogFactory.getArchetypeCatalog();
    }

    public void setUsed(boolean isUsed) {
        this.isUsed = isUsed;
    }

    public boolean isPageComplete() {
        return !this.isUsed || super.isPageComplete();
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            ArchetypeManager archetypeManager = MavenPluginActivator.getDefault().getArchetypeManager();
            String catalogId = this.dialogSettings.get(KEY_CATALOG);
            this.catalogFactory = null;
            if (catalogId != null && !catalogId.equals(ALL_CATALOGS)) {
                this.catalogFactory = archetypeManager.getArchetypeCatalogFactory(catalogId);
            }
            if (this.catalogsComboViewer.getSelection().isEmpty()) {
                this.catalogsComboViewer.setSelection((ISelection)new StructuredSelection((Object)(this.catalogFactory == null ? ALL_CATALOGS : this.catalogFactory)));
            }
            this.viewer.getTable().setFocus();
            Archetype selected = this.getArchetype();
            if (selected != null) {
                this.viewer.reveal((Object)selected);
            }
        } else if (this.job != null) {
            this.job.cancel();
            this.job = null;
        }
    }

    public Archetype getArchetype() {
        return (Archetype)((IStructuredSelection)this.viewer.getSelection()).getFirstElement();
    }

    void updateViewer(String groupId, String artifactId, String version) {
        if (this.viewer.getControl().isDisposed()) {
            return;
        }
        this.archetypeVersions = MavenProjectWizardArchetypePage.getArchetypeVersions(this.archetypes);
        this.viewer.setInput(this.archetypes);
        if (this.isCurrentPage()) {
            this.selectArchetype(groupId, artifactId, version);
        }
        Table table = this.viewer.getTable();
        int columnCount = table.getColumnCount();
        int width = 0;
        int i = 0;
        while (i < columnCount) {
            TableColumn column = table.getColumn(i);
            column.pack();
            width += column.getWidth();
            ++i;
        }
        GridData tableData = (GridData)table.getLayoutData();
        int oldHint = tableData.widthHint;
        if (width > oldHint) {
            tableData.widthHint = width;
        }
        this.getShell().pack(true);
        tableData.widthHint = oldHint;
    }

    private static Map<String, List<ArtifactVersion>> getArchetypeVersions(Collection<Archetype> archetypes) {
        HashMap<String, List<ArtifactVersion>> archetypeVersions = new HashMap<String, List<ArtifactVersion>>(archetypes.size());
        HashMap<String, ArtifactVersion> versionFactory = new HashMap<String, ArtifactVersion>();
        for (Archetype currentArchetype : archetypes) {
            ArtifactVersion v;
            String version = currentArchetype.getVersion();
            if (M2EUIUtils.nullOrEmpty(version)) continue;
            String key = MavenProjectWizardArchetypePage.getArchetypeKey(currentArchetype);
            List<ArtifactVersion> versions = archetypeVersions.get(key);
            if (versions == null) {
                versions = new ArrayList<ArtifactVersion>();
                archetypeVersions.put(key, versions);
            }
            if ((v = (ArtifactVersion)versionFactory.get(version)) == null) {
                v = new DefaultArtifactVersion(version);
                versionFactory.put(version, v);
            }
            versions.add(v);
        }
        Comparator<ArtifactVersion> comparator = new Comparator<ArtifactVersion>(){

            @Override
            public int compare(ArtifactVersion v1, ArtifactVersion v2) {
                return v2.compareTo((Object)v1);
            }
        };
        for (List versions : archetypeVersions.values()) {
            Collections.sort(versions, comparator);
        }
        return archetypeVersions;
    }

    protected void selectArchetype(String groupId, String artifactId, String version) {
        Archetype archetype = this.findArchetype(groupId, artifactId, version);
        Table table = this.viewer.getTable();
        if (archetype != null) {
            this.viewer.setSelection((ISelection)new StructuredSelection((Object)archetype), true);
            int n = table.getSelectionIndex();
            table.setSelection(n);
        }
    }

    protected Archetype findArchetype(String groupId, String artifactId, String version) {
        for (Archetype archetype : this.archetypes) {
            if (!archetype.getGroupId().equals(groupId) || !archetype.getArtifactId().equals(artifactId) || version != null && !version.equals(archetype.getVersion())) continue;
            return archetype;
        }
        return version == null ? null : this.findArchetype(groupId, artifactId, null);
    }

    protected void downloadArchetype(final String archetypeGroupId, final String archetypeArtifactId, final String archetypeVersion, final String repositoryUrl) {
        if (this.getContainer() == null) {
            return;
        }
        final String archetypeName = String.valueOf(archetypeGroupId) + ":" + archetypeArtifactId + ":" + archetypeVersion;
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InterruptedException {
                    monitor.beginTask(String.valueOf(Messages.MavenProjectWizardArchetypePage_task_downloading) + archetypeName, -1);
                    try {
                        try {
                            List<ArtifactRepository> remoteRepositories;
                            IMaven maven = MavenPlugin.getMaven();
                            if (repositoryUrl.length() == 0) {
                                remoteRepositories = maven.getArtifactRepositories();
                            } else {
                                ArtifactRepository repository = maven.createArtifactRepository(String.valueOf(archetypeArtifactId) + "-repo", repositoryUrl);
                                remoteRepositories = Collections.singletonList(repository);
                            }
                            monitor.subTask(Messages.MavenProjectWizardArchetypePage_task_resolving);
                            Artifact pomArtifact = maven.resolve(archetypeGroupId, archetypeArtifactId, archetypeVersion, "pom", null, remoteRepositories, monitor);
                            monitor.worked(1);
                            if (monitor.isCanceled()) {
                                throw new InterruptedException();
                            }
                            File pomFile = pomArtifact.getFile();
                            if (pomFile.exists()) {
                                monitor.subTask(Messages.MavenProjectWizardArchetypePage_task_resolving2);
                                Artifact jarArtifact = maven.resolve(archetypeGroupId, archetypeArtifactId, archetypeVersion, "jar", null, remoteRepositories, monitor);
                                monitor.worked(1);
                                if (monitor.isCanceled()) {
                                    throw new InterruptedException();
                                }
                                File jarFile = jarArtifact.getFile();
                                monitor.subTask(Messages.MavenProjectWizardArchetypePage_task_reading);
                                monitor.worked(1);
                                if (monitor.isCanceled()) {
                                    throw new InterruptedException();
                                }
                                monitor.subTask(Messages.MavenProjectWizardArchetypePage_task_indexing);
                                IndexManager indexManager = MavenPlugin.getIndexManager();
                                IMutableIndex localIndex = indexManager.getLocalIndex();
                                localIndex.addArtifact(jarFile, new ArtifactKey(pomArtifact));
                                Archetype archetype = new Archetype();
                                archetype.setGroupId(archetypeGroupId);
                                archetype.setArtifactId(archetypeArtifactId);
                                archetype.setVersion(archetypeVersion);
                                archetype.setRepository(repositoryUrl);
                                org.apache.maven.archetype.ArchetypeManager archetyper = MavenPluginActivator.getDefault().getArchetypeManager().getArchetyper();
                                archetyper.updateLocalCatalog(archetype);
                                MavenProjectWizardArchetypePage.this.archetypesCache.clear();
                                MavenProjectWizardArchetypePage.this.loadArchetypes(archetypeGroupId, archetypeArtifactId, archetypeVersion);
                            } else {
                                final Artifact pom = pomArtifact;
                                MavenProjectWizardArchetypePage.this.getShell().getDisplay().asyncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        MavenProjectWizardArchetypePage.this.setErrorMessage(NLS.bind((String)Messages.MavenProjectWizardArchetypePage_error_resolve, (Object)pom.toString()));
                                    }
                                });
                            }
                        }
                        catch (InterruptedException ex) {
                            throw ex;
                        }
                        catch (Exception ex) {
                            final String msg = NLS.bind((String)Messages.MavenProjectWizardArchetypePage_error_resolve2, (Object)archetypeName);
                            log.error(msg, (Throwable)ex);
                            MavenProjectWizardArchetypePage.this.getShell().getDisplay().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    MavenProjectWizardArchetypePage.this.setErrorMessage(String.valueOf(msg) + "\n" + ex.toString());
                                }
                            });
                            monitor.done();
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            });
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException ex) {
            String msg = NLS.bind((String)Messages.MavenProjectWizardArchetypePage_error_resolve2, (Object)archetypeName);
            log.error(msg, (Throwable)ex);
            this.setErrorMessage(String.valueOf(msg) + "\n" + ex.toString());
        }
    }

    public void indexAdded(IRepository repository) {
    }

    protected void reloadViewer() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (MavenProjectWizardArchetypePage.this.isCurrentPage()) {
                    StructuredSelection sel = (StructuredSelection)MavenProjectWizardArchetypePage.this.viewer.getSelection();
                    Archetype selArchetype = null;
                    if (sel != null && sel.getFirstElement() != null) {
                        selArchetype = (Archetype)sel.getFirstElement();
                    }
                    if (selArchetype != null) {
                        MavenProjectWizardArchetypePage.this.loadArchetypes(selArchetype.getGroupId(), selArchetype.getArtifactId(), selArchetype.getVersion());
                    } else {
                        MavenProjectWizardArchetypePage.this.loadArchetypes("org.apache.maven.archetypes", "maven-archetype-quickstart", "1.0");
                    }
                }
            }
        });
    }

    public void indexChanged(IRepository repository) {
        this.reloadViewer();
    }

    public void indexRemoved(IRepository repository) {
    }

    public void indexUpdating(IRepository repository) {
    }

    protected static class ArchetypeLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        protected ArchetypeLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof Archetype) {
                Archetype archetype = (Archetype)element;
                switch (columnIndex) {
                    case 0: {
                        return archetype.getGroupId();
                    }
                    case 1: {
                        return archetype.getArtifactId();
                    }
                    case 2: {
                        return archetype.getVersion();
                    }
                }
            }
            return super.getText(element);
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }
    }

    protected class QuickViewerFilter
    extends ViewerFilter
    implements ModifyListener {
        private String currentFilter;

        protected QuickViewerFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (this.currentFilter == null || this.currentFilter.length() == 0) {
                return true;
            }
            Archetype archetype = (Archetype)element;
            return archetype.getGroupId().toLowerCase().indexOf(this.currentFilter) > -1 || archetype.getArtifactId().toLowerCase().indexOf(this.currentFilter) > -1;
        }

        public void modifyText(ModifyEvent e) {
            this.currentFilter = MavenProjectWizardArchetypePage.this.filterText.getText().trim().toLowerCase();
            MavenProjectWizardArchetypePage.this.viewer.refresh();
        }
    }

    private class RetrievingArchetypesJob
    extends Job {
        List<Archetype> catalogArchetypes;
        private ArchetypeCatalogFactory archetypeCatalogFactory;

        public RetrievingArchetypesJob(ArchetypeCatalogFactory catalogFactory) {
            super(Messages.wizardProjectPageArchetypeRetrievingArchetypes);
            this.archetypeCatalogFactory = catalogFactory;
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                this.catalogArchetypes = MavenProjectWizardArchetypePage.this.getArchetypesForCatalog(this.archetypeCatalogFactory, monitor);
            }
            catch (Exception e) {
                monitor.done();
                return new Status(4, "org.eclipse.m2e.core.ui", Messages.MavenProjectWizardArchetypePage_ErrorRetrievingArchetypes, (Throwable)e);
            }
            return monitor.isCanceled() ? Status.CANCEL_STATUS : Status.OK_STATUS;
        }
    }

    protected class VersionsFilter
    extends ViewerFilter
    implements SelectionListener {
        private boolean showLastVersion;
        private boolean includeSnapshots;

        public VersionsFilter(boolean showLastVersion, boolean includeSnapshots) {
            this.showLastVersion = showLastVersion;
            this.includeSnapshots = includeSnapshots;
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (!(element instanceof Archetype)) {
                return false;
            }
            Archetype archetype = (Archetype)element;
            String version = archetype.getVersion();
            if (!this.includeSnapshots && this.isSnapshotVersion(version)) {
                return false;
            }
            if (!this.showLastVersion) {
                return true;
            }
            List<ArtifactVersion> versions = MavenProjectWizardArchetypePage.this.archetypeVersions.get(MavenProjectWizardArchetypePage.getArchetypeKey(archetype));
            if (versions == null || versions.isEmpty()) {
                return false;
            }
            for (ArtifactVersion otherVersion : versions) {
                if (!this.includeSnapshots && this.isSnapshotVersion(otherVersion.toString())) continue;
                if (!otherVersion.toString().equals(version)) break;
                return true;
            }
            return false;
        }

        boolean isSnapshotVersion(String version) {
            return !M2EUIUtils.nullOrEmpty(version) && version.endsWith("SNAPSHOT");
        }

        public void widgetSelected(SelectionEvent e) {
            this.showLastVersion = MavenProjectWizardArchetypePage.this.showLastVersionButton.getSelection();
            this.includeSnapshots = MavenProjectWizardArchetypePage.this.includeShapshotsButton.getSelection();
            MavenProjectWizardArchetypePage.this.viewer.refresh();
            Archetype archetype = MavenProjectWizardArchetypePage.this.getArchetype();
            if (archetype != null) {
                MavenProjectWizardArchetypePage.this.viewer.reveal((Object)archetype);
            }
            MavenProjectWizardArchetypePage.this.viewer.getTable().setSelection(MavenProjectWizardArchetypePage.this.viewer.getTable().getSelectionIndex());
            MavenProjectWizardArchetypePage.this.viewer.getTable().setFocus();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }
}

